/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.core.models.common.IServerParent;
import io.apicurio.datamodels.core.models.common.Server;
import io.apicurio.datamodels.openapi.v3.models.Oas30Server;
import java.util.ArrayList;
import java.util.List;

public class DeleteAllServersCommand
extends AbstractCommand {
    public NodePath _parentPath;
    @JsonDeserialize(contentUsing=MarshallCompat.NullableJsonNodeDeserializer.class)
    public List<Object> _oldServers;

    DeleteAllServersCommand() {
    }

    DeleteAllServersCommand(IServerParent parent) {
        this._parentPath = Library.createNodePath((Node)((Object)parent));
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[DeleteAllServersCommand] Executing.", new Object[0]);
        this._oldServers = new ArrayList<Object>();
        IServerParent parent = (IServerParent)((Object)this._parentPath.resolve(document));
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        List<Server> servers = parent.getServers();
        if (!this.isNullOrUndefined(servers)) {
            servers.forEach(server -> this._oldServers.add(Library.writeNode(server)));
        }
        NodeCompat.setProperty(parent, "servers", new ArrayList());
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[DeleteAllServersCommand] Reverting.", new Object[0]);
        if (this._oldServers.size() == 0) {
            return;
        }
        IServerParent parent = (IServerParent)((Object)this._parentPath.resolve(document));
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        List<Server> servers = parent.getServers();
        if (this.isNullOrUndefined(servers)) {
            servers = new ArrayList<Server>();
            NodeCompat.setProperty(parent, "servers", servers);
        }
        for (Object oldServer : this._oldServers) {
            Oas30Server server = (Oas30Server)parent.createServer();
            Library.readNode(oldServer, server);
            servers.add(server);
        }
    }
}

