/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.validation.rules.invalid.value;

import io.apicurio.datamodels.core.models.common.Operation;
import io.apicurio.datamodels.core.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.core.validation.rules.invalid.value.OasInvalidPropertyValueRule;
import io.apicurio.datamodels.openapi.v3.models.Oas30Operation;

public class OasUnexpectedRequestBodyRule
extends OasInvalidPropertyValueRule {
    public OasUnexpectedRequestBodyRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    protected boolean isValidRequestBodyOperation(Oas30Operation operation) {
        String method = operation.getMethod();
        return this.isValidEnumItem(method, this.array("put", "post", "options", "patch"));
    }

    @Override
    public void visitOperation(Operation node) {
        Oas30Operation operation = (Oas30Operation)node;
        if (this.hasValue(operation.requestBody)) {
            this.reportIfInvalid(this.isValidRequestBodyOperation(operation), operation, "requestBody", this.map("method", operation.getMethod().toUpperCase()));
        }
    }
}

