/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.util;

import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.compat.RegexCompat;
import io.apicurio.datamodels.core.models.IIndexedNode;
import io.apicurio.datamodels.core.models.Node;
import java.util.ArrayList;
import java.util.List;

public class ReferenceResolver {
    private List<Node> visitedNodes = new ArrayList<Node>();

    public Node resolveRef(String $ref, Node from) {
        this.visitedNodes = new ArrayList<Node>();
        return this.resolveRefInternal($ref, from);
    }

    private Node resolveRefInternal(String $ref, Node from) {
        if ($ref == null) {
            return null;
        }
        List<String[]> split = RegexCompat.findMatches($ref, "([^/]+)/?");
        Object cnode = null;
        for (String[] mi : split) {
            String seg = mi[1];
            if (NodeCompat.equals(seg, "#")) {
                cnode = from.ownerDocument();
                continue;
            }
            if (cnode == null) continue;
            if (cnode instanceof IIndexedNode) {
                cnode = ((IIndexedNode)cnode).getItem(seg);
                continue;
            }
            cnode = NodeCompat.getProperty(cnode, seg);
        }
        try {
            if (cnode == null) {
                return null;
            }
            if (this.visitedNodes.indexOf(cnode) != -1) {
                return null;
            }
            this.visitedNodes.add((Node)cnode);
            String another$ref = (String)NodeCompat.getProperty(cnode, "$ref");
            if (another$ref != null) {
                return this.resolveRefInternal(another$ref, (Node)cnode);
            }
            return (Node)cnode;
        }
        catch (Throwable t) {
            return null;
        }
    }
}

