/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.openapi.models;

import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.common.ExternalDocumentation;
import io.apicurio.datamodels.core.models.common.IExternalDocumentationParent;
import io.apicurio.datamodels.core.models.common.Schema;
import io.apicurio.datamodels.openapi.models.OasXML;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class OasSchema
extends Schema
implements IExternalDocumentationParent {
    public String format;
    public String title;
    public String description;
    public Object default_;
    public Number multipleOf;
    public Number maximum;
    public Boolean exclusiveMaximum;
    public Number minimum;
    public Boolean exclusiveMinimum;
    public Number maxLength;
    public Number minLength;
    public String pattern;
    public Number maxItems;
    public Number minItems;
    public Boolean uniqueItems;
    public Number maxProperties;
    public Number minProperties;
    public List<String> required;
    public List<String> enum_;
    public String type;
    public Object items;
    public List<OasSchema> allOf;
    public Map<String, OasSchema> properties;
    public Object additionalProperties;
    public Boolean readOnly;
    public OasXML xml;
    public ExternalDocumentation externalDocs;
    public Object example;

    @Override
    public abstract ExternalDocumentation createExternalDocumentation();

    @Override
    public void setExternalDocumentation(ExternalDocumentation externalDocs) {
        this.externalDocs = externalDocs;
    }

    public abstract OasXML createXML();

    public abstract OasSchema createAllOfSchema();

    public abstract OasSchema createItemsSchema();

    public abstract OasSchema createAdditionalPropertiesSchema();

    public abstract OasSchema createPropertySchema(String var1);

    public List<String> getPropertyNames() {
        ArrayList<String> rval = new ArrayList<String>();
        if (this.properties != null) {
            rval.addAll(this.properties.keySet());
        }
        return rval;
    }

    public List<OasSchema> getProperties() {
        ArrayList<OasSchema> rval = new ArrayList<OasSchema>();
        if (this.properties != null) {
            rval.addAll(this.properties.values());
        }
        return rval;
    }

    public OasSchema addProperty(String propertyName, OasSchema schema) {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, OasSchema>();
        }
        this.properties.put(propertyName, schema);
        return schema;
    }

    public OasSchema removeProperty(String propertyName) {
        if (this.properties != null) {
            return this.properties.remove(propertyName);
        }
        return null;
    }

    public OasSchema getProperty(String propertyName) {
        if (this.properties != null) {
            return this.properties.get(propertyName);
        }
        return null;
    }

    public boolean hasItemsSchema() {
        return NodeCompat.isNode(this.items);
    }

    public boolean hasItemsSchemas() {
        return NodeCompat.isList(this.items);
    }

    public boolean hasAdditionalPropertiesSchema() {
        return NodeCompat.isNode(this.additionalProperties);
    }

    public boolean hasAdditionalPropertiesBoolean() {
        return this.additionalProperties != null && !NodeCompat.isNode(this.additionalProperties);
    }

    public void addAllOfSchema(OasSchema schema) {
        if (this.allOf == null) {
            this.allOf = new ArrayList<OasSchema>();
        }
        this.allOf.add(schema);
    }

    public void removeAllOfSchema(OasSchema schema) {
        if (this.allOf != null) {
            this.allOf.remove(schema);
        }
    }
}

