/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.io;

import io.apicurio.datamodels.asyncapi.models.AaiParameter;
import io.apicurio.datamodels.compat.JsonCompat;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.ExtensibleNode;
import io.apicurio.datamodels.core.models.Extension;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.common.Contact;
import io.apicurio.datamodels.core.models.common.ExternalDocumentation;
import io.apicurio.datamodels.core.models.common.Info;
import io.apicurio.datamodels.core.models.common.License;
import io.apicurio.datamodels.core.models.common.OAuthFlow;
import io.apicurio.datamodels.core.models.common.OAuthFlows;
import io.apicurio.datamodels.core.models.common.Operation;
import io.apicurio.datamodels.core.models.common.Parameter;
import io.apicurio.datamodels.core.models.common.Schema;
import io.apicurio.datamodels.core.models.common.SecurityRequirement;
import io.apicurio.datamodels.core.models.common.SecurityScheme;
import io.apicurio.datamodels.core.models.common.Server;
import io.apicurio.datamodels.core.models.common.ServerVariable;
import io.apicurio.datamodels.core.models.common.Tag;
import java.util.ArrayList;
import java.util.List;

public abstract class DataModelReader {
    protected void readExtensions(Object json, ExtensibleNode node) {
        JsonCompat.keys(json).forEach(key -> {
            if (key.startsWith("x-")) {
                Extension extension = node.createExtension();
                extension.name = key;
                extension.value = JsonCompat.consumePropertyObject(json, key);
                node.addExtension((String)key, extension);
            }
        });
    }

    protected void readExtraProperties(Object json, Node node) {
        JsonCompat.keys(json).forEach(key -> {
            Object value = JsonCompat.consumePropertyObject(json, key);
            node.addExtraProperty((String)key, value);
            LoggerCompat.warn("Found unexpected data model property: %s", key);
        });
    }

    public void readDocument(Object json, Document node) {
        Object info = JsonCompat.consumeProperty(json, "info");
        List<Object> tags = JsonCompat.consumePropertyArray(json, "tags");
        Object externalDocs = JsonCompat.consumeProperty(json, "externalDocs");
        if (info != null) {
            node.info = node.createInfo();
            this.readInfo(info, node.info);
        }
        if (tags != null) {
            ArrayList<Tag> tagModels = new ArrayList<Tag>();
            for (Object tag : tags) {
                Tag tagModel = node.createTag();
                this.readTag(tag, tagModel);
                tagModels.add(tagModel);
            }
            node.tags = tagModels;
        }
        if (externalDocs != null) {
            node.externalDocs = node.createExternalDocumentation();
            this.readExternalDocumentation(externalDocs, node.externalDocs);
        }
        this.readExtensions(json, node);
        this.readExtraProperties(json, node);
    }

    public void readInfo(Object json, Info node) {
        String title = JsonCompat.consumePropertyString(json, "title");
        String description = JsonCompat.consumePropertyString(json, "description");
        String termsOfService = JsonCompat.consumePropertyString(json, "termsOfService");
        Object contact = JsonCompat.consumeProperty(json, "contact");
        Object license = JsonCompat.consumeProperty(json, "license");
        String version = JsonCompat.consumePropertyString(json, "version");
        node.title = title;
        node.description = description;
        node.termsOfService = termsOfService;
        node.version = version;
        if (contact != null) {
            node.contact = node.createContact();
            this.readContact(contact, node.contact);
        }
        if (license != null) {
            node.license = node.createLicense();
            this.readLicense(license, node.license);
        }
        this.readExtensions(json, node);
        this.readExtraProperties(json, node);
    }

    public void readContact(Object json, Contact node) {
        String name = JsonCompat.consumePropertyString(json, "name");
        String url = JsonCompat.consumePropertyString(json, "url");
        String email = JsonCompat.consumePropertyString(json, "email");
        node.name = name;
        node.url = url;
        node.email = email;
        this.readExtensions(json, node);
        this.readExtraProperties(json, node);
    }

    public void readLicense(Object json, License node) {
        String name = JsonCompat.consumePropertyString(json, "name");
        String url = JsonCompat.consumePropertyString(json, "url");
        node.name = name;
        node.url = url;
        this.readExtensions(json, node);
        this.readExtraProperties(json, node);
    }

    public void readTag(Object json, Tag node) {
        String name = JsonCompat.consumePropertyString(json, "name");
        String description = JsonCompat.consumePropertyString(json, "description");
        Object externalDocs = JsonCompat.consumeProperty(json, "externalDocs");
        node.name = name;
        node.description = description;
        if (externalDocs != null) {
            ExternalDocumentation externalDocsModel = node.createExternalDocumentation();
            this.readExternalDocumentation(externalDocs, externalDocsModel);
            node.externalDocs = externalDocsModel;
        }
        this.readExtensions(json, node);
        this.readExtraProperties(json, node);
    }

    public void readServer(Object json, Server node) {
        String url = JsonCompat.consumePropertyString(json, "url");
        String description = JsonCompat.consumePropertyString(json, "description");
        Object variables = JsonCompat.consumeProperty(json, "variables");
        node.url = url;
        node.description = description;
        if (variables != null) {
            JsonCompat.keys(variables).forEach(key -> {
                Object serverVariable = JsonCompat.consumeProperty(variables, key);
                ServerVariable serverVariableModel = node.createServerVariable((String)key);
                this.readServerVariable(serverVariable, serverVariableModel);
                node.addServerVariable((String)key, serverVariableModel);
            });
        }
        this.readExtensions(json, node);
        this.readExtraProperties(json, node);
    }

    public void readServerVariable(Object json, ServerVariable node) {
        List<String> enum_ = JsonCompat.consumePropertyStringArray(json, "enum");
        String default_ = JsonCompat.consumePropertyString(json, "default");
        String description = JsonCompat.consumePropertyString(json, "description");
        node.enum_ = enum_;
        node.default_ = default_;
        node.description = description;
        this.readExtensions(json, node);
        this.readExtraProperties(json, node);
    }

    public void readSecurityRequirement(Object json, SecurityRequirement node) {
        JsonCompat.keys(json).forEach(key -> {
            List<String> scopes = JsonCompat.consumePropertyStringArray(json, key);
            node.addSecurityRequirementItem((String)key, scopes);
        });
    }

    public void readSecurityScheme(Object json, SecurityScheme node) {
        String type = JsonCompat.consumePropertyString(json, "type");
        String description = JsonCompat.consumePropertyString(json, "description");
        String name = JsonCompat.consumePropertyString(json, "name");
        String in = JsonCompat.consumePropertyString(json, "in");
        node.type = type;
        node.description = description;
        node.name = name;
        node.in = in;
        this.readExtensions(json, node);
        this.readExtraProperties(json, node);
    }

    public void readExternalDocumentation(Object json, ExternalDocumentation node) {
        String description = JsonCompat.consumePropertyString(json, "description");
        String url = JsonCompat.consumePropertyString(json, "url");
        node.description = description;
        node.url = url;
        this.readExtensions(json, node);
        this.readExtraProperties(json, node);
    }

    public void readSchema(Object json, Schema node) {
        String $ref;
        node.$ref = $ref = JsonCompat.consumePropertyString(json, "$ref");
        this.readExtensions(json, node);
        this.readExtraProperties(json, node);
    }

    public void readAaiParameter(Object json, AaiParameter node) {
        String $ref = JsonCompat.consumePropertyString(json, "$ref");
        String description = JsonCompat.consumePropertyString(json, "description");
        Object schema = JsonCompat.consumeProperty(json, "schema");
        String location = JsonCompat.consumePropertyString(json, "location");
        node.$ref = $ref;
        node.description = description;
        node.schema = schema;
        node.location = location;
        this.readExtensions(json, node);
        this.readExtraProperties(json, node);
    }

    public void readParameter(Object json, Parameter node) {
        String $ref = JsonCompat.consumePropertyString(json, "$ref");
        String name = JsonCompat.consumePropertyString(json, "name");
        String description = JsonCompat.consumePropertyString(json, "description");
        Object schema = JsonCompat.consumeProperty(json, "schema");
        node.$ref = $ref;
        node.name = name;
        node.description = description;
        if (schema != null) {
            node.schema = node.createSchema();
            this.readSchema(schema, node.schema);
        }
        this.readExtensions(json, node);
        this.readExtraProperties(json, node);
    }

    public void readOperation(Object json, Operation node) {
        String operationId = JsonCompat.consumePropertyString(json, "operationId");
        String summary = JsonCompat.consumePropertyString(json, "summary");
        String description = JsonCompat.consumePropertyString(json, "description");
        Object externalDocs = JsonCompat.consumeProperty(json, "externalDocs");
        node.operationId = operationId;
        node.summary = summary;
        node.description = description;
        if (externalDocs != null) {
            node.externalDocs = node.createExternalDocumentation();
            this.readExternalDocumentation(externalDocs, node.externalDocs);
        }
        this.readExtensions(json, node);
        this.readExtraProperties(json, node);
    }

    public void readOAuthFlows(Object json, OAuthFlows node) {
        Object implicit = JsonCompat.consumeProperty(json, "implicit");
        Object password = JsonCompat.consumeProperty(json, "password");
        Object clientCredentials = JsonCompat.consumeProperty(json, "clientCredentials");
        Object authorizationCode = JsonCompat.consumeProperty(json, "authorizationCode");
        if (implicit != null) {
            node.implicit = node.createImplicitOAuthFlow();
            this.readOAuthFlow(implicit, node.implicit);
        }
        if (password != null) {
            node.password = node.createPasswordOAuthFlow();
            this.readOAuthFlow(password, node.password);
        }
        if (clientCredentials != null) {
            node.clientCredentials = node.createClientCredentialsOAuthFlow();
            this.readOAuthFlow(clientCredentials, node.clientCredentials);
        }
        if (authorizationCode != null) {
            node.authorizationCode = node.createAuthorizationCodeOAuthFlow();
            this.readOAuthFlow(authorizationCode, node.authorizationCode);
        }
        this.readExtensions(json, node);
        this.readExtraProperties(json, node);
    }

    public void readOAuthFlow(Object json, OAuthFlow node) {
        String authorizationUrl = JsonCompat.consumePropertyString(json, "authorizationUrl");
        String tokenUrl = JsonCompat.consumePropertyString(json, "tokenUrl");
        String refreshUrl = JsonCompat.consumePropertyString(json, "refreshUrl");
        Object scopes = JsonCompat.consumeProperty(json, "scopes");
        node.authorizationUrl = authorizationUrl;
        node.tokenUrl = tokenUrl;
        node.refreshUrl = refreshUrl;
        if (scopes != null) {
            JsonCompat.keys(scopes).forEach(scope -> {
                String description = JsonCompat.consumePropertyString(scopes, scope);
                node.addScope((String)scope, description);
            });
        }
        this.readExtensions(json, node);
        this.readExtraProperties(json, node);
    }
}

