/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.openapi.models.IOasPropertySchema;
import io.apicurio.datamodels.openapi.models.OasSchema;
import java.util.ArrayList;

public class DeletePropertyCommand
extends AbstractCommand {
    public String _propertyName;
    public NodePath _propertyPath;
    public NodePath _schemaPath;
    public Object _oldProperty;
    public boolean _oldRequired;

    DeletePropertyCommand() {
    }

    DeletePropertyCommand(IOasPropertySchema property) {
        this._propertyName = property.getPropertyName();
        this._propertyPath = Library.createNodePath((Node)((Object)property));
        this._schemaPath = Library.createNodePath(((Node)((Object)property)).parent());
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[DeletePropertyCommand] Executing.", new Object[0]);
        this._oldProperty = null;
        IOasPropertySchema property = (IOasPropertySchema)((Object)this._propertyPath.resolve(document));
        if (this.isNullOrUndefined(property)) {
            return;
        }
        OasSchema schema = (OasSchema)((Node)((Object)property)).parent();
        this._oldProperty = Library.writeNode(schema.removeProperty(this._propertyName));
        boolean bl = this._oldRequired = ModelUtils.isDefined(schema.required) && schema.required.indexOf(this._propertyName) != -1;
        if (this._oldRequired) {
            schema.required.remove(schema.required.indexOf(this._propertyName));
        }
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[DeletePropertyCommand] Reverting.", new Object[0]);
        if (this.isNullOrUndefined(this._oldProperty)) {
            return;
        }
        OasSchema schema = (OasSchema)this._schemaPath.resolve(document);
        if (this.isNullOrUndefined(schema)) {
            return;
        }
        OasSchema propSchema = schema.createPropertySchema(this._propertyName);
        Library.readNode(this._oldProperty, propSchema);
        schema.addProperty(this._propertyName, propSchema);
        if (this._oldRequired) {
            if (this.isNullOrUndefined(schema.required)) {
                schema.required = new ArrayList<String>();
            }
            schema.required.add(this._propertyName);
        }
    }
}

