/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.openapi.v3.models.Oas30Example;
import io.apicurio.datamodels.openapi.v3.models.Oas30Parameter;

public class DeleteParameterExampleCommand_30
extends AbstractCommand {
    public String _exampleName;
    public NodePath _parameterPath;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _oldExample;

    DeleteParameterExampleCommand_30() {
    }

    DeleteParameterExampleCommand_30(Oas30Example example) {
        this._exampleName = example.getName();
        this._parameterPath = Library.createNodePath(example.parent());
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[DeleteExampleCommand] Executing.", new Object[0]);
        this._oldExample = null;
        Oas30Parameter parameter = (Oas30Parameter)this._parameterPath.resolve(document);
        if (this.isNullOrUndefined(parameter) || this.isNullOrUndefined(parameter.getExample(this._exampleName))) {
            LoggerCompat.debug("[DeleteExampleCommand] No example named: " + this._exampleName, new Object[0]);
            return;
        }
        Oas30Example example = parameter.removeExample(this._exampleName);
        this._oldExample = Library.writeNode(example);
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[DeleteExampleCommand] Reverting.", new Object[0]);
        if (this.isNullOrUndefined(this._oldExample)) {
            return;
        }
        Oas30Parameter parameter = (Oas30Parameter)this._parameterPath.resolve(document);
        if (this.isNullOrUndefined(parameter)) {
            LoggerCompat.info("[DeleteExampleCommand] No parameter found.", new Object[0]);
            return;
        }
        Oas30Example example = parameter.createExample(this._exampleName);
        Library.readNode(this._oldExample, example);
        parameter.addExample(example);
    }
}

