/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.cmd.commands.RenameSchemaDefinitionCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30SchemaDefinition;

public class RenameSchemaDefinitionCommand_30
extends RenameSchemaDefinitionCommand {
    RenameSchemaDefinitionCommand_30() {
    }

    RenameSchemaDefinitionCommand_30(String oldName, String newName) {
        super(oldName, newName);
    }

    @Override
    protected String _nameToReference(String name) {
        return "#/components/schemas/" + name;
    }

    @Override
    protected boolean _renameSchemaDefinition(OasDocument document, String fromName, String toName) {
        Oas30Document doc30 = (Oas30Document)document;
        if (this.isNullOrUndefined(doc30.components) || this.isNullOrUndefined(doc30.components.schemas)) {
            return false;
        }
        if (ModelUtils.isDefined(doc30.components.getSchemaDefinition(toName))) {
            return false;
        }
        Oas30SchemaDefinition schemaDef = doc30.components.removeSchemaDefinition(fromName);
        schemaDef.rename(toName);
        doc30.components.addSchemaDefinition(toName, schemaDef);
        return true;
    }
}

