/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.cmd.commands.ChangeParameterTypeCommand;
import io.apicurio.datamodels.cmd.models.SimplifiedParameterType;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.cmd.util.SimplifiedTypeUtil;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.common.Parameter;
import io.apicurio.datamodels.openapi.v2.models.Oas20Parameter;
import io.apicurio.datamodels.openapi.v2.models.Oas20Schema;

public class ChangeParameterTypeCommand_20
extends ChangeParameterTypeCommand {
    ChangeParameterTypeCommand_20() {
    }

    ChangeParameterTypeCommand_20(Parameter parameter, SimplifiedParameterType newType) {
        super(parameter, newType);
    }

    @Override
    protected void doChangeParameter(Document document, Parameter parameter) {
        Oas20Parameter param = (Oas20Parameter)parameter;
        if (NodeCompat.equals(param.in, "body")) {
            param.schema = param.createSchema();
            SimplifiedTypeUtil.setSimplifiedType((Oas20Schema)param.schema, this._newType);
        } else {
            SimplifiedTypeUtil.setSimplifiedTypeOnParam(param, this._newType);
        }
        Boolean required = this._newType.required;
        if (NodeCompat.equals(param.in, "path")) {
            required = true;
        }
        if (!this.isNullOrUndefined(required)) {
            param.required = required;
        }
    }

    @Override
    protected void doRestoreParameter(Parameter parameter, Parameter oldParameter) {
        Oas20Parameter param = (Oas20Parameter)parameter;
        Oas20Parameter oldParam = (Oas20Parameter)oldParameter;
        if (NodeCompat.equals(param.in, "body")) {
            param.schema = oldParam.schema;
            if (ModelUtils.isDefined(param.schema)) {
                param.schema._parent = param;
                param.schema._ownerDocument = param.ownerDocument();
            }
        } else {
            param.type = oldParam.type;
            param.format = oldParam.format;
            param.items = oldParam.items;
            if (ModelUtils.isDefined(param.items)) {
                param.items._parent = param;
                param.items._ownerDocument = param.ownerDocument();
            }
        }
        param.required = oldParam.required;
    }
}

