/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.model.ExpressionSubElementDefinition;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RedeliveryPolicyDefinition;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.spi.AsPredicate;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.ExpressionToPredicateAdapter;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="error")
@XmlRootElement(name="onException")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class OnExceptionDefinition
extends OutputDefinition<OnExceptionDefinition> {
    @XmlElement(name="exception", required=true)
    private List<String> exceptions = new ArrayList<String>();
    @XmlElement(name="onWhen")
    @AsPredicate
    private WhenDefinition onWhen;
    @XmlElement(name="retryWhile")
    @AsPredicate
    private ExpressionSubElementDefinition retryWhile;
    @XmlElement(name="redeliveryPolicy")
    private RedeliveryPolicyDefinition redeliveryPolicyType;
    @XmlAttribute(name="redeliveryPolicyRef")
    private String redeliveryPolicyRef;
    @XmlElement(name="handled")
    @AsPredicate
    private ExpressionSubElementDefinition handled;
    @XmlElement(name="continued")
    @AsPredicate
    private ExpressionSubElementDefinition continued;
    @XmlAttribute(name="onRedeliveryRef")
    private String onRedeliveryRef;
    @XmlAttribute(name="onExceptionOccurredRef")
    private String onExceptionOccurredRef;
    @XmlAttribute(name="useOriginalMessage")
    @Metadata(javaType="java.lang.Boolean")
    private String useOriginalMessage;
    @XmlAttribute(name="useOriginalBody")
    @Metadata(javaType="java.lang.Boolean")
    private String useOriginalBody;
    @XmlTransient
    private Predicate handledPolicy;
    @XmlTransient
    private Predicate continuedPolicy;
    @XmlTransient
    private Predicate retryWhilePolicy;
    @XmlTransient
    private Processor onRedelivery;
    @XmlTransient
    private Processor onExceptionOccurred;
    @XmlTransient
    private boolean routeScoped = true;

    public OnExceptionDefinition() {
    }

    public OnExceptionDefinition(List<Class<? extends Throwable>> exceptionClasses) {
        this.exceptions.addAll(exceptionClasses.stream().map(Class::getName).collect(Collectors.toList()));
    }

    public OnExceptionDefinition(Class<? extends Throwable> exceptionType) {
        this.exceptions.add(exceptionType.getName());
    }

    public void setRouteScoped(boolean routeScoped) {
        this.routeScoped = routeScoped;
    }

    public boolean isRouteScoped() {
        return this.routeScoped;
    }

    @Override
    public void setParent(ProcessorDefinition<?> parent) {
        if (this.routeScoped) {
            super.setParent(parent);
        }
    }

    @Override
    public String toString() {
        return "OnException[" + this.description() + " -> " + this.getOutputs() + "]";
    }

    protected String description() {
        return this.getExceptions() + (this.onWhen != null ? " " + this.onWhen : "");
    }

    @Override
    public String getShortName() {
        return "onException";
    }

    @Override
    public String getLabel() {
        return "onException[" + this.description() + "]";
    }

    @Override
    public boolean isAbstract() {
        return true;
    }

    @Override
    public boolean isTopLevelOnly() {
        return true;
    }

    public void validateConfiguration() {
        if (this.isInheritErrorHandler() != null && this.isInheritErrorHandler().booleanValue()) {
            throw new IllegalArgumentException(this + " cannot have the inheritErrorHandler option set to true");
        }
        if (this.exceptions == null || this.exceptions.isEmpty()) {
            throw new IllegalArgumentException("At least one exception must be configured on " + this);
        }
        if (!(this.getHandledPolicy() == null && this.getHandled() == null || this.getContinuedPolicy() == null && this.getContinued() == null)) {
            throw new IllegalArgumentException("Only one of handled or continued is allowed to be configured on: " + this);
        }
        if (Boolean.toString(true).equals(this.useOriginalMessage) && Boolean.toString(true).equals(this.useOriginalBody)) {
            throw new IllegalArgumentException("Cannot set both useOriginalMessage and useOriginalBody on: " + this);
        }
        if (this.outputs == null || this.getOutputs().isEmpty()) {
            ObjectHelper.firstNotNull((Object[])new Object[]{this.handledPolicy, this.handled, this.continuedPolicy, this.continued, this.retryWhilePolicy, this.retryWhile, this.redeliveryPolicyType, this.useOriginalMessage, this.useOriginalBody, this.onRedeliveryRef, this.onRedelivery, this.onExceptionOccurred}).orElseThrow(() -> new IllegalArgumentException(this + " is not configured."));
        }
    }

    @Override
    public OnExceptionDefinition onException(Class<? extends Throwable> exceptionType) {
        this.getExceptions().add(exceptionType.getName());
        return this;
    }

    public OnExceptionDefinition handled(boolean handled) {
        Expression expression = ExpressionBuilder.constantExpression((Object)Boolean.toString(handled));
        return this.handled(expression);
    }

    public OnExceptionDefinition handled(@AsPredicate Predicate handled) {
        this.setHandledPolicy(handled);
        return this;
    }

    public OnExceptionDefinition handled(@AsPredicate Expression handled) {
        this.setHandledPolicy(ExpressionToPredicateAdapter.toPredicate((Expression)handled));
        return this;
    }

    public OnExceptionDefinition continued(boolean continued) {
        Expression expression = ExpressionBuilder.constantExpression((Object)Boolean.toString(continued));
        return this.continued(expression);
    }

    public OnExceptionDefinition continued(@AsPredicate Predicate continued) {
        this.setContinuedPolicy(continued);
        return this;
    }

    public OnExceptionDefinition continued(@AsPredicate Expression continued) {
        this.setContinuedPolicy(ExpressionToPredicateAdapter.toPredicate((Expression)continued));
        return this;
    }

    public OnExceptionDefinition onWhen(@AsPredicate Predicate predicate) {
        this.setOnWhen(new WhenDefinition(predicate));
        return this;
    }

    public OnExceptionDefinition retryWhile(@AsPredicate Predicate retryWhile) {
        this.setRetryWhilePolicy(retryWhile);
        return this;
    }

    public OnExceptionDefinition backOffMultiplier(double backOffMultiplier) {
        this.getOrCreateRedeliveryPolicy().useExponentialBackOff();
        this.getOrCreateRedeliveryPolicy().backOffMultiplier(backOffMultiplier);
        return this;
    }

    public OnExceptionDefinition backOffMultiplier(String backOffMultiplier) {
        this.getOrCreateRedeliveryPolicy().useExponentialBackOff();
        this.getOrCreateRedeliveryPolicy().backOffMultiplier(backOffMultiplier);
        return this;
    }

    public OnExceptionDefinition collisionAvoidanceFactor(double collisionAvoidanceFactor) {
        this.getOrCreateRedeliveryPolicy().useCollisionAvoidance();
        this.getOrCreateRedeliveryPolicy().collisionAvoidanceFactor(collisionAvoidanceFactor);
        return this;
    }

    public OnExceptionDefinition collisionAvoidanceFactor(String collisionAvoidanceFactor) {
        this.getOrCreateRedeliveryPolicy().useCollisionAvoidance();
        this.getOrCreateRedeliveryPolicy().collisionAvoidanceFactor(collisionAvoidanceFactor);
        return this;
    }

    public OnExceptionDefinition collisionAvoidancePercent(double collisionAvoidancePercent) {
        this.getOrCreateRedeliveryPolicy().useCollisionAvoidance();
        this.getOrCreateRedeliveryPolicy().collisionAvoidancePercent(collisionAvoidancePercent);
        return this;
    }

    public OnExceptionDefinition redeliveryDelay(long delay) {
        this.getOrCreateRedeliveryPolicy().redeliveryDelay(delay);
        return this;
    }

    public OnExceptionDefinition redeliveryDelay(String delay) {
        this.getOrCreateRedeliveryPolicy().redeliveryDelay(delay);
        return this;
    }

    public OnExceptionDefinition asyncDelayedRedelivery() {
        this.getOrCreateRedeliveryPolicy().asyncDelayedRedelivery();
        return this;
    }

    public OnExceptionDefinition retriesExhaustedLogLevel(LoggingLevel retriesExhaustedLogLevel) {
        this.getOrCreateRedeliveryPolicy().retriesExhaustedLogLevel(retriesExhaustedLogLevel);
        return this;
    }

    public OnExceptionDefinition retryAttemptedLogLevel(LoggingLevel retryAttemptedLogLevel) {
        this.getOrCreateRedeliveryPolicy().retryAttemptedLogLevel(retryAttemptedLogLevel);
        return this;
    }

    public OnExceptionDefinition logStackTrace(boolean logStackTrace) {
        this.getOrCreateRedeliveryPolicy().logStackTrace(logStackTrace);
        return this;
    }

    public OnExceptionDefinition logStackTrace(String logStackTrace) {
        this.getOrCreateRedeliveryPolicy().logStackTrace(logStackTrace);
        return this;
    }

    public OnExceptionDefinition logRetryStackTrace(boolean logRetryStackTrace) {
        this.getOrCreateRedeliveryPolicy().logRetryStackTrace(logRetryStackTrace);
        return this;
    }

    public OnExceptionDefinition logRetryStackTrace(String logRetryStackTrace) {
        this.getOrCreateRedeliveryPolicy().logRetryStackTrace(logRetryStackTrace);
        return this;
    }

    public OnExceptionDefinition logHandled(boolean logHandled) {
        this.getOrCreateRedeliveryPolicy().logHandled(logHandled);
        return this;
    }

    public OnExceptionDefinition logHandled(String logHandled) {
        this.getOrCreateRedeliveryPolicy().logHandled(logHandled);
        return this;
    }

    public OnExceptionDefinition logNewException(boolean logNewException) {
        this.getOrCreateRedeliveryPolicy().logNewException(logNewException);
        return this;
    }

    public OnExceptionDefinition logNewException(String logNewException) {
        this.getOrCreateRedeliveryPolicy().logNewException(logNewException);
        return this;
    }

    public OnExceptionDefinition logContinued(boolean logContinued) {
        this.getOrCreateRedeliveryPolicy().logContinued(logContinued);
        return this;
    }

    public OnExceptionDefinition logContinued(String logContinued) {
        this.getOrCreateRedeliveryPolicy().logContinued(logContinued);
        return this;
    }

    public OnExceptionDefinition logRetryAttempted(boolean logRetryAttempted) {
        this.getOrCreateRedeliveryPolicy().logRetryAttempted(logRetryAttempted);
        return this;
    }

    public OnExceptionDefinition logRetryAttempted(String logRetryAttempted) {
        this.getOrCreateRedeliveryPolicy().logRetryAttempted(logRetryAttempted);
        return this;
    }

    public OnExceptionDefinition logExhausted(boolean logExhausted) {
        this.getOrCreateRedeliveryPolicy().logExhausted(logExhausted);
        return this;
    }

    public OnExceptionDefinition logExhausted(String logExhausted) {
        this.getOrCreateRedeliveryPolicy().logExhausted(logExhausted);
        return this;
    }

    public OnExceptionDefinition logExhaustedMessageHistory(boolean logExhaustedMessageHistory) {
        this.getOrCreateRedeliveryPolicy().logExhaustedMessageHistory(logExhaustedMessageHistory);
        return this;
    }

    public OnExceptionDefinition logExhaustedMessageHistory(String logExhaustedMessageHistory) {
        this.getOrCreateRedeliveryPolicy().logExhaustedMessageHistory(logExhaustedMessageHistory);
        return this;
    }

    public OnExceptionDefinition logExhaustedMessageBody(boolean logExhaustedMessageBody) {
        this.getOrCreateRedeliveryPolicy().logExhaustedMessageBody(logExhaustedMessageBody);
        return this;
    }

    public OnExceptionDefinition logExhaustedMessageBody(String logExhaustedMessageBody) {
        this.getOrCreateRedeliveryPolicy().logExhaustedMessageBody(logExhaustedMessageBody);
        return this;
    }

    public OnExceptionDefinition maximumRedeliveries(int maximumRedeliveries) {
        this.getOrCreateRedeliveryPolicy().maximumRedeliveries(maximumRedeliveries);
        return this;
    }

    public OnExceptionDefinition maximumRedeliveries(String maximumRedeliveries) {
        this.getOrCreateRedeliveryPolicy().maximumRedeliveries(maximumRedeliveries);
        return this;
    }

    public OnExceptionDefinition useCollisionAvoidance() {
        this.getOrCreateRedeliveryPolicy().useCollisionAvoidance();
        return this;
    }

    public OnExceptionDefinition useExponentialBackOff() {
        this.getOrCreateRedeliveryPolicy().useExponentialBackOff();
        return this;
    }

    public OnExceptionDefinition maximumRedeliveryDelay(long maximumRedeliveryDelay) {
        this.getOrCreateRedeliveryPolicy().maximumRedeliveryDelay(maximumRedeliveryDelay);
        return this;
    }

    public OnExceptionDefinition maximumRedeliveryDelay(String maximumRedeliveryDelay) {
        this.getOrCreateRedeliveryPolicy().maximumRedeliveryDelay(maximumRedeliveryDelay);
        return this;
    }

    public OnExceptionDefinition redeliveryPolicyRef(String redeliveryPolicyRef) {
        this.setRedeliveryPolicyRef(redeliveryPolicyRef);
        return this;
    }

    public OnExceptionDefinition delayPattern(String delayPattern) {
        this.getOrCreateRedeliveryPolicy().setDelayPattern(delayPattern);
        return this;
    }

    public OnExceptionDefinition useOriginalMessage() {
        this.setUseOriginalMessage(Boolean.toString(true));
        return this;
    }

    public OnExceptionDefinition useOriginalBody() {
        this.setUseOriginalBody(Boolean.toString(true));
        return this;
    }

    public OnExceptionDefinition onRedelivery(Processor processor) {
        this.setOnRedelivery(processor);
        return this;
    }

    public OnExceptionDefinition onRedeliveryRef(String ref) {
        this.setOnRedeliveryRef(ref);
        return this;
    }

    public OnExceptionDefinition onExceptionOccurred(Processor processor) {
        this.setOnExceptionOccurred(processor);
        return this;
    }

    public OnExceptionDefinition onExceptionOccurredRef(String ref) {
        this.setOnExceptionOccurredRef(ref);
        return this;
    }

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return this.outputs;
    }

    @Override
    @XmlElementRef
    public void setOutputs(List<ProcessorDefinition<?>> outputs) {
        super.setOutputs(outputs);
    }

    public List<String> getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(List<String> exceptions) {
        this.exceptions = exceptions;
    }

    public RedeliveryPolicyDefinition getRedeliveryPolicyType() {
        return this.redeliveryPolicyType;
    }

    public void setRedeliveryPolicyType(RedeliveryPolicyDefinition redeliveryPolicyType) {
        this.redeliveryPolicyType = redeliveryPolicyType;
    }

    public String getRedeliveryPolicyRef() {
        return this.redeliveryPolicyRef;
    }

    public void setRedeliveryPolicyRef(String redeliveryPolicyRef) {
        this.redeliveryPolicyRef = redeliveryPolicyRef;
    }

    public Predicate getHandledPolicy() {
        return this.handledPolicy;
    }

    public void setHandled(ExpressionSubElementDefinition handled) {
        this.handled = handled;
    }

    public ExpressionSubElementDefinition getContinued() {
        return this.continued;
    }

    public void setContinued(ExpressionSubElementDefinition continued) {
        this.continued = continued;
    }

    public ExpressionSubElementDefinition getHandled() {
        return this.handled;
    }

    public void setHandledPolicy(Predicate handledPolicy) {
        this.handledPolicy = handledPolicy;
    }

    public Predicate getContinuedPolicy() {
        return this.continuedPolicy;
    }

    public void setContinuedPolicy(Predicate continuedPolicy) {
        this.continuedPolicy = continuedPolicy;
    }

    public WhenDefinition getOnWhen() {
        return this.onWhen;
    }

    public void setOnWhen(WhenDefinition onWhen) {
        this.onWhen = onWhen;
    }

    public ExpressionSubElementDefinition getRetryWhile() {
        return this.retryWhile;
    }

    public void setRetryWhile(ExpressionSubElementDefinition retryWhile) {
        this.retryWhile = retryWhile;
    }

    public Predicate getRetryWhilePolicy() {
        return this.retryWhilePolicy;
    }

    public void setRetryWhilePolicy(Predicate retryWhilePolicy) {
        this.retryWhilePolicy = retryWhilePolicy;
    }

    public Processor getOnRedelivery() {
        return this.onRedelivery;
    }

    public void setOnRedelivery(Processor onRedelivery) {
        this.onRedelivery = onRedelivery;
    }

    public String getOnRedeliveryRef() {
        return this.onRedeliveryRef;
    }

    public void setOnRedeliveryRef(String onRedeliveryRef) {
        this.onRedeliveryRef = onRedeliveryRef;
    }

    public Processor getOnExceptionOccurred() {
        return this.onExceptionOccurred;
    }

    public void setOnExceptionOccurred(Processor onExceptionOccurred) {
        this.onExceptionOccurred = onExceptionOccurred;
    }

    public String getOnExceptionOccurredRef() {
        return this.onExceptionOccurredRef;
    }

    public void setOnExceptionOccurredRef(String onExceptionOccurredRef) {
        this.onExceptionOccurredRef = onExceptionOccurredRef;
    }

    public String getUseOriginalMessage() {
        return this.useOriginalMessage;
    }

    public void setUseOriginalMessage(String useOriginalMessage) {
        this.useOriginalMessage = useOriginalMessage;
    }

    public String getUseOriginalBody() {
        return this.useOriginalBody;
    }

    public void setUseOriginalBody(String useOriginalBody) {
        this.useOriginalBody = useOriginalBody;
    }

    protected RedeliveryPolicyDefinition getOrCreateRedeliveryPolicy() {
        if (this.redeliveryPolicyType == null) {
            this.redeliveryPolicyType = new RedeliveryPolicyDefinition();
        }
        return this.redeliveryPolicyType;
    }
}

