/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.SimpleBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.language.SimpleExpression;
import org.apache.camel.model.language.XPathExpression;
import org.apache.camel.spi.ExpressionResultTypeAware;

public final class ExpressionNodeHelper {
    private ExpressionNodeHelper() {
    }

    public static ExpressionDefinition toExpressionDefinition(Expression expression) {
        if (expression instanceof SimpleBuilder) {
            SimpleBuilder builder = (SimpleBuilder)expression;
            SimpleExpression answer = new SimpleExpression(builder.getText());
            answer.setResultType(builder.getResultType());
            return answer;
        }
        if (expression instanceof ExpressionResultTypeAware && expression.getClass().getName().equals("org.apache.camel.language.xpath.XPathBuilder")) {
            ExpressionResultTypeAware aware = (ExpressionResultTypeAware)expression;
            XPathExpression answer = new XPathExpression(expression);
            answer.setExpression(aware.getExpressionText());
            answer.setResultType(answer.getResultType());
            return answer;
        }
        if (expression instanceof ValueBuilder) {
            ValueBuilder builder = (ValueBuilder)expression;
            expression = builder.getExpression();
        }
        if (expression instanceof ExpressionDefinition) {
            return (ExpressionDefinition)expression;
        }
        return new ExpressionDefinition(expression);
    }

    public static ExpressionDefinition toExpressionDefinition(Predicate predicate) {
        ValueBuilder builder;
        Expression expression;
        if (predicate instanceof SimpleBuilder) {
            SimpleBuilder builder2 = (SimpleBuilder)predicate;
            SimpleExpression answer = new SimpleExpression(builder2.getText());
            answer.setExpression(builder2.getText());
            return answer;
        }
        if (predicate instanceof ExpressionResultTypeAware && predicate.getClass().getName().equals("org.apache.camel.language.xpath.XPathBuilder")) {
            ExpressionResultTypeAware aware = (ExpressionResultTypeAware)predicate;
            Expression expression2 = (Expression)predicate;
            XPathExpression answer = new XPathExpression(expression2);
            answer.setExpression(aware.getExpressionText());
            answer.setResultType(answer.getResultType());
            return answer;
        }
        if (predicate instanceof ValueBuilder && (expression = (builder = (ValueBuilder)predicate).getExpression()) instanceof Predicate) {
            predicate = (Predicate)expression;
        }
        if (predicate instanceof ExpressionDefinition) {
            return (ExpressionDefinition)predicate;
        }
        return new ExpressionDefinition(predicate);
    }
}

