/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector;

import java.math.BigDecimal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.PollingConsumer;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.camel.kafkaconnector.VersionUtil;
import org.apache.camel.kafkaconnector.utils.CamelKafkaConnectMain;
import org.apache.camel.kafkaconnector.utils.SchemaHelper;
import org.apache.camel.kafkaconnector.utils.TaskHelper;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.source.SourceTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelSourceTask
extends SourceTask {
    public static final String HEADER_CAMEL_PREFIX = "CamelHeader.";
    public static final String PROPERTY_CAMEL_PREFIX = "CamelProperty.";
    private static final Logger LOG = LoggerFactory.getLogger(CamelSourceTask.class);
    private static final String CAMEL_SOURCE_ENDPOINT_PROPERTIES_PREFIX = "camel.source.endpoint.";
    private static final String CAMEL_SOURCE_PATH_PROPERTIES_PREFIX = "camel.source.path.";
    private static final String LOCAL_URL = "direct:end";
    private CamelKafkaConnectMain cms;
    private PollingConsumer consumer;
    private String[] topics;
    private Long maxBatchPollSize;
    private Long maxPollDuration;
    private String camelMessageHeaderKey;
    private LoggingLevel loggingLevel = LoggingLevel.OFF;
    private boolean mapProperties;
    private boolean mapHeaders;

    public String version() {
        return VersionUtil.getVersion();
    }

    public void start(Map<String, String> props) {
        try {
            LOG.info("Starting CamelSourceTask connector task");
            Map<String, String> actualProps = TaskHelper.combineDefaultAndLoadedProperties(this.getDefaultConfig(), props);
            CamelSourceConnectorConfig config = this.getCamelSourceConnectorConfig(actualProps);
            String levelStr = config.getString("camel.source.contentLogLevel");
            try {
                this.loggingLevel = LoggingLevel.valueOf((String)levelStr.toUpperCase());
            }
            catch (Exception e) {
                LOG.error("Invalid value {} for {} property", (Object)levelStr.toUpperCase(), (Object)"camel.source.contentLogLevel");
            }
            this.maxBatchPollSize = config.getLong("camel.source.maxBatchPollSize");
            this.maxPollDuration = config.getLong("camel.source.maxPollDuration");
            this.camelMessageHeaderKey = config.getString("camel.source.camelMessageHeaderKey");
            String remoteUrl = config.getString("camel.source.url");
            String unmarshaller = config.getString("camel.source.unmarshal");
            String marshaller = config.getString("camel.source.marshal");
            int size = config.getInt("camel.aggregation.size");
            long timeout = config.getLong("camel.aggregation.timeout");
            int maxRedeliveries = config.getInt("camel.error.handler.max.redeliveries");
            long redeliveryDelay = config.getLong("camel.error.handler.redelivery.delay");
            String errorHandler = config.getString("camel.error.handler");
            Boolean idempotencyEnabled = config.getBoolean("camel.idempotency.enabled");
            String expressionType = config.getString("camel.idempotency.expression.type");
            String expressionHeader = config.getString("camel.idempotency.expression.header");
            int memoryDimension = config.getInt("camel.idempotency.memory.dimension");
            String idempotentRepositoryType = config.getString("camel.idempotency.repository.type");
            String idempotentRepositoryKafkaTopic = config.getString("camel.idempotency.kafka.topic");
            String idempotentRepositoryBootstrapServers = config.getString("camel.idempotency.kafka.bootstrap.servers");
            int idempotentRepositoryKafkaMaxCacheSize = config.getInt("camel.idempotency.kafka.max.cache.size");
            int idempotentRepositoryKafkaPollDuration = config.getInt("camel.idempotency.kafka.poll.duration.ms");
            String headersRemovePattern = config.getString("camel.remove.headers.pattern");
            this.mapProperties = config.getBoolean("camel.map.properties");
            this.mapHeaders = config.getBoolean("camel.map.headers");
            this.topics = config.getString("topics").split(",");
            String localUrl = this.getLocalUrlWithPollingOptions(config);
            DefaultCamelContext camelContext = new DefaultCamelContext();
            if (remoteUrl == null) {
                remoteUrl = TaskHelper.buildUrl((CamelContext)camelContext, actualProps, config.getString("camel.source.component"), CAMEL_SOURCE_ENDPOINT_PROPERTIES_PREFIX, CAMEL_SOURCE_PATH_PROPERTIES_PREFIX);
            }
            this.cms = CamelKafkaConnectMain.builder(remoteUrl, localUrl).withProperties(actualProps).withUnmarshallDataFormat(unmarshaller).withMarshallDataFormat(marshaller).withAggregationSize(size).withAggregationTimeout(timeout).withErrorHandler(errorHandler).withMaxRedeliveries(maxRedeliveries).withRedeliveryDelay(redeliveryDelay).withIdempotencyEnabled(idempotencyEnabled).withExpressionType(expressionType).withExpressionHeader(expressionHeader).withMemoryDimension(memoryDimension).withIdempotentRepositoryType(idempotentRepositoryType).withIdempotentRepositoryTopicName(idempotentRepositoryKafkaTopic).withIdempotentRepositoryKafkaServers(idempotentRepositoryBootstrapServers).withIdempotentRepositoryKafkaMaxCacheSize(idempotentRepositoryKafkaMaxCacheSize).withIdempotentRepositoryKafkaPollDuration(idempotentRepositoryKafkaPollDuration).withHeadersExcludePattern(headersRemovePattern).build((CamelContext)camelContext);
            this.consumer = this.cms.getCamelContext().getEndpoint(localUrl).createPollingConsumer();
            this.consumer.start();
            this.cms.start();
            LOG.info("CamelSourceTask connector task started");
        }
        catch (Exception e) {
            throw new ConnectException("Failed to create and start Camel context", (Throwable)e);
        }
    }

    private long remaining(long startPollEpochMilli, long maxPollDuration) {
        return maxPollDuration - (Instant.now().toEpochMilli() - startPollEpochMilli);
    }

    public synchronized List<SourceRecord> poll() {
        Exchange exchange;
        long startPollEpochMilli = Instant.now().toEpochMilli();
        long remaining = this.remaining(startPollEpochMilli, this.maxPollDuration);
        ArrayList<SourceRecord> records = new ArrayList<SourceRecord>();
        for (long collectedRecords = 0L; collectedRecords < this.maxBatchPollSize && remaining > 0L && (exchange = this.consumer.receive(remaining)) != null; ++collectedRecords) {
            LOG.debug("Received Exchange {} with Message {} from Endpoint {}", new Object[]{exchange.getExchangeId(), exchange.getMessage().getMessageId(), exchange.getFromEndpoint()});
            Map<String, String> sourcePartition = Collections.singletonMap("filename", exchange.getFromEndpoint().toString());
            Map<String, String> sourceOffset = Collections.singletonMap("position", exchange.getExchangeId());
            Object messageHeaderKey = this.camelMessageHeaderKey != null ? exchange.getMessage().getHeader(this.camelMessageHeaderKey) : null;
            Object messageBodyValue = exchange.getMessage().getBody();
            SchemaBuilder messageKeySchema = messageHeaderKey != null ? SchemaHelper.buildSchemaBuilderForType(messageHeaderKey) : null;
            SchemaBuilder messageBodySchema = messageBodyValue != null ? SchemaHelper.buildSchemaBuilderForType(messageBodyValue) : null;
            long timestamp = this.calculateTimestamp(exchange);
            for (String singleTopic : this.topics) {
                SourceRecord record = new SourceRecord(sourcePartition, sourceOffset, singleTopic, null, (Schema)messageKeySchema, messageHeaderKey, (Schema)messageBodySchema, messageBodyValue, Long.valueOf(timestamp));
                if (this.mapHeaders && exchange.getMessage().hasHeaders()) {
                    this.setAdditionalHeaders(record, exchange.getMessage().getHeaders(), HEADER_CAMEL_PREFIX);
                }
                if (this.mapProperties && exchange.hasProperties()) {
                    this.setAdditionalHeaders(record, exchange.getProperties(), PROPERTY_CAMEL_PREFIX);
                }
                TaskHelper.logRecordContent(LOG, this.loggingLevel, record);
                records.add(record);
            }
            remaining = this.remaining(startPollEpochMilli, this.maxPollDuration);
        }
        return records.isEmpty() ? null : records;
    }

    public void stop() {
        LOG.info("Stopping CamelSourceTask connector task");
        try {
            if (this.consumer != null) {
                this.consumer.stop();
            } else {
                LOG.warn("A critical error may have occurred and there is no consumer to stop");
            }
        }
        catch (Exception e) {
            LOG.error("Error stopping camel consumer: {}", (Object)e.getMessage());
        }
        try {
            if (this.cms != null) {
                this.cms.stop();
            } else {
                LOG.warn("A fatal exception may have occurred and the Camel main was not created");
            }
        }
        catch (Exception e) {
            throw new ConnectException("Failed to stop Camel context", (Throwable)e);
        }
        finally {
            LOG.info("CamelSourceTask connector task stopped");
        }
    }

    protected CamelSourceConnectorConfig getCamelSourceConnectorConfig(Map<String, String> props) {
        return new CamelSourceConnectorConfig(props);
    }

    protected Map<String, String> getDefaultConfig() {
        return Collections.emptyMap();
    }

    protected static String getCamelSourceEndpointConfigPrefix() {
        return CAMEL_SOURCE_ENDPOINT_PROPERTIES_PREFIX;
    }

    protected static String getCamelSourcePathConfigPrefix() {
        return CAMEL_SOURCE_PATH_PROPERTIES_PREFIX;
    }

    protected long calculateTimestamp(Exchange exchange) {
        return System.currentTimeMillis();
    }

    private void setAdditionalHeaders(SourceRecord record, Map<String, Object> map, String prefix) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            String keyCamelHeader = prefix + key;
            if (value instanceof String) {
                record.headers().addString(keyCamelHeader, (String)value);
                continue;
            }
            if (value instanceof Boolean) {
                record.headers().addBoolean(keyCamelHeader, ((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Byte) {
                record.headers().addByte(keyCamelHeader, ((Byte)value).byteValue());
                continue;
            }
            if (value instanceof Byte[]) {
                Byte[] array = (Byte[])value;
                byte[] bytes = new byte[array.length];
                for (int i = 0; i < array.length; ++i) {
                    bytes[i] = array[i];
                }
                record.headers().addBytes(keyCamelHeader, bytes);
                continue;
            }
            if (value instanceof Date) {
                record.headers().addTimestamp(keyCamelHeader, (Date)value);
                continue;
            }
            if (value instanceof BigDecimal) {
                Schema schema = Decimal.schema((int)((BigDecimal)value).scale());
                record.headers().add(keyCamelHeader, (Object)Decimal.fromLogical((Schema)schema, (BigDecimal)((BigDecimal)value)), schema);
                continue;
            }
            if (value instanceof Double) {
                record.headers().addDouble(keyCamelHeader, ((Double)value).doubleValue());
                continue;
            }
            if (value instanceof Float) {
                record.headers().addFloat(keyCamelHeader, ((Float)value).floatValue());
                continue;
            }
            if (value instanceof Integer) {
                record.headers().addInt(keyCamelHeader, ((Integer)value).intValue());
                continue;
            }
            if (value instanceof Long) {
                record.headers().addLong(keyCamelHeader, ((Long)value).longValue());
                continue;
            }
            if (!(value instanceof Short)) continue;
            record.headers().addShort(keyCamelHeader, ((Short)value).shortValue());
        }
    }

    private String getLocalUrlWithPollingOptions(CamelSourceConnectorConfig config) {
        long pollingConsumerQueueSize = config.getLong("camel.source.pollingConsumerQueueSize");
        long pollingConsumerBlockTimeout = config.getLong("camel.source.pollingConsumerBlockTimeout");
        boolean pollingConsumerBlockWhenFull = config.getBoolean("camel.source.pollingConsumerBlockWhenFull");
        return "direct:end?pollingConsumerQueueSize=" + pollingConsumerQueueSize + "&pollingConsumerBlockTimeout=" + pollingConsumerBlockTimeout + "&pollingConsumerBlockWhenFull=" + pollingConsumerBlockWhenFull;
    }

    CamelKafkaConnectMain getCms() {
        return this.cms;
    }

    public LoggingLevel getLoggingLevel() {
        return this.loggingLevel;
    }

    public void setLoggingLevel(LoggingLevel loggingLevel) {
        this.loggingLevel = loggingLevel;
    }
}

