/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer.support.classic;

import java.util.Set;
import org.apache.camel.component.kafka.consumer.support.KafkaRecordProcessor;
import org.apache.camel.component.kafka.consumer.support.classic.PartitionAssignmentAdapter;
import org.apache.camel.spi.StateRepository;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffsetPartitionAssignmentAdapter
implements PartitionAssignmentAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(OffsetPartitionAssignmentAdapter.class);
    private final StateRepository<String, String> offsetRepository;
    private Consumer<?, ?> consumer;

    public OffsetPartitionAssignmentAdapter(StateRepository<String, String> offsetRepository) {
        this.offsetRepository = offsetRepository;
    }

    @Override
    public void setConsumer(Consumer<?, ?> consumer) {
        this.consumer = consumer;
    }

    private void resumeFromOffset(Consumer<?, ?> consumer, TopicPartition topicPartition, String offsetState) {
        long offset = KafkaRecordProcessor.deserializeOffsetValue(offsetState) + 1L;
        LOG.debug("Resuming partition {} from offset {} from state", (Object)topicPartition.partition(), (Object)offset);
        consumer.seek(topicPartition, offset);
    }

    @Override
    public void handlePartitionAssignment() {
        Set assignments = this.consumer.assignment();
        for (TopicPartition topicPartition : assignments) {
            String offsetState = (String)this.offsetRepository.getState((Object)KafkaRecordProcessor.serializeOffsetKey(topicPartition));
            if (offsetState == null || offsetState.isEmpty()) continue;
            this.resumeFromOffset(this.consumer, topicPartition, offsetState);
        }
    }
}

