/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.reactive.streams;

import java.util.Collection;
import java.util.Collections;
import java.util.Deque;

public enum ReactiveStreamsBackpressureStrategy {
    BUFFER{

        @Override
        public <T> Collection<T> update(Deque<T> buffer, T newItem) {
            buffer.addLast(newItem);
            return Collections.emptySet();
        }
    }
    ,
    OLDEST{

        @Override
        public <T> Collection<T> update(Deque<T> buffer, T newItem) {
            if (!buffer.isEmpty()) {
                return Collections.singletonList(newItem);
            }
            buffer.addLast(newItem);
            return Collections.emptySet();
        }
    }
    ,
    LATEST{

        @Override
        public <T> Collection<T> update(Deque<T> buffer, T newItem) {
            Collection discarded = Collections.emptySet();
            if (!buffer.isEmpty()) {
                discarded = Collections.singletonList(buffer.removeFirst());
            }
            buffer.addLast(newItem);
            return discarded;
        }
    };


    public abstract <T> Collection<T> update(Deque<T> var1, T var2);
}

