/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.reactive.streams.engine;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.component.reactive.streams.ReactiveStreamsBackpressureStrategy;
import org.apache.camel.component.reactive.streams.ReactiveStreamsComponent;
import org.apache.camel.component.reactive.streams.ReactiveStreamsEndpoint;
import org.apache.camel.component.reactive.streams.ReactiveStreamsHelper;
import org.apache.camel.component.reactive.streams.ReactiveStreamsProducer;
import org.apache.camel.component.reactive.streams.api.DispatchCallback;
import org.apache.camel.component.reactive.streams.engine.CamelSubscription;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelPublisher
implements Publisher<Exchange>,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(CamelPublisher.class);
    private final ExecutorService workerPool;
    private final String name;
    private final List<CamelSubscription> subscriptions = new CopyOnWriteArrayList<CamelSubscription>();
    private ReactiveStreamsBackpressureStrategy backpressureStrategy;
    private ReactiveStreamsProducer producer;

    public CamelPublisher(ExecutorService workerPool, CamelContext context, String name) {
        this.workerPool = workerPool;
        this.backpressureStrategy = ((ReactiveStreamsComponent)context.getComponent("reactive-streams")).getBackpressureStrategy();
        this.name = name;
    }

    public void subscribe(Subscriber<? super Exchange> subscriber) {
        Objects.requireNonNull(subscriber, "subscriber must not be null");
        CamelSubscription sub = new CamelSubscription(UUID.randomUUID().toString(), this.workerPool, this, this.name, this.backpressureStrategy, subscriber);
        this.subscriptions.add(sub);
        subscriber.onSubscribe((Subscription)sub);
    }

    public void unsubscribe(CamelSubscription subscription) {
        this.subscriptions.remove(subscription);
    }

    public void publish(Exchange data) {
        DispatchCallback<Exchange> originalCallback;
        LinkedList<CamelSubscription> subs = new LinkedList<CamelSubscription>(this.subscriptions);
        DispatchCallback<Exchange> callback = originalCallback = ReactiveStreamsHelper.getCallback(data);
        if (originalCallback != null && subs.size() > 0) {
            AtomicInteger counter = new AtomicInteger(subs.size());
            AtomicReference<Object> thrown = new AtomicReference<Object>(null);
            callback = ReactiveStreamsHelper.attachCallback(data, (exchange, error) -> {
                thrown.compareAndSet(null, error);
                if (counter.decrementAndGet() == 0) {
                    originalCallback.processed((Exchange)exchange, (Throwable)thrown.get());
                }
            });
        }
        if (subs.size() > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Exchange published to {} subscriptions for the stream {}: {}", new Object[]{subs.size(), this.name, data});
            }
            for (CamelSubscription sub : subs) {
                sub.publish(data);
            }
        } else if (callback != null) {
            callback.processed(data, new IllegalStateException("The stream has no active subscriptions"));
        }
    }

    public void attachProducer(ReactiveStreamsProducer producer) {
        Objects.requireNonNull(producer, "producer cannot be null, use the detach method");
        if (this.producer != null) {
            throw new IllegalStateException("A producer is already attached to the stream '" + this.name + "'");
        }
        this.producer = producer;
        ReactiveStreamsEndpoint endpoint = producer.getEndpoint();
        if (endpoint.getBackpressureStrategy() != null) {
            this.backpressureStrategy = endpoint.getBackpressureStrategy();
            for (CamelSubscription sub : this.subscriptions) {
                sub.setBackpressureStrategy(endpoint.getBackpressureStrategy());
            }
        }
    }

    public void detachProducer() {
        this.producer = null;
    }

    @Override
    public void close() throws Exception {
        for (CamelSubscription sub : this.subscriptions) {
            sub.signalCompletion();
        }
        this.subscriptions.clear();
    }

    public List<CamelSubscription> getSubscriptions() {
        return this.subscriptions;
    }
}

