/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.dataformat;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.JsonDataFormat;
import org.apache.camel.model.dataformat.JsonLibrary;
import org.apache.camel.reifier.dataformat.DataFormatReifier;

public class JsonDataFormatReifier
extends DataFormatReifier<JsonDataFormat> {
    public JsonDataFormatReifier(CamelContext camelContext, DataFormatDefinition definition) {
        super(camelContext, (JsonDataFormat)definition);
    }

    @Override
    protected void prepareDataFormatConfig(Map<String, Object> properties) {
        properties.put("objectMapper", this.asRef(((JsonDataFormat)this.definition).getObjectMapper()));
        if (((JsonDataFormat)this.definition).getLibrary() == JsonLibrary.Jackson) {
            if (((JsonDataFormat)this.definition).getUseDefaultObjectMapper() == null) {
                properties.put("useDefaultObjectMapper", "true");
            } else {
                properties.put("useDefaultObjectMapper", ((JsonDataFormat)this.definition).getUseDefaultObjectMapper());
            }
            properties.put("autoDiscoverObjectMapper", ((JsonDataFormat)this.definition).getAutoDiscoverObjectMapper());
        }
        if (((JsonDataFormat)this.definition).getLibrary() != JsonLibrary.XStream) {
            if (((JsonDataFormat)this.definition).getUnmarshalType() != null) {
                properties.put("unmarshalTypeName", this.asTypeName(((JsonDataFormat)this.definition).getUnmarshalType()));
            } else {
                properties.put("unmarshalTypeName", ((JsonDataFormat)this.definition).getUnmarshalTypeName());
            }
        }
        properties.put("prettyPrint", ((JsonDataFormat)this.definition).getPrettyPrint());
        properties.put("jsonView", ((JsonDataFormat)this.definition).getJsonView());
        properties.put("include", ((JsonDataFormat)this.definition).getInclude());
        properties.put("allowJmsType", ((JsonDataFormat)this.definition).getAllowJmsType());
        if (((JsonDataFormat)this.definition).getLibrary() != JsonLibrary.XStream) {
            if (((JsonDataFormat)this.definition).getCollectionType() != null) {
                properties.put("collectionTypeName", ((JsonDataFormat)this.definition).getCollectionType().getName());
            } else {
                properties.put("collectionTypeName", ((JsonDataFormat)this.definition).getCollectionTypeName());
            }
        }
        properties.put("useList", ((JsonDataFormat)this.definition).getUseList());
        properties.put("moduleClassNames", ((JsonDataFormat)this.definition).getModuleClassNames());
        properties.put("moduleRefs", ((JsonDataFormat)this.definition).getModuleRefs());
        properties.put("enableFeatures", ((JsonDataFormat)this.definition).getEnableFeatures());
        properties.put("disableFeatures", ((JsonDataFormat)this.definition).getDisableFeatures());
        properties.put("allowUnmarshallType", ((JsonDataFormat)this.definition).getAllowUnmarshallType());
        if (((JsonDataFormat)this.definition).getLibrary() == JsonLibrary.XStream) {
            properties.put("dropRootNode", ((JsonDataFormat)this.definition).getDropRootNode());
        }
        if (((JsonDataFormat)this.definition).getLibrary() == JsonLibrary.XStream && ((JsonDataFormat)this.definition).getPermissions() == null) {
            String type = ((JsonDataFormat)this.definition).getUnmarshalTypeName();
            if (type == null && ((JsonDataFormat)this.definition).getUnmarshalType() != null) {
                type = ((JsonDataFormat)this.definition).getUnmarshalType().getName();
            }
            properties.put("permissions", type);
            properties.remove("unmarshalType");
        }
    }
}

