/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.reactive.streams.util;

import java.util.Objects;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.support.DefaultExchange;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class ConvertingSubscriber<R>
implements Subscriber<R> {
    private final Class<R> type;
    private final Subscriber<Exchange> delegate;
    private final CamelContext context;

    public ConvertingSubscriber(Subscriber<Exchange> delegate, CamelContext context, Class<R> type) {
        Objects.requireNonNull(delegate, "delegate subscriber cannot be null");
        Objects.requireNonNull(type, "type cannot be null");
        this.delegate = delegate;
        this.context = context;
        this.type = type;
    }

    public void onSubscribe(Subscription subscription) {
        if (subscription == null) {
            throw new NullPointerException("subscription is null");
        }
        this.delegate.onSubscribe(subscription);
    }

    public void onNext(R r) {
        if (r == null) {
            throw new NullPointerException("element is null");
        }
        DefaultExchange exchange = new DefaultExchange(this.context);
        exchange.getIn().setBody(r, this.type);
        this.delegate.onNext((Object)exchange);
    }

    public void onError(Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException("throwable is null");
        }
        this.delegate.onError(throwable);
    }

    public void onComplete() {
        this.delegate.onComplete();
    }
}

