/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.reactive.streams;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.reactive.streams.ReactiveStreamsBackpressureStrategy;
import org.apache.camel.component.reactive.streams.ReactiveStreamsEndpoint;
import org.apache.camel.component.reactive.streams.ReactiveStreamsHelper;
import org.apache.camel.component.reactive.streams.api.CamelReactiveStreamsService;
import org.apache.camel.component.reactive.streams.engine.ReactiveStreamsEngineConfiguration;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.service.ServiceHelper;

@Component(value="reactive-streams")
public class ReactiveStreamsComponent
extends DefaultComponent {
    @Metadata(label="advanced")
    private ReactiveStreamsEngineConfiguration internalEngineConfiguration = new ReactiveStreamsEngineConfiguration();
    @Metadata(label="producer", defaultValue="BUFFER")
    private ReactiveStreamsBackpressureStrategy backpressureStrategy = ReactiveStreamsBackpressureStrategy.BUFFER;
    @Metadata(label="advanced")
    private String serviceType;
    private CamelReactiveStreamsService service;

    protected void doStart() throws Exception {
        this.getReactiveStreamsService();
        super.doStart();
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.service);
        super.doStop();
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        ReactiveStreamsEndpoint endpoint = new ReactiveStreamsEndpoint(uri, this);
        endpoint.setStream(remaining);
        this.setProperties((Endpoint)endpoint, parameters);
        if (endpoint.getBackpressureStrategy() == null) {
            endpoint.setBackpressureStrategy(this.backpressureStrategy);
        }
        return endpoint;
    }

    public ReactiveStreamsEngineConfiguration getInternalEngineConfiguration() {
        return this.internalEngineConfiguration;
    }

    public void setInternalEngineConfiguration(ReactiveStreamsEngineConfiguration internalEngineConfiguration) {
        this.internalEngineConfiguration = internalEngineConfiguration;
    }

    public ReactiveStreamsBackpressureStrategy getBackpressureStrategy() {
        return this.backpressureStrategy;
    }

    public void setBackpressureStrategy(ReactiveStreamsBackpressureStrategy backpressureStrategy) {
        this.backpressureStrategy = backpressureStrategy;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public synchronized CamelReactiveStreamsService getReactiveStreamsService() {
        if (this.service == null) {
            this.service = ReactiveStreamsHelper.resolveReactiveStreamsService(this.getCamelContext(), this.serviceType, this.internalEngineConfiguration);
            try {
                this.getCamelContext().addService((Object)this.service, true, true);
            }
            catch (Exception e) {
                throw new RuntimeCamelException((Throwable)e);
            }
        }
        return this.service;
    }

    public static final ReactiveStreamsComponent withServiceType(String serviceType) {
        ReactiveStreamsComponent component = new ReactiveStreamsComponent();
        component.setServiceType(serviceType);
        return component;
    }
}

