/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.resume;

import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.processor.resume.NoOffsetException;
import org.apache.camel.resume.Resumable;
import org.apache.camel.resume.ResumeStrategy;
import org.apache.camel.resume.UpdatableConsumerResumeStrategy;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.ExchangeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResumableCompletion
implements Synchronization {
    private static final Logger LOG = LoggerFactory.getLogger(ResumableCompletion.class);
    private final ResumeStrategy resumeStrategy;
    private final LoggingLevel loggingLevel;
    private final boolean intermittent;

    public ResumableCompletion(ResumeStrategy resumeStrategy, LoggingLevel loggingLevel, boolean intermittent) {
        this.resumeStrategy = resumeStrategy;
        this.loggingLevel = loggingLevel;
        this.intermittent = intermittent;
    }

    public void onComplete(Exchange exchange) {
        if (ExchangeHelper.isFailureHandled((Exchange)exchange)) {
            return;
        }
        Object offset = ExchangeHelper.getResultMessage((Exchange)exchange).getHeader("CamelOffset");
        if (offset instanceof Resumable) {
            Resumable resumable = (Resumable)offset;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Processing the resumable: {}", (Object)resumable.getOffsetKey());
                LOG.trace("Processing the resumable of type: {}", resumable.getLastOffset().getValue());
            }
            if (this.resumeStrategy instanceof UpdatableConsumerResumeStrategy) {
                UpdatableConsumerResumeStrategy updatableConsumerResumeStrategy = (UpdatableConsumerResumeStrategy)this.resumeStrategy;
                try {
                    updatableConsumerResumeStrategy.updateLastOffset(resumable);
                }
                catch (Exception e) {
                    LOG.error("Unable to update the offset: {}", (Object)e.getMessage(), (Object)e);
                }
            } else {
                LOG.debug("Cannot perform an offset update because the strategy is not updatable");
            }
        } else if (!this.intermittent) {
            exchange.setException((Throwable)((Object)new NoOffsetException(exchange)));
            LOG.warn("Cannot update the last offset because it's not available");
        }
    }

    public void onFailure(Exchange exchange) {
        Exception e = exchange.getException();
        Object resObj = exchange.getMessage().getHeader("CamelOffset");
        if (resObj instanceof Resumable) {
            Resumable resumable = (Resumable)resObj;
            Object logMessage = String.format("Skipping offset update with address '%s' and offset value '%s' due to failure in processing: %s", resumable.getOffsetKey(), resumable.getLastOffset().getValue(), e.getMessage());
            if (LOG.isDebugEnabled() || CamelLogger.shouldLog((Logger)LOG, (LoggingLevel)this.loggingLevel)) {
                CamelLogger.log((Logger)LOG, (LoggingLevel)LoggingLevel.DEBUG, (String)logMessage, (Throwable)e);
            } else {
                logMessage = (String)logMessage + " (stacktrace available in DEBUG logging level)";
                CamelLogger.log((Logger)LOG, (LoggingLevel)this.loggingLevel, (String)logMessage);
            }
        } else {
            Object logMessage = String.format("Skipping offset update of '%s' due to failure in processing: %s", resObj == null ? "type null" : "unspecified type", e.getMessage());
            if (LOG.isDebugEnabled() || CamelLogger.shouldLog((Logger)LOG, (LoggingLevel)this.loggingLevel)) {
                CamelLogger.log((Logger)LOG, (LoggingLevel)LoggingLevel.DEBUG, (String)logMessage, (Throwable)e);
            } else {
                logMessage = (String)logMessage + " (stacktrace available in DEBUG logging level)";
                CamelLogger.log((Logger)LOG, (LoggingLevel)this.loggingLevel, (String)logMessage);
            }
        }
    }
}

