/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ReturnListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConversionException;
import org.apache.camel.component.rabbitmq.RabbitMQEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMQMessagePublisher {
    private static final Logger LOG = LoggerFactory.getLogger(RabbitMQMessagePublisher.class);
    private final Exchange camelExchange;
    private final Channel channel;
    private final String routingKey;
    private final RabbitMQEndpoint endpoint;
    private final Message message;
    private volatile boolean basicReturnReceived;
    private final ReturnListener guaranteedDeliveryReturnListener = new ReturnListener(){

        public void handleReturn(int replyCode, String replyText, String exchange, String routingKey, AMQP.BasicProperties properties, byte[] body) throws IOException {
            LOG.warn("Delivery failed for exchange: {} and routing key: {}; replyCode: {}; replyText: {}", new Object[]{exchange, routingKey, replyCode, replyText});
            RabbitMQMessagePublisher.this.basicReturnReceived = true;
        }
    };

    public RabbitMQMessagePublisher(Exchange camelExchange, Channel channel, String routingKey, RabbitMQEndpoint endpoint) {
        this.camelExchange = camelExchange;
        this.channel = channel;
        this.routingKey = routingKey;
        this.endpoint = endpoint;
        this.message = this.resolveMessageFrom(camelExchange);
    }

    private Message resolveMessageFrom(Exchange camelExchange) {
        Message message = camelExchange.getMessage();
        if (message.getHeaders() != null && message.getHeaders().containsKey("CamelSerialize")) {
            LOG.trace("Removing header: {}", (Object)"CamelSerialize");
            message.getHeaders().remove("CamelSerialize");
        }
        if (this.routingKey != null && this.routingKey.startsWith("amq.rabbitmq.reply-to")) {
            message.setHeader("CamelRabbitmqExchangeName", (Object)"");
            message.setHeader("CamelRabbitmqExchangeOverrideName", (Object)"");
        }
        return message;
    }

    public void publish() throws IOException {
        AMQP.BasicProperties properties;
        byte[] body;
        try {
            body = (byte[])this.camelExchange.getContext().getTypeConverter().mandatoryConvertTo(byte[].class, this.camelExchange, this.message.getBody());
            properties = this.endpoint.getMessageConverter().buildProperties(this.camelExchange).build();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Exchange properties: {}", (Object)properties);
            }
        }
        catch (NoTypeConversionAvailableException | TypeConversionException e) {
            if (this.message.getBody() instanceof Serializable && this.endpoint.isAllowMessageBodySerialization()) {
                this.message.getHeaders().put("CamelSerialize", true);
                properties = this.endpoint.getMessageConverter().buildProperties(this.camelExchange).build();
                body = this.serializeBodyFrom(this.message);
            }
            if (this.message.getBody() == null) {
                properties = this.endpoint.getMessageConverter().buildProperties(this.camelExchange).build();
                body = null;
            }
            LOG.warn("Cannot convert {} to byte[]", this.message.getBody());
            throw new RuntimeCamelException(e);
        }
        this.publishToRabbitMQ(properties, body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishToRabbitMQ(AMQP.BasicProperties properties, byte[] body) throws IOException {
        String exchangeName = (String)this.message.getHeader("CamelRabbitmqExchangeOverrideName");
        if (exchangeName == null || this.endpoint.isBridgeEndpoint()) {
            exchangeName = this.endpoint.getExchangeName();
        } else {
            LOG.debug("Overriding header: {} detected sending message to exchange: {}", (Object)"CamelRabbitmqExchangeOverrideName", (Object)exchangeName);
        }
        Boolean mandatory = (Boolean)this.camelExchange.getIn().getHeader("CamelRabbitmqMandatory", (Object)this.endpoint.isMandatory(), Boolean.class);
        Boolean immediate = (Boolean)this.camelExchange.getIn().getHeader("CamelRabbitmqImmediate", (Object)this.endpoint.isImmediate(), Boolean.class);
        LOG.debug("Sending message to exchange: {} with CorrelationId: {}", (Object)exchangeName, (Object)properties.getCorrelationId());
        if (this.isPublisherAcknowledgements()) {
            this.channel.confirmSelect();
        }
        if (this.endpoint.isGuaranteedDeliveries()) {
            this.basicReturnReceived = false;
            this.channel.addReturnListener(this.guaranteedDeliveryReturnListener);
        }
        try {
            this.channel.basicPublish(exchangeName, this.routingKey, mandatory.booleanValue(), immediate.booleanValue(), properties, body);
            if (this.isPublisherAcknowledgements()) {
                this.waitForConfirmation();
            }
        }
        finally {
            if (this.endpoint.isGuaranteedDeliveries()) {
                this.channel.removeReturnListener(this.guaranteedDeliveryReturnListener);
            }
        }
    }

    private boolean isPublisherAcknowledgements() {
        return this.endpoint.isPublisherAcknowledgements() || this.endpoint.isGuaranteedDeliveries();
    }

    private void waitForConfirmation() throws IOException {
        try {
            LOG.debug("Waiting for publisher acknowledgements for {}ms", (Object)this.endpoint.getPublisherAcknowledgementsTimeout());
            this.channel.waitForConfirmsOrDie(this.endpoint.getPublisherAcknowledgementsTimeout());
            if (this.basicReturnReceived) {
                throw new RuntimeCamelException("Failed to deliver message; basic.return received");
            }
        }
        catch (InterruptedException | TimeoutException e) {
            LOG.warn("Acknowledgement error for {}", (Object)this.camelExchange);
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private byte[] serializeBodyFrom(Message msg) throws IOException {
        try (ByteArrayOutputStream b = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream o = new ObjectOutputStream(b);){
                o.writeObject(msg.getBody());
                byArray = b.toByteArray();
            }
            return byArray;
        }
        catch (NotSerializableException nse) {
            LOG.warn("Cannot send object {} via RabbitMQ because it contains non-serializable objects.", msg.getBody().getClass());
            throw new RuntimeCamelException((Throwable)nse);
        }
    }
}

