/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina.initiator;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.buffer.IoBufferAllocator;
import org.apache.mina.core.buffer.SimpleBufferAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.Application;
import quickfix.ConfigError;
import quickfix.DefaultSessionFactory;
import quickfix.FieldConvertError;
import quickfix.Initiator;
import quickfix.LogFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.Session;
import quickfix.SessionFactory;
import quickfix.SessionID;
import quickfix.SessionSettings;
import quickfix.field.converter.BooleanConverter;
import quickfix.mina.EventHandlingStrategy;
import quickfix.mina.NetworkingOptions;
import quickfix.mina.ProtocolFactory;
import quickfix.mina.SessionConnector;
import quickfix.mina.initiator.IoSessionInitiator;
import quickfix.mina.ssl.SSLConfig;
import quickfix.mina.ssl.SSLSupport;

public abstract class AbstractSocketInitiator
extends SessionConnector
implements Initiator {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Set<IoSessionInitiator> initiators = new HashSet<IoSessionInitiator>();
    private final ScheduledExecutorService scheduledReconnectExecutor;
    public static final String QFJ_RECONNECT_THREAD_PREFIX = "QFJ Reconnect Thread-";

    protected AbstractSocketInitiator(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, LogFactory logFactory, MessageFactory messageFactory) throws ConfigError {
        this(settings, new DefaultSessionFactory(application, messageStoreFactory, logFactory, messageFactory));
    }

    protected AbstractSocketInitiator(SessionSettings settings, SessionFactory sessionFactory) throws ConfigError {
        this(settings, sessionFactory, 0);
    }

    protected AbstractSocketInitiator(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, LogFactory logFactory, MessageFactory messageFactory, int numReconnectThreads) throws ConfigError {
        this(settings, new DefaultSessionFactory(application, messageStoreFactory, logFactory, messageFactory), numReconnectThreads);
    }

    protected AbstractSocketInitiator(SessionSettings settings, SessionFactory sessionFactory, int numReconnectThreads) throws ConfigError {
        super(settings, sessionFactory);
        IoBuffer.setAllocator((IoBufferAllocator)new SimpleBufferAllocator());
        IoBuffer.setUseDirectBuffer((boolean)false);
        if (numReconnectThreads > 0) {
            this.scheduledReconnectExecutor = Executors.newScheduledThreadPool(numReconnectThreads, new QFScheduledReconnectThreadFactory());
            ((ThreadPoolExecutor)((Object)this.scheduledReconnectExecutor)).setMaximumPoolSize(numReconnectThreads);
        } else {
            this.scheduledReconnectExecutor = null;
        }
    }

    protected void createSessionInitiators() throws ConfigError {
        try {
            this.createSessions();
            for (Session session : this.getSessionMap().values()) {
                this.createInitiator(session);
            }
        }
        catch (FieldConvertError e) {
            throw new ConfigError(e);
        }
    }

    private void createInitiator(Session session) throws ConfigError, FieldConvertError {
        SessionSettings settings = this.getSettings();
        SessionID sessionID = session.getSessionID();
        int[] reconnectingIntervals = this.getReconnectIntervalInSeconds(sessionID);
        SocketAddress[] socketAddresses = this.getSocketAddresses(sessionID);
        if (socketAddresses.length == 0) {
            throw new ConfigError("Must specify at least one socket address");
        }
        SocketAddress localAddress = this.getLocalAddress(settings, sessionID);
        NetworkingOptions networkingOptions = new NetworkingOptions(this.getSettings().getSessionProperties(sessionID, true));
        boolean sslEnabled = false;
        SSLConfig sslConfig = null;
        if (this.getSettings().isSetting(sessionID, "SocketUseSSL") && BooleanConverter.convert(this.getSettings().getString(sessionID, "SocketUseSSL"))) {
            sslEnabled = true;
            sslConfig = SSLSupport.getSslConfig(this.getSettings(), sessionID);
        }
        String proxyUser = null;
        String proxyPassword = null;
        String proxyHost = null;
        String proxyType = null;
        String proxyVersion = null;
        String proxyWorkstation = null;
        String proxyDomain = null;
        int proxyPort = -1;
        if (this.getSettings().isSetting(sessionID, "ProxyType")) {
            proxyType = settings.getString(sessionID, "ProxyType");
            if (this.getSettings().isSetting(sessionID, "ProxyVersion")) {
                proxyVersion = settings.getString(sessionID, "ProxyVersion");
            }
            if (this.getSettings().isSetting(sessionID, "ProxyUser")) {
                proxyUser = settings.getString(sessionID, "ProxyUser");
                proxyPassword = settings.getString(sessionID, "ProxyPassword");
            }
            if (this.getSettings().isSetting(sessionID, "ProxyWorkstation") && this.getSettings().isSetting(sessionID, "ProxyDomain")) {
                proxyWorkstation = settings.getString(sessionID, "ProxyWorkstation");
                proxyDomain = settings.getString(sessionID, "ProxyDomain");
            }
            proxyHost = settings.getString(sessionID, "ProxyHost");
            proxyPort = (int)settings.getLong(sessionID, "ProxyPort");
        }
        ScheduledExecutorService scheduledExecutorService = this.scheduledReconnectExecutor != null ? this.scheduledReconnectExecutor : this.getScheduledExecutorService();
        IoSessionInitiator ioSessionInitiator = new IoSessionInitiator(session, socketAddresses, localAddress, reconnectingIntervals, scheduledExecutorService, networkingOptions, this.getEventHandlingStrategy(), this.getIoFilterChainBuilder(), sslEnabled, sslConfig, proxyType, proxyVersion, proxyHost, proxyPort, proxyUser, proxyPassword, proxyDomain, proxyWorkstation);
        this.initiators.add(ioSessionInitiator);
    }

    private SocketAddress getLocalAddress(SessionSettings settings, SessionID sessionID) throws ConfigError, FieldConvertError {
        SocketAddress localAddress = null;
        if (settings.isSetting(sessionID, "SocketLocalHost")) {
            String host = settings.getString(sessionID, "SocketLocalHost");
            if ("localhost".equals(host)) {
                throw new ConfigError("SocketLocalHost cannot be \"localhost\"!");
            }
            int port = 0;
            if (settings.isSetting(sessionID, "SocketLocalPort")) {
                port = (int)settings.getLong(sessionID, "SocketLocalPort");
            }
            localAddress = ProtocolFactory.createSocketAddress(0, host, port);
            this.log.info("Using initiator local host: {}", (Object)localAddress);
        }
        return localAddress;
    }

    private void createSessions() throws ConfigError, FieldConvertError {
        SessionSettings settings = this.getSettings();
        boolean continueInitOnError = this.isContinueInitOnError();
        HashMap<SessionID, Session> initiatorSessions = new HashMap<SessionID, Session>();
        Iterator<SessionID> i = settings.sectionIterator();
        while (i.hasNext()) {
            SessionID sessionID = i.next();
            if (!this.isInitiatorSession(sessionID)) continue;
            try {
                if (settings.isSetting(sessionID, "DynamicSession") && settings.getBool(sessionID, "DynamicSession")) continue;
                Session quickfixSession = this.createSession(sessionID);
                initiatorSessions.put(sessionID, quickfixSession);
            }
            catch (Throwable e) {
                if (continueInitOnError) {
                    this.log.error("error during session initialization, continuing...", e);
                    continue;
                }
                throw e instanceof ConfigError ? (ConfigError)e : new ConfigError("error during session initialization", e);
            }
        }
        this.setSessions(initiatorSessions);
    }

    public void createDynamicSession(SessionID sessionID) throws ConfigError {
        try {
            Session session = this.createSession(sessionID);
            super.addDynamicSession(session);
            this.createInitiator(session);
            this.startInitiators();
        }
        catch (FieldConvertError e) {
            throw new ConfigError(e);
        }
    }

    private int[] getReconnectIntervalInSeconds(SessionID sessionID) throws ConfigError {
        SessionSettings settings = this.getSettings();
        if (settings.isSetting(sessionID, "ReconnectInterval")) {
            try {
                String raw = settings.getString(sessionID, "ReconnectInterval");
                int[] ret = SessionSettings.parseSettingReconnectInterval(raw);
                if (ret != null) {
                    return ret;
                }
            }
            catch (Throwable e) {
                throw new ConfigError(e);
            }
        }
        return new int[]{30};
    }

    private SocketAddress[] getSocketAddresses(SessionID sessionID) throws ConfigError {
        SessionSettings settings = this.getSettings();
        ArrayList<SocketAddress> addresses = new ArrayList<SocketAddress>();
        int index = 0;
        while (true) {
            try {
                String protocolKey = "SocketConnectProtocol" + (index == 0 ? "" : Integer.toString(index));
                String hostKey = "SocketConnectHost" + (index == 0 ? "" : Integer.toString(index));
                String portKey = "SocketConnectPort" + (index == 0 ? "" : Integer.toString(index));
                int transportType = 0;
                if (settings.isSetting(sessionID, protocolKey)) {
                    try {
                        transportType = ProtocolFactory.getTransportType(settings.getString(sessionID, protocolKey));
                    }
                    catch (IllegalArgumentException e) {
                        throw new ConfigError(e);
                    }
                }
                if (!settings.isSetting(sessionID, portKey)) break;
                String host = !this.isHostRequired(transportType) ? "localhost" : settings.getString(sessionID, hostKey);
                int port = (int)settings.getLong(sessionID, portKey);
                addresses.add(ProtocolFactory.createSocketAddress(transportType, host, port));
            }
            catch (FieldConvertError e) {
                throw new ConfigError(e.getMessage(), e);
            }
            ++index;
        }
        return addresses.toArray(new SocketAddress[addresses.size()]);
    }

    private boolean isHostRequired(int transportType) {
        return transportType != 1;
    }

    private boolean isInitiatorSession(Object sectionKey) throws ConfigError, FieldConvertError {
        SessionSettings settings = this.getSettings();
        return !settings.isSetting((SessionID)sectionKey, "ConnectionType") || settings.getString((SessionID)sectionKey, "ConnectionType").equals("initiator");
    }

    protected void startInitiators() {
        this.startSessionTimer();
        for (IoSessionInitiator initiator : this.initiators) {
            initiator.start();
        }
    }

    protected void stopInitiators() {
        Iterator<IoSessionInitiator> iterator = this.initiators.iterator();
        while (iterator.hasNext()) {
            iterator.next().stop();
            iterator.remove();
        }
        super.stopSessionTimer();
    }

    public Set<IoSessionInitiator> getInitiators() {
        return Collections.unmodifiableSet(this.initiators);
    }

    public int getQueueSize() {
        EventHandlingStrategy ehs = this.getEventHandlingStrategy();
        return ehs == null ? 0 : ehs.getQueueSize();
    }

    protected abstract EventHandlingStrategy getEventHandlingStrategy();

    private static class QFScheduledReconnectThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger COUNTER = new AtomicInteger(1);

        private QFScheduledReconnectThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, AbstractSocketInitiator.QFJ_RECONNECT_THREAD_PREFIX + COUNTER.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }
    }
}

