/*
 * Decompiled with CFR 0.152.
 */
package quickfix.field.converter;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.TimeZone;
import quickfix.FieldConvertError;

abstract class AbstractDateTimeConverter {
    AbstractDateTimeConverter() {
    }

    protected static void assertLength(String value, int i, String type) throws FieldConvertError {
        if (value.length() != i) {
            AbstractDateTimeConverter.throwFieldConvertError(value, type);
        }
    }

    protected static void assertLength(String value, String type, int ... lengths) throws FieldConvertError {
        for (int length : lengths) {
            if (value.length() != length) continue;
            return;
        }
        AbstractDateTimeConverter.throwFieldConvertError(value, type);
    }

    protected static void assertDigitSequence(String value, int i, int j, String type) throws FieldConvertError {
        for (int offset = i; offset < j; ++offset) {
            if (Character.isDigit(value.charAt(offset))) continue;
            AbstractDateTimeConverter.throwFieldConvertError(value, type);
        }
    }

    protected static void assertSeparator(String value, int offset, char ch, String type) throws FieldConvertError {
        if (value.charAt(offset) != ch) {
            AbstractDateTimeConverter.throwFieldConvertError(value, type);
        }
    }

    protected static void throwFieldConvertError(String value, String type) throws FieldConvertError {
        throw new FieldConvertError("invalid UTC " + type + " value: " + value);
    }

    protected static long parseLong(String s) {
        long n = 0L;
        for (int i = 0; i < s.length(); ++i) {
            n = n * 10L + (long)(s.charAt(i) - 48);
        }
        return n;
    }

    protected DateFormat createDateFormat(String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        sdf.setDateFormatSymbols(new DateFormatSymbols(Locale.US));
        return sdf;
    }

    protected static DateTimeFormatter createDateTimeFormat(String format) {
        return DateTimeFormatter.ofPattern(format);
    }
}

