/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

public enum FieldType {
    UNKNOWN,
    STRING,
    CHAR,
    PRICE(Double.class),
    INT(Integer.class),
    AMT(Double.class),
    QTY(Double.class),
    CURRENCY,
    MULTIPLEVALUESTRING,
    MULTIPLESTRINGVALUE,
    EXCHANGE,
    UTCTIMESTAMP(LocalDateTime.class),
    BOOLEAN(Boolean.class),
    LOCALMKTDATE,
    DATA,
    FLOAT(Double.class),
    PRICEOFFSET(Double.class),
    MONTHYEAR,
    DAYOFMONTH(Integer.class),
    UTCDATEONLY(LocalDate.class),
    UTCDATE(LocalDate.class),
    UTCTIMEONLY(LocalTime.class),
    TIME,
    NUMINGROUP(Integer.class),
    PERCENTAGE(Double.class),
    SEQNUM(Integer.class),
    LENGTH(Integer.class),
    COUNTRY;

    private final Class<?> javaType;

    private FieldType(Class<?> javaType) {
        this.javaType = javaType;
    }

    private FieldType() {
        this(String.class);
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.name() + "," + this.javaType + "," + this.ordinal() + "]";
    }

    public static FieldType fromName(String fixVersion, String name) {
        try {
            return FieldType.valueOf(name);
        }
        catch (IllegalArgumentException iae) {
            return UNKNOWN;
        }
    }
}

