/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.Application;
import quickfix.ApplicationExtended;
import quickfix.BusinessRejectReasonText;
import quickfix.DataDictionary;
import quickfix.DataDictionaryProvider;
import quickfix.DoNotSend;
import quickfix.FieldException;
import quickfix.FieldNotFound;
import quickfix.HasFieldAndReason;
import quickfix.IncorrectDataFormat;
import quickfix.IncorrectTagValue;
import quickfix.InvalidMessage;
import quickfix.ListenerSupport;
import quickfix.Log;
import quickfix.LogFactory;
import quickfix.LogUtil;
import quickfix.Message;
import quickfix.MessageFactory;
import quickfix.MessageStore;
import quickfix.MessageStoreFactory;
import quickfix.MessageUtils;
import quickfix.NumbersCache;
import quickfix.RejectLogon;
import quickfix.Responder;
import quickfix.RuntimeError;
import quickfix.SessionException;
import quickfix.SessionID;
import quickfix.SessionNotFound;
import quickfix.SessionRejectReasonText;
import quickfix.SessionSchedule;
import quickfix.SessionState;
import quickfix.SessionStateListener;
import quickfix.SystemTime;
import quickfix.UnsupportedMessageType;
import quickfix.UnsupportedVersion;
import quickfix.UtcTimestampPrecision;
import quickfix.field.ApplVerID;
import quickfix.field.DefaultApplVerID;
import quickfix.field.SessionStatus;
import quickfix.mina.EventHandlingStrategy;

public class Session
implements Closeable {
    public static final String SETTING_HEARTBTINT = "HeartBtInt";
    public static final String SETTING_CHECK_LATENCY = "CheckLatency";
    public static final String SETTING_CHECK_COMP_ID = "CheckCompID";
    public static final String SETTING_MAX_LATENCY = "MaxLatency";
    public static final String SETTING_TEST_REQUEST_DELAY_MULTIPLIER = "TestRequestDelayMultiplier";
    public static final String SETTING_NON_STOP_SESSION = "NonStopSession";
    public static final String SETTING_START_DAY = "StartDay";
    public static final String SETTING_END_DAY = "EndDay";
    public static final String SETTING_TIMEZONE = "TimeZone";
    public static final String SETTING_START_TIME = "StartTime";
    public static final String SETTING_END_TIME = "EndTime";
    public static final String SETTING_WEEKDAYS = "Weekdays";
    public static final String SETTING_USE_DATA_DICTIONARY = "UseDataDictionary";
    public static final String SETTING_DATA_DICTIONARY = "DataDictionary";
    public static final String SETTING_TRANSPORT_DATA_DICTIONARY = "TransportDataDictionary";
    public static final String SETTING_APP_DATA_DICTIONARY = "AppDataDictionary";
    public static final String SETTING_VALIDATE_FIELDS_OUT_OF_ORDER = "ValidateFieldsOutOfOrder";
    public static final String SETTING_VALIDATE_UNORDERED_GROUP_FIELDS = "ValidateUnorderedGroupFields";
    public static final String SETTING_VALIDATE_FIELDS_HAVE_VALUES = "ValidateFieldsHaveValues";
    public static final String SETTING_VALIDATE_INCOMING_MESSAGE = "ValidateIncomingMessage";
    public static final String SETTING_LOGON_TIMEOUT = "LogonTimeout";
    public static final String SETTING_LOGOUT_TIMEOUT = "LogoutTimeout";
    public static final String SETTING_RESET_ON_LOGOUT = "ResetOnLogout";
    public static final String SETTING_VALIDATE_SEQUENCE_NUMBERS = "ValidateSequenceNumbers";
    public static final String SETTING_RESET_ON_DISCONNECT = "ResetOnDisconnect";
    public static final String SETTING_RESET_ON_ERROR = "ResetOnError";
    public static final String SETTING_DISCONNECT_ON_ERROR = "DisconnectOnError";
    public static final String SETTING_TIMESTAMP_PRECISION = "TimeStampPrecision";
    public static final String SETTING_VALIDATE_USER_DEFINED_FIELDS = "ValidateUserDefinedFields";
    public static final String SETTING_RESET_ON_LOGON = "ResetOnLogon";
    public static final String SETTING_DESCRIPTION = "Description";
    public static final String SETTING_REFRESH_ON_LOGON = "RefreshOnLogon";
    public static final String SETTING_SEND_REDUNDANT_RESEND_REQUEST = "SendRedundantResendRequests";
    public static final String SETTING_PERSIST_MESSAGES = "PersistMessages";
    public static final String SETTING_USE_CLOSED_RESEND_INTERVAL = "ClosedResendInterval";
    public static final String SETTING_ALLOW_UNKNOWN_MSG_FIELDS = "AllowUnknownMsgFields";
    public static final String SETTING_DEFAULT_APPL_VER_ID = "DefaultApplVerID";
    public static final String SETTING_DISABLE_HEART_BEAT_CHECK = "DisableHeartBeatCheck";
    public static final String SETTING_ENABLE_LAST_MSG_SEQ_NUM_PROCESSED = "EnableLastMsgSeqNumProcessed";
    public static final String SETTING_ENABLE_NEXT_EXPECTED_MSG_SEQ_NUM = "EnableNextExpectedMsgSeqNum";
    public static final String SETTING_REJECT_GARBLED_MESSAGE = "RejectGarbledMessage";
    public static final String SETTING_REJECT_INVALID_MESSAGE = "RejectInvalidMessage";
    public static final String SETTING_REJECT_MESSAGE_ON_UNHANDLED_EXCEPTION = "RejectMessageOnUnhandledException";
    public static final String SETTING_REQUIRES_ORIG_SENDING_TIME = "RequiresOrigSendingTime";
    public static final String SETTING_FORCE_RESEND_WHEN_CORRUPTED_STORE = "ForceResendWhenCorruptedStore";
    public static final String SETTING_ALLOWED_REMOTE_ADDRESSES = "AllowedRemoteAddresses";
    public static final String SETTING_RESEND_REQUEST_CHUNK_SIZE = "ResendRequestChunkSize";
    public static final String SETTING_MAX_SCHEDULED_WRITE_REQUESTS = "MaxScheduledWriteRequests";
    private static final ConcurrentMap<SessionID, Session> sessions = new ConcurrentHashMap<SessionID, Session>();
    private final Application application;
    private final SessionID sessionID;
    private final SessionSchedule sessionSchedule;
    private final MessageFactory messageFactory;
    private final SessionState state;
    private boolean enabled;
    private final Object responderLock = new Object();
    private Responder responder;
    private long lastSessionTimeCheck = 0L;
    private int logonAttempts = 0;
    private long lastSessionLogon = 0L;
    private final DataDictionaryProvider dataDictionaryProvider;
    private final boolean checkLatency;
    private final int maxLatency;
    private int resendRequestChunkSize = 0;
    private final boolean resetOnLogon;
    private final boolean resetOnLogout;
    private final boolean resetOnDisconnect;
    private final boolean resetOnError;
    private final boolean disconnectOnError;
    private final UtcTimestampPrecision timestampPrecision;
    private final boolean refreshMessageStoreAtLogon;
    private final boolean redundantResentRequestsAllowed;
    private final boolean persistMessages;
    private final boolean checkCompID;
    private final boolean useClosedRangeForResend;
    private boolean disableHeartBeatCheck = false;
    private boolean rejectGarbledMessage = false;
    private boolean rejectInvalidMessage = false;
    private boolean rejectMessageOnUnhandledException = false;
    private boolean requiresOrigSendingTime = false;
    private boolean forceResendWhenCorruptedStore = false;
    private boolean enableNextExpectedMsgSeqNum = false;
    private boolean enableLastMsgSeqNumProcessed = false;
    private int maxScheduledWriteRequests = 0;
    private final AtomicBoolean isResetting = new AtomicBoolean();
    private final AtomicBoolean isResettingState = new AtomicBoolean();
    private final ListenerSupport stateListeners = new ListenerSupport(SessionStateListener.class);
    private final SessionStateListener stateListener = (SessionStateListener)this.stateListeners.getMulticaster();
    private final AtomicReference<ApplVerID> targetDefaultApplVerID = new AtomicReference();
    private final DefaultApplVerID senderDefaultApplVerID;
    private boolean validateSequenceNumbers = true;
    private boolean validateIncomingMessage = true;
    private final int[] logonIntervals;
    private final Set<InetAddress> allowedRemoteAddresses;
    public static final int DEFAULT_MAX_LATENCY = 120;
    public static final int DEFAULT_RESEND_RANGE_CHUNK_SIZE = 0;
    public static final double DEFAULT_TEST_REQUEST_DELAY_MULTIPLIER = 0.5;
    private static final String ENCOUNTERED_END_OF_STREAM = "Encountered END_OF_STREAM";
    private static final int BAD_COMPID_REJ_REASON = 9;
    private static final String BAD_COMPID_TEXT = new FieldException(9).getMessage();
    private static final int BAD_TIME_REJ_REASON = 10;
    private static final String BAD_ORIG_TIME_TEXT = new FieldException(10, 122).getMessage();
    private static final String BAD_TIME_TEXT = new FieldException(10, 52).getMessage();
    protected static final Logger LOG = LoggerFactory.getLogger(Session.class);

    Session(Application application, MessageStoreFactory messageStoreFactory, SessionID sessionID, DataDictionaryProvider dataDictionaryProvider, SessionSchedule sessionSchedule, LogFactory logFactory, MessageFactory messageFactory, int heartbeatInterval) {
        this(application, messageStoreFactory, sessionID, dataDictionaryProvider, sessionSchedule, logFactory, messageFactory, heartbeatInterval, true, 120, UtcTimestampPrecision.MILLIS, false, false, false, false, true, false, true, false, 0.5, null, true, new int[]{5}, false, false, false, false, true, false, true, false, null, true, 0, false, false);
    }

    Session(Application application, MessageStoreFactory messageStoreFactory, SessionID sessionID, DataDictionaryProvider dataDictionaryProvider, SessionSchedule sessionSchedule, LogFactory logFactory, MessageFactory messageFactory, int heartbeatInterval, boolean checkLatency, int maxLatency, UtcTimestampPrecision timestampPrecision, boolean resetOnLogon, boolean resetOnLogout, boolean resetOnDisconnect, boolean refreshMessageStoreAtLogon, boolean checkCompID, boolean redundantResentRequestsAllowed, boolean persistMessages, boolean useClosedRangeForResend, double testRequestDelayMultiplier, DefaultApplVerID senderDefaultApplVerID, boolean validateSequenceNumbers, int[] logonIntervals, boolean resetOnError, boolean disconnectOnError, boolean disableHeartBeatCheck, boolean rejectGarbledMessage, boolean rejectInvalidMessage, boolean rejectMessageOnUnhandledException, boolean requiresOrigSendingTime, boolean forceResendWhenCorruptedStore, Set<InetAddress> allowedRemoteAddresses, boolean validateIncomingMessage, int resendRequestChunkSize, boolean enableNextExpectedMsgSeqNum, boolean enableLastMsgSeqNumProcessed) {
        MessageStore messageStore;
        Log engineLog;
        this.application = application;
        this.sessionID = sessionID;
        this.sessionSchedule = sessionSchedule;
        this.checkLatency = checkLatency;
        this.maxLatency = maxLatency;
        this.resetOnLogon = resetOnLogon;
        this.resetOnLogout = resetOnLogout;
        this.resetOnDisconnect = resetOnDisconnect;
        this.timestampPrecision = timestampPrecision;
        this.refreshMessageStoreAtLogon = refreshMessageStoreAtLogon;
        this.dataDictionaryProvider = dataDictionaryProvider;
        this.messageFactory = messageFactory;
        this.checkCompID = checkCompID;
        this.redundantResentRequestsAllowed = redundantResentRequestsAllowed;
        this.persistMessages = persistMessages;
        this.useClosedRangeForResend = useClosedRangeForResend;
        this.senderDefaultApplVerID = senderDefaultApplVerID;
        this.logonIntervals = logonIntervals;
        this.resetOnError = resetOnError;
        this.disconnectOnError = disconnectOnError;
        this.disableHeartBeatCheck = disableHeartBeatCheck;
        this.rejectGarbledMessage = rejectGarbledMessage;
        this.rejectInvalidMessage = rejectInvalidMessage;
        this.rejectMessageOnUnhandledException = rejectMessageOnUnhandledException;
        this.requiresOrigSendingTime = requiresOrigSendingTime;
        this.forceResendWhenCorruptedStore = forceResendWhenCorruptedStore;
        this.allowedRemoteAddresses = allowedRemoteAddresses;
        this.validateIncomingMessage = validateIncomingMessage;
        this.validateSequenceNumbers = validateSequenceNumbers;
        this.resendRequestChunkSize = resendRequestChunkSize;
        this.enableNextExpectedMsgSeqNum = enableNextExpectedMsgSeqNum;
        this.enableLastMsgSeqNumProcessed = enableLastMsgSeqNumProcessed;
        Log log = engineLog = logFactory != null ? logFactory.create(sessionID) : null;
        if (engineLog instanceof SessionStateListener) {
            this.addStateListener((SessionStateListener)((Object)engineLog));
        }
        if ((messageStore = messageStoreFactory.create(sessionID)) instanceof SessionStateListener) {
            this.addStateListener((SessionStateListener)((Object)messageStore));
        }
        this.state = new SessionState(this, engineLog, heartbeatInterval, heartbeatInterval != 0, messageStore, testRequestDelayMultiplier);
        Session.registerSession(this);
        this.getLog().onEvent("Session " + sessionID + " schedule is " + sessionSchedule);
        try {
            this.resetIfSessionNotCurrent(sessionID, SystemTime.currentTimeMillis());
        }
        catch (IOException e) {
            LogUtil.logThrowable(this.getLog(), "error during session construction", (Throwable)e);
        }
        if (!sessionID.isFIXT()) {
            this.targetDefaultApplVerID.set(MessageUtils.toApplVerID(sessionID.getBeginString()));
        }
        this.setEnabled(true);
        this.getLog().onEvent("Created session: " + sessionID);
    }

    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResponder(Responder responder) {
        Object object = this.responderLock;
        synchronized (object) {
            this.responder = responder;
            if (responder != null) {
                this.stateListener.onConnect();
            } else {
                this.stateListener.onDisconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Responder getResponder() {
        Object object = this.responderLock;
        synchronized (object) {
            return this.responder;
        }
    }

    public boolean hasResponder() {
        return this.getResponder() != null;
    }

    public String getRemoteAddress() {
        Responder responder = this.getResponder();
        if (responder != null) {
            return responder.getRemoteAddress();
        }
        return null;
    }

    private boolean isCurrentSession(long time) throws IOException {
        return this.sessionSchedule == null || this.sessionSchedule.isSameSession(SystemTime.getUtcCalendar(time), SystemTime.getUtcCalendar(this.state.getCreationTime()));
    }

    public static boolean sendToTarget(Message message) throws SessionNotFound {
        return Session.sendToTarget(message, "");
    }

    public static boolean sendToTarget(Message message, String qualifier) throws SessionNotFound {
        try {
            String senderCompID = Session.getSenderCompIDFromMessage(message);
            String targetCompID = Session.getTargetCompIDFromMessage(message);
            return Session.sendToTarget(message, senderCompID, targetCompID, qualifier);
        }
        catch (FieldNotFound e) {
            throw new SessionNotFound("missing sender or target company ID");
        }
    }

    private static String getTargetCompIDFromMessage(Message message) throws FieldNotFound {
        return message.getHeader().getString(56);
    }

    private static String getSenderCompIDFromMessage(Message message) throws FieldNotFound {
        return message.getHeader().getString(49);
    }

    public static boolean sendToTarget(Message message, String senderCompID, String targetCompID) throws SessionNotFound {
        return Session.sendToTarget(message, senderCompID, targetCompID, "");
    }

    public static boolean sendToTarget(Message message, String senderCompID, String targetCompID, String qualifier) throws SessionNotFound {
        try {
            return Session.sendToTarget(message, new SessionID(message.getHeader().getString(8), senderCompID, targetCompID, qualifier));
        }
        catch (SessionNotFound e) {
            throw e;
        }
        catch (Exception e) {
            throw new SessionException(e);
        }
    }

    public static boolean sendToTarget(Message message, SessionID sessionID) throws SessionNotFound {
        Session session = Session.lookupSession(sessionID);
        if (session == null) {
            throw new SessionNotFound();
        }
        message.setSessionID(sessionID);
        return session.send(message);
    }

    static void registerSession(Session session) {
        sessions.put(session.getSessionID(), session);
    }

    static void unregisterSessions(List<SessionID> sessionIds, boolean doClose) {
        for (SessionID sessionId : sessionIds) {
            Session.unregisterSession(sessionId, doClose);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unregisterSession(SessionID sessionId, boolean doClose) {
        Session session = (Session)sessions.get(sessionId);
        if (session != null) {
            try {
                if (doClose) {
                    session.close();
                }
            }
            catch (IOException e) {
                LOG.error("Failed to close session resources", (Throwable)e);
            }
            finally {
                sessions.remove(sessionId);
            }
        }
    }

    public static Session lookupSession(SessionID sessionID) {
        return (Session)sessions.get(sessionID);
    }

    public void logon() {
        this.state.clearLogoutReason();
        this.setEnabled(true);
    }

    private synchronized void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private void initializeHeader(Message.Header header) {
        this.state.setLastSentTime(SystemTime.currentTimeMillis());
        header.setString(8, this.sessionID.getBeginString());
        header.setString(49, this.sessionID.getSenderCompID());
        this.optionallySetID(header, 50, this.sessionID.getSenderSubID());
        this.optionallySetID(header, 142, this.sessionID.getSenderLocationID());
        header.setString(56, this.sessionID.getTargetCompID());
        this.optionallySetID(header, 57, this.sessionID.getTargetSubID());
        this.optionallySetID(header, 143, this.sessionID.getTargetLocationID());
        header.setInt(34, this.getExpectedSenderNum());
        this.insertSendingTime(header);
    }

    private void optionallySetID(Message.Header header, int field, String value) {
        if (!value.equals("")) {
            header.setString(field, value);
        }
    }

    private void insertSendingTime(Message.Header header) {
        header.setUtcTimeStamp(52, SystemTime.getLocalDateTime(), this.getTimestampPrecision());
    }

    private UtcTimestampPrecision getTimestampPrecision() {
        if (this.sessionID.getBeginString().compareTo("FIX.4.2") >= 0) {
            return this.timestampPrecision;
        }
        return UtcTimestampPrecision.SECONDS;
    }

    public void logout() {
        this.setEnabled(false);
    }

    public void logout(String reason) {
        this.state.setLogoutReason(reason);
        this.logout();
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    public boolean sentLogon() {
        return this.state.isLogonSent();
    }

    public boolean receivedLogon() {
        return this.state.isLogonReceived();
    }

    public boolean sentLogout() {
        return this.state.isLogoutSent();
    }

    public boolean receivedLogout() {
        return this.state.isLogoutReceived();
    }

    public boolean isLoggedOn() {
        return this.sentLogon() && this.receivedLogon();
    }

    private boolean isResetNeeded() {
        return this.sessionID.getBeginString().compareTo("FIX.4.1") >= 0 && (this.resetOnLogon || this.resetOnLogout || this.resetOnDisconnect) && this.getExpectedSenderNum() == 1 && this.getExpectedTargetNum() == 1;
    }

    public void reset() throws IOException {
        if (!this.isResetting.compareAndSet(false, true)) {
            return;
        }
        try {
            if (this.hasResponder() && this.isLoggedOn()) {
                if (this.application instanceof ApplicationExtended) {
                    ((ApplicationExtended)this.application).onBeforeSessionReset(this.sessionID);
                }
                this.generateLogout();
                this.disconnect("Session reset", false);
            }
            this.resetState();
        }
        finally {
            this.isResetting.set(false);
        }
    }

    public void setNextSenderMsgSeqNum(int num) throws IOException {
        this.state.getMessageStore().setNextSenderMsgSeqNum(num);
    }

    public void setNextTargetMsgSeqNum(int num) throws IOException {
        this.state.getMessageStore().setNextTargetMsgSeqNum(num);
    }

    public int getExpectedSenderNum() {
        try {
            return this.state.getMessageStore().getNextSenderMsgSeqNum();
        }
        catch (IOException e) {
            this.getLog().onErrorEvent("getNextSenderMsgSeqNum failed: " + e.getMessage());
            return -1;
        }
    }

    public int getExpectedTargetNum() {
        try {
            return this.state.getMessageStore().getNextTargetMsgSeqNum();
        }
        catch (IOException e) {
            this.getLog().onErrorEvent("getNextTargetMsgSeqNum failed: " + e.getMessage());
            return -1;
        }
    }

    public Log getLog() {
        return this.state.getLog();
    }

    public MessageStore getStore() {
        return this.state.getMessageStore();
    }

    private void next(Message message, boolean isProcessingQueuedMessages) throws FieldNotFound, RejectLogon, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType, IOException, InvalidMessage {
        if (message == EventHandlingStrategy.END_OF_STREAM) {
            this.disconnect(ENCOUNTERED_END_OF_STREAM, false);
            return;
        }
        Message.Header header = message.getHeader();
        String msgType = header.getString(35);
        if (!header.isSetField(34)) {
            this.generateLogout("Received message without MsgSeqNum");
            this.disconnect("Received message without MsgSeqNum: " + this.getMessageToLog(message), true);
            return;
        }
        String sessionBeginString = this.sessionID.getBeginString();
        try {
            String beginString = header.getString(8);
            if (!beginString.equals(sessionBeginString)) {
                throw new UnsupportedVersion("Message version '" + beginString + "' does not match the session version '" + sessionBeginString + "'");
            }
            if ("A".equals(msgType)) {
                if (this.sessionID.isFIXT()) {
                    this.targetDefaultApplVerID.set(new ApplVerID(message.getString(1137)));
                }
                if (message.isSetField(108) && message.getInt(108) < 0) {
                    throw new RejectLogon("HeartBtInt must not be negative");
                }
            }
            if (this.validateIncomingMessage && this.dataDictionaryProvider != null) {
                Object sessionDataDictionary = this.dataDictionaryProvider.getSessionDataDictionary(beginString);
                ApplVerID applVerID = header.isSetField(1128) ? new ApplVerID(header.getString(1128)) : this.targetDefaultApplVerID.get();
                DataDictionary applicationDataDictionary = MessageUtils.isAdminMessage(msgType) ? this.dataDictionaryProvider.getSessionDataDictionary(beginString) : this.dataDictionaryProvider.getApplicationDataDictionary(applVerID);
                try {
                    DataDictionary.validate(message, (DataDictionary)sessionDataDictionary, applicationDataDictionary);
                }
                catch (IncorrectTagValue e) {
                    if (this.rejectInvalidMessage) {
                        throw e;
                    }
                    this.getLog().onErrorEvent("Warn: incoming message with " + e + ": " + this.getMessageToLog(message));
                }
                catch (FieldException e) {
                    if (message.isSetField(e.getField())) {
                        if (this.rejectInvalidMessage) {
                            throw e;
                        }
                        this.getLog().onErrorEvent("Warn: incoming message with incorrect field: " + message.getField(e.getField()) + ": " + this.getMessageToLog(message));
                    } else {
                        if (this.rejectInvalidMessage) {
                            throw e;
                        }
                        this.getLog().onErrorEvent("Warn: incoming message with missing field: " + e.getField() + ": " + e.getMessage() + ": " + this.getMessageToLog(message));
                    }
                }
                catch (FieldNotFound e) {
                    if (this.rejectInvalidMessage) {
                        throw e;
                    }
                    this.getLog().onErrorEvent("Warn: incoming " + e + ": " + this.getMessageToLog(message));
                }
            }
            switch (msgType) {
                case "A": {
                    this.nextLogon(message);
                    break;
                }
                case "0": {
                    this.nextHeartBeat(message);
                    break;
                }
                case "1": {
                    this.nextTestRequest(message);
                    break;
                }
                case "4": {
                    this.nextSequenceReset(message);
                    break;
                }
                case "5": {
                    this.nextLogout(message);
                    break;
                }
                case "2": {
                    this.nextResendRequest(message);
                    break;
                }
                case "3": {
                    this.nextReject(message);
                    break;
                }
                default: {
                    if (!this.verify(message)) {
                        return;
                    }
                    this.state.incrNextTargetMsgSeqNum();
                    break;
                }
            }
        }
        catch (FieldException | IncorrectDataFormat | IncorrectTagValue e) {
            if (this.logErrorAndDisconnectIfRequired(e, message)) {
                return;
            }
            this.handleExceptionAndRejectMessage(msgType, message, (HasFieldAndReason)((Object)e));
        }
        catch (FieldNotFound e) {
            if (this.logErrorAndDisconnectIfRequired(e, message)) {
                return;
            }
            if (sessionBeginString.compareTo("FIX.4.2") >= 0 && message.isApp()) {
                this.generateBusinessReject(message, 5, e.field);
            } else if ("A".equals(msgType)) {
                this.getLog().onErrorEvent("Required field missing from logon");
                this.disconnect("Required field missing from logon", true);
            } else {
                this.generateReject(message, 1, e.field);
            }
        }
        catch (InvalidMessage e) {
            if (this.rejectGarbledMessage) {
                this.getLog().onErrorEvent("Processing garbled message: " + e.getMessage());
                this.generateReject(message, "Message failed basic validity check");
            } else {
                this.getLog().onErrorEvent("Skipping invalid message: " + e + ": " + this.getMessageToLog(message));
                if (this.resetOrDisconnectIfRequired(message)) {
                    return;
                }
            }
        }
        catch (RejectLogon e) {
            String rejectMessage = e.getMessage() != null ? ": " + e : "";
            this.getLog().onErrorEvent("Logon rejected" + rejectMessage);
            if (e.isLogoutBeforeDisconnect()) {
                if (e.getSessionStatus() > -1) {
                    this.generateLogout(e.getMessage(), new SessionStatus(e.getSessionStatus()));
                } else {
                    this.generateLogout(e.getMessage());
                }
            }
            if (this.getExpectedTargetNum() == header.getInt(34)) {
                this.state.incrNextTargetMsgSeqNum();
            }
            this.disconnect("Logon rejected: " + e, true);
        }
        catch (UnsupportedMessageType e) {
            if (this.logErrorAndDisconnectIfRequired(e, message)) {
                return;
            }
            if (sessionBeginString.compareTo("FIX.4.2") >= 0) {
                this.generateBusinessReject(message, 3, 0);
            } else {
                this.generateReject(message, "Unsupported message type");
            }
        }
        catch (UnsupportedVersion e) {
            if (this.logErrorAndDisconnectIfRequired(e, message)) {
                return;
            }
            if ("5".equals(msgType)) {
                this.nextLogout(message);
            } else {
                this.generateLogout("Incorrect BeginString: " + e.getMessage());
                this.state.incrNextTargetMsgSeqNum();
                this.disconnect("Incorrect BeginString: " + e, true);
            }
        }
        catch (IOException e) {
            LogUtil.logThrowable(this.sessionID, "Error processing message: " + this.getMessageToLog(message), (Throwable)e);
            if (this.resetOrDisconnectIfRequired(message)) {
                return;
            }
        }
        catch (Throwable t) {
            if (this.rejectMessageOnUnhandledException) {
                this.getLog().onErrorEvent("Rejecting message: " + t + ": " + this.getMessageToLog(message));
                if (this.resetOrDisconnectIfRequired(message)) {
                    return;
                }
                if (!MessageUtils.isAdminMessage(msgType) && sessionBeginString.compareTo("FIX.4.2") >= 0) {
                    this.generateBusinessReject(message, 4, 0);
                } else if ("A".equals(msgType)) {
                    this.disconnect("Problem processing Logon message", true);
                } else {
                    this.generateReject(message, 99, 0);
                }
            }
            throw new RuntimeError(t);
        }
        if (!isProcessingQueuedMessages) {
            this.nextQueued();
            if (this.isLoggedOn()) {
                this.next();
            }
        }
    }

    private void handleExceptionAndRejectMessage(String msgType, Message message, HasFieldAndReason e) throws FieldNotFound, IOException {
        if ("A".equals(msgType)) {
            this.logoutWithErrorMessage(e.getMessage());
        } else {
            this.getLog().onErrorEvent("Rejecting invalid message: " + e + ": " + this.getMessageToLog(message));
            this.generateReject(message, e.getMessage(), e.getSessionRejectReason(), e.getField());
        }
    }

    private void logoutWithErrorMessage(String reason) throws IOException {
        String errorMessage = "Invalid Logon message: " + (reason != null ? reason : "unspecific reason");
        this.generateLogout(errorMessage);
        this.state.incrNextTargetMsgSeqNum();
        this.disconnect(errorMessage, true);
    }

    private boolean logErrorAndDisconnectIfRequired(Exception e, Message message) {
        boolean resetOrDisconnectIfRequired = this.resetOrDisconnectIfRequired(message);
        if (resetOrDisconnectIfRequired) {
            this.getLog().onErrorEvent("Encountered invalid message: " + e + ": " + this.getMessageToLog(message));
        }
        return resetOrDisconnectIfRequired;
    }

    public void next(Message message) throws FieldNotFound, RejectLogon, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType, IOException, InvalidMessage {
        if (this.rejectGarbledMessage && message.isGarbled()) {
            this.generateReject(message, "Message failed basic validity check");
            return;
        }
        this.next(message, false);
    }

    private boolean resetOrDisconnectIfRequired(Message msg) {
        if (!this.resetOnError && !this.disconnectOnError) {
            return false;
        }
        if (!this.isLoggedOn()) {
            return false;
        }
        if (msg != null && msg.isAdmin()) {
            return false;
        }
        if (this.resetOnError) {
            try {
                this.getLog().onErrorEvent("Auto reset");
                this.reset();
            }
            catch (IOException e) {
                LOG.error("Failed resetting: {}", (Throwable)e);
            }
            return true;
        }
        if (this.disconnectOnError) {
            try {
                this.disconnect("Auto disconnect", false);
            }
            catch (IOException e) {
                LOG.error("Failed disconnecting: {}", (Throwable)e);
            }
            return true;
        }
        return false;
    }

    private boolean isStateRefreshNeeded(String msgType) {
        return this.refreshMessageStoreAtLogon && !this.state.isInitiator() && "A".equals(msgType);
    }

    private void nextReject(Message reject) throws FieldNotFound, RejectLogon, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType, IOException, InvalidMessage {
        if (!this.verify(reject, false, this.validateSequenceNumbers)) {
            return;
        }
        if (this.getExpectedTargetNum() == reject.getHeader().getInt(34)) {
            this.state.incrNextTargetMsgSeqNum();
        }
        this.nextQueued();
    }

    private void nextResendRequest(Message resendRequest) throws IOException, RejectLogon, FieldNotFound, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType, InvalidMessage {
        if (!this.verify(resendRequest, false, this.validateSequenceNumbers)) {
            return;
        }
        int msgSeqNum = resendRequest.getHeader().getInt(34);
        if (this.validateSequenceNumbers && this.isTargetTooHigh(msgSeqNum)) {
            this.enqueueMessage(resendRequest, msgSeqNum);
        }
        int beginSeqNo = resendRequest.getInt(7);
        int endSeqNo = resendRequest.getInt(16);
        this.getLog().onEvent("Received ResendRequest FROM: " + beginSeqNo + " TO: " + this.formatEndSeqNum(endSeqNo));
        this.manageGapFill(resendRequest, beginSeqNo, endSeqNo);
    }

    private void manageGapFill(Message messageOutSync, int beginSeqNo, int endSeqNo) throws FieldNotFound, IOException, InvalidMessage {
        String beginString = this.sessionID.getBeginString();
        int expectedSenderNum = this.getExpectedSenderNum();
        if (beginString.compareTo("FIX.4.2") >= 0 && endSeqNo == 0 || beginString.compareTo("FIX.4.2") <= 0 && endSeqNo == 999999 || endSeqNo >= expectedSenderNum) {
            endSeqNo = expectedSenderNum - 1;
        }
        if (!this.persistMessages) {
            int next = this.state.getNextSenderMsgSeqNum();
            if (++endSeqNo > next) {
                endSeqNo = next;
            }
            this.generateSequenceReset(messageOutSync, beginSeqNo, endSeqNo);
        } else {
            this.resendMessages(messageOutSync, beginSeqNo, endSeqNo);
        }
        int resendRequestMsgSeqNum = messageOutSync.getHeader().getInt(34);
        if (this.getExpectedTargetNum() == resendRequestMsgSeqNum) {
            this.state.incrNextTargetMsgSeqNum();
        }
    }

    private String formatEndSeqNum(int seqNo) {
        return seqNo == 0 ? "infinity" : Integer.toString(seqNo);
    }

    private Message parseMessage(String messageData) throws InvalidMessage {
        return MessageUtils.parse(this, messageData);
    }

    private boolean isTargetTooLow(int msgSeqNum) throws IOException {
        return msgSeqNum < this.state.getNextTargetMsgSeqNum();
    }

    private void generateSequenceReset(Message receivedMessage, int beginSeqNo, int endSeqNo) throws FieldNotFound {
        Message sequenceReset = this.messageFactory.create(this.sessionID.getBeginString(), "4");
        Message.Header header = sequenceReset.getHeader();
        header.setBoolean(43, true);
        this.initializeHeader(header);
        header.setUtcTimeStamp(122, header.getUtcTimeStamp(52), this.getTimestampPrecision());
        header.setInt(34, beginSeqNo);
        sequenceReset.setInt(36, endSeqNo);
        sequenceReset.setBoolean(123, true);
        if (receivedMessage != null && this.enableLastMsgSeqNumProcessed) {
            try {
                sequenceReset.getHeader().setInt(369, receivedMessage.getHeader().getInt(34));
            }
            catch (FieldNotFound e) {
                this.getLog().onErrorEvent("Received message without MsgSeqNum " + this.getMessageToLog(receivedMessage));
            }
        }
        this.sendRaw(sequenceReset, beginSeqNo);
        this.getLog().onEvent("Sent SequenceReset TO: " + endSeqNo);
    }

    private boolean resendApproved(Message message) throws FieldNotFound {
        try {
            this.application.toApp(message, this.sessionID);
        }
        catch (DoNotSend e) {
            return false;
        }
        catch (Throwable t) {
            this.logApplicationException("toApp() during resend", t);
        }
        return true;
    }

    private void initializeResendFields(Message message) throws FieldNotFound {
        Message.Header header = message.getHeader();
        LocalDateTime sendingTime = header.getUtcTimeStamp(52);
        header.setUtcTimeStamp(122, sendingTime, this.getTimestampPrecision());
        header.setBoolean(43, true);
        this.insertSendingTime(header);
    }

    private void logApplicationException(String location, Throwable t) {
        LogUtil.logThrowable(this.getLog(), "Application exception in " + location, t);
    }

    private void nextLogout(Message logout) throws IOException, RejectLogon, FieldNotFound, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType {
        String msg;
        if (!this.verify(logout, false, false)) {
            return;
        }
        this.state.setLogoutReceived(true);
        if (!this.state.isLogoutSent()) {
            msg = "Received logout request";
            if (logout.isSetField(58)) {
                msg = msg + ": " + logout.getString(58);
            }
            this.getLog().onEvent(msg);
            this.generateLogout(logout);
            this.getLog().onEvent("Sent logout response");
        } else {
            msg = "Received logout response";
            this.getLog().onEvent(msg);
        }
        if (this.getExpectedTargetNum() == logout.getHeader().getInt(34)) {
            this.state.incrNextTargetMsgSeqNum();
        }
        if (this.resetOnLogout) {
            this.resetState();
        }
        this.disconnect(msg, false);
    }

    public void generateLogout() {
        this.generateLogout(null, null, null);
    }

    private void generateLogout(Message otherLogout) {
        this.generateLogout(otherLogout, null, null);
    }

    private void generateLogout(String reason) {
        this.generateLogout(null, reason, null);
    }

    private void generateLogout(String reason, SessionStatus sessionStatus) {
        this.generateLogout(null, reason, sessionStatus);
    }

    private void generateLogout(Message otherLogout, String text, SessionStatus sessionStatus) {
        Message logout = this.messageFactory.create(this.sessionID.getBeginString(), "5");
        this.initializeHeader(logout.getHeader());
        if (text != null && !"".equals(text)) {
            logout.setString(58, text);
        }
        if (sessionStatus != null) {
            logout.setInt(1409, sessionStatus.getValue());
        }
        if (otherLogout != null && this.enableLastMsgSeqNumProcessed) {
            try {
                logout.getHeader().setInt(369, otherLogout.getHeader().getInt(34));
            }
            catch (FieldNotFound e) {
                this.getLog().onErrorEvent("Received logout without MsgSeqNum");
            }
        }
        this.sendRaw(logout, 0);
        this.state.setLogoutSent(true);
    }

    private void nextSequenceReset(Message sequenceReset) throws IOException, RejectLogon, FieldNotFound, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType {
        boolean isGapFill = false;
        if (sequenceReset.isSetField(123)) {
            boolean bl = isGapFill = sequenceReset.getBoolean(123) && this.validateSequenceNumbers;
        }
        if (!this.verify(sequenceReset, isGapFill, isGapFill)) {
            return;
        }
        if (this.validateSequenceNumbers && sequenceReset.isSetField(36)) {
            int newSequence = sequenceReset.getInt(36);
            this.getLog().onEvent("Received SequenceReset FROM: " + this.getExpectedTargetNum() + " TO: " + newSequence);
            if (newSequence > this.getExpectedTargetNum()) {
                this.state.setNextTargetMsgSeqNum(newSequence);
                SessionState.ResendRange range = this.state.getResendRange();
                if (range.isChunkedResendRequest() && newSequence >= range.getCurrentEndSeqNo() && newSequence < range.getEndSeqNo()) {
                    String beginString = sequenceReset.getHeader().getString(8);
                    this.sendResendRequest(beginString, range.getEndSeqNo() + 1, newSequence, range.getEndSeqNo());
                }
                this.state.dequeueMessagesUpTo(newSequence);
            } else if (newSequence < this.getExpectedTargetNum()) {
                this.getLog().onErrorEvent("Invalid SequenceReset: newSequence=" + newSequence + " < expected=" + this.getExpectedTargetNum());
                if (this.resetOrDisconnectIfRequired(sequenceReset)) {
                    return;
                }
                this.generateReject(sequenceReset, 5, 36);
            }
        }
    }

    private void generateReject(Message message, String str) throws FieldNotFound, IOException {
        String msgSeqNum;
        String beginString = this.sessionID.getBeginString();
        Message reject = this.messageFactory.create(beginString, "3");
        Message.Header header = message.getHeader();
        reject.reverseRoute(header);
        this.initializeHeader(reject.getHeader());
        String msgType = header.isSetField(35) ? header.getString(35) : null;
        String string = msgSeqNum = header.isSetField(34) ? header.getString(34) : NumbersCache.get(0);
        if (beginString.compareTo("FIX.4.2") >= 0 && msgType != null) {
            reject.setString(372, msgType);
        }
        reject.setString(45, msgSeqNum);
        if (!"A".equals(msgType) && !"4".equals(msgType) && Integer.parseInt(msgSeqNum) == this.getExpectedTargetNum()) {
            this.state.incrNextTargetMsgSeqNum();
        }
        reject.setString(58, str);
        this.sendRaw(reject, 0);
        this.getLog().onErrorEvent("Reject sent for message " + msgSeqNum + ": " + str);
    }

    private boolean isPossibleDuplicate(Message message) throws FieldNotFound {
        Message.Header header = message.getHeader();
        return header.isSetField(43) && header.getBoolean(43);
    }

    private void generateReject(Message message, int err, int field) throws IOException, FieldNotFound {
        this.generateReject(message, null, err, field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateReject(Message message, String text, int err, int field) throws IOException, FieldNotFound {
        String reason = text != null ? text : SessionRejectReasonText.getMessage(err);
        if (!this.state.isLogonReceived()) {
            String errorMessage = "Tried to send a reject while not logged on: " + reason + (reason.endsWith("" + field) ? "" : " (field " + field + ")");
            throw new SessionException(errorMessage);
        }
        String beginString = this.sessionID.getBeginString();
        Message reject = this.messageFactory.create(beginString, "3");
        Message.Header header = message.getHeader();
        reject.reverseRoute(header);
        this.initializeHeader(reject.getHeader());
        String msgType = "";
        if (header.isSetField(35)) {
            msgType = header.getString(35);
        }
        int msgSeqNum = 0;
        if (header.isSetField(34)) {
            msgSeqNum = header.getInt(34);
            reject.setInt(45, msgSeqNum);
        }
        if (beginString.compareTo("FIX.4.2") >= 0) {
            if (!"".equals(msgType)) {
                reject.setString(372, msgType);
            }
            if (beginString.compareTo("FIX.4.4") > 0) {
                reject.setInt(373, err);
            } else if (beginString.compareTo("FIX.4.4") == 0) {
                if (err == 99 || err <= 17) {
                    reject.setInt(373, err);
                }
            } else if (beginString.compareTo("FIX.4.3") == 0) {
                if (err <= 17) {
                    reject.setInt(373, err);
                }
            } else if (beginString.compareTo("FIX.4.2") == 0 && err <= 11) {
                reject.setInt(373, err);
            }
        }
        this.state.lockTargetMsgSeqNum();
        try {
            if (!"A".equals(msgType) && !"4".equals(msgType) && msgSeqNum == this.getExpectedTargetNum()) {
                this.state.incrNextTargetMsgSeqNum();
            }
        }
        finally {
            this.state.unlockTargetMsgSeqNum();
        }
        String logMessage = "Reject sent for message " + msgSeqNum;
        if (reason != null && (field > 0 || err == 0)) {
            this.setRejectReason(reject, field, reason, true);
            this.getLog().onErrorEvent(logMessage + ": " + reason + (reason.endsWith("" + field) ? "" : ":" + field));
        } else if (reason != null) {
            this.setRejectReason(reject, reason);
            this.getLog().onErrorEvent(logMessage + ": " + reason);
        } else {
            this.getLog().onErrorEvent(logMessage);
        }
        if (this.enableLastMsgSeqNumProcessed) {
            reject.getHeader().setInt(369, message.getHeader().getInt(34));
        }
        this.sendRaw(reject, 0);
    }

    private void setRejectReason(Message reject, String reason) {
        reject.setString(58, reason);
    }

    private void setRejectReason(Message reject, int field, String reason, boolean includeFieldInReason) {
        boolean isRejectMessage;
        try {
            isRejectMessage = "3".equals(reject.getHeader().getString(35));
        }
        catch (FieldNotFound e) {
            isRejectMessage = false;
        }
        if (isRejectMessage && this.sessionID.getBeginString().compareTo("FIX.4.2") >= 0) {
            reject.setInt(371, field);
            reject.setString(58, reason);
        } else {
            String rejectReason = reason;
            if (includeFieldInReason && !rejectReason.endsWith("" + field)) {
                rejectReason = rejectReason + ", field=" + field;
            }
            reject.setString(58, rejectReason);
        }
    }

    private void generateBusinessReject(Message message, int err, int field) throws FieldNotFound, IOException {
        Message reject = this.messageFactory.create(this.sessionID.getBeginString(), "j");
        Message.Header header = message.getHeader();
        reject.reverseRoute(header);
        this.initializeHeader(reject.getHeader());
        String msgType = header.getString(35);
        String msgSeqNum = header.getString(34);
        reject.setString(372, msgType);
        reject.setString(45, msgSeqNum);
        reject.setInt(380, err);
        this.state.incrNextTargetMsgSeqNum();
        String reason = BusinessRejectReasonText.getMessage(err);
        this.setRejectReason(reject, field, reason, field != 0);
        this.getLog().onErrorEvent("Reject sent for message " + msgSeqNum + (reason != null ? ": " + reason : "") + (field != 0 ? ": tag=" + field : ""));
        this.sendRaw(reject, 0);
    }

    private void nextTestRequest(Message testRequest) throws FieldNotFound, RejectLogon, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType, IOException, InvalidMessage {
        if (!this.verify(testRequest)) {
            return;
        }
        this.generateHeartbeat(testRequest);
        this.state.incrNextTargetMsgSeqNum();
        this.nextQueued();
    }

    private void generateHeartbeat(Message testRequest) throws FieldNotFound {
        Message heartbeat = this.messageFactory.create(this.sessionID.getBeginString(), "0");
        this.initializeHeader(heartbeat.getHeader());
        if (testRequest.isSetField(112)) {
            heartbeat.setString(112, testRequest.getString(112));
        }
        if (this.enableLastMsgSeqNumProcessed) {
            heartbeat.getHeader().setInt(369, testRequest.getHeader().getInt(34));
        }
        this.sendRaw(heartbeat, 0);
    }

    private void nextHeartBeat(Message heartBeat) throws FieldNotFound, RejectLogon, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType, IOException, InvalidMessage {
        if (!this.verify(heartBeat)) {
            return;
        }
        this.state.incrNextTargetMsgSeqNum();
        this.nextQueued();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verify(Message msg, boolean checkTooHigh, boolean checkTooLow) throws RejectLogon, FieldNotFound, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType, IOException {
        String msgType;
        block15: {
            this.state.setLastReceivedTime(SystemTime.currentTimeMillis());
            this.state.clearTestRequestCounter();
            try {
                SessionState.ResendRange range;
                Message.Header header = msg.getHeader();
                msgType = header.getString(35);
                int msgSeqNum = 0;
                if (checkTooHigh || checkTooLow) {
                    msgSeqNum = header.getInt(34);
                }
                if (!this.validLogonState(msgType)) {
                    throw new SessionException("Logon state is not valid for message (MsgType=" + msgType + ")");
                }
                if (!this.isGoodTime(msg)) {
                    this.doBadTime(msg);
                    return false;
                }
                if (!this.isCorrectCompID(msg)) {
                    this.doBadCompID(msg);
                    return false;
                }
                if (checkTooHigh && this.isTargetTooHigh(msgSeqNum)) {
                    this.doTargetTooHigh(msg);
                    return false;
                }
                if (checkTooLow && this.isTargetTooLow(msgSeqNum)) {
                    this.doTargetTooLow(msg);
                    return false;
                }
                if (this.isPossibleDuplicate(msg) && !this.validatePossDup(msg)) {
                    return false;
                }
                if (!checkTooHigh || !this.state.isResendRequested()) break block15;
                Object object = this.state.getLock();
                synchronized (object) {
                    range = this.state.getResendRange();
                    if (msgSeqNum >= range.getEndSeqNo()) {
                        this.getLog().onEvent("ResendRequest for messages FROM " + range.getBeginSeqNo() + " TO " + range.getEndSeqNo() + " has been satisfied.");
                        this.state.setResendRange(0, 0, 0);
                    }
                }
                if (msgSeqNum < range.getEndSeqNo() && range.isChunkedResendRequest() && msgSeqNum >= range.getCurrentEndSeqNo()) {
                    String beginString = header.getString(8);
                    this.sendResendRequest(beginString, range.getEndSeqNo() + 1, msgSeqNum + 1, range.getEndSeqNo());
                }
            }
            catch (FieldNotFound e) {
                throw e;
            }
            catch (Exception e) {
                this.getLog().onErrorEvent(e.getClass().getName() + " " + e.getMessage());
                this.disconnect("Verifying message failed: " + e, true);
                return false;
            }
        }
        this.fromCallback(msgType, msg, this.sessionID);
        return true;
    }

    private boolean doTargetTooLow(Message msg) throws FieldNotFound, IOException {
        if (!this.isPossibleDuplicate(msg)) {
            int msgSeqNum = msg.getHeader().getInt(34);
            String text = "MsgSeqNum too low, expecting " + this.getExpectedTargetNum() + " but received " + msgSeqNum;
            this.generateLogout(text);
            throw new SessionException(text);
        }
        return this.validatePossDup(msg);
    }

    private void doBadCompID(Message msg) throws IOException, FieldNotFound {
        if (!"A".equals(msg.getHeader().getString(35))) {
            this.generateReject(msg, 9, 0);
            this.generateLogout(BAD_COMPID_TEXT);
        } else {
            this.logoutWithErrorMessage(BAD_COMPID_TEXT);
        }
    }

    private void doBadTime(Message msg) throws IOException, FieldNotFound {
        try {
            if (!"A".equals(msg.getHeader().getString(35))) {
                this.generateReject(msg, 10, 52);
                this.generateLogout(BAD_TIME_TEXT);
            } else {
                this.logoutWithErrorMessage(BAD_TIME_TEXT);
            }
        }
        catch (SessionException ex) {
            this.generateLogout(ex.getMessage());
            throw ex;
        }
    }

    private boolean isGoodTime(Message message) throws FieldNotFound {
        if (!this.checkLatency) {
            return true;
        }
        LocalDateTime sendingTime = message.getHeader().getUtcTimeStamp(52);
        return Math.abs(SystemTime.currentTimeMillis() - sendingTime.toInstant(ZoneOffset.UTC).toEpochMilli()) / 1000L <= (long)this.maxLatency;
    }

    private void fromCallback(String msgType, Message msg, SessionID sessionID2) throws RejectLogon, FieldNotFound, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType {
        if (MessageUtils.isAdminMessage(msgType)) {
            this.application.fromAdmin(msg, this.sessionID);
        } else {
            this.application.fromApp(msg, this.sessionID);
        }
    }

    private synchronized boolean validLogonState(String msgType) {
        return "A".equals(msgType) && this.state.isResetSent() || this.state.isResetReceived() || "A".equals(msgType) && !this.state.isLogonReceived() || !"A".equals(msgType) && this.state.isLogonReceived() || "5".equals(msgType) && this.state.isLogonSent() || !"5".equals(msgType) && this.state.isLogoutSent() || "4".equals(msgType) || "3".equals(msgType);
    }

    private boolean verify(Message message) throws RejectLogon, FieldNotFound, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType, IOException {
        return this.verify(message, this.validateSequenceNumbers, this.validateSequenceNumbers);
    }

    public void next() throws IOException {
        long now;
        if (!this.isEnabled()) {
            if (this.isLoggedOn()) {
                if (!this.state.isLogoutSent()) {
                    this.getLog().onEvent("Initiated logout request");
                    this.generateLogout(this.state.getLogoutReason());
                }
            } else {
                return;
            }
        }
        if (this.sessionSchedule != null && !this.sessionSchedule.isNonStopSession() && (now = SystemTime.currentTimeMillis()) - this.lastSessionTimeCheck >= 1000L) {
            this.lastSessionTimeCheck = now;
            if (!this.isSessionTime()) {
                if (this.state.isResetNeeded()) {
                    this.reset();
                }
                return;
            }
            this.resetIfSessionNotCurrent(this.sessionID, now);
        }
        if (!this.hasResponder()) {
            return;
        }
        if (!this.state.isLogonReceived()) {
            if (this.state.isLogonSendNeeded()) {
                if (this.isTimeToGenerateLogon()) {
                    if (this.application instanceof ApplicationExtended && !((ApplicationExtended)this.application).canLogon(this.sessionID)) {
                        return;
                    }
                    this.resetIfSessionNotCurrent(this.sessionID, SystemTime.currentTimeMillis());
                    if (this.generateLogon()) {
                        this.getLog().onEvent("Initiated logon request");
                    } else {
                        this.getLog().onErrorEvent("Error during logon request initiation");
                    }
                }
            } else if (this.state.isLogonAlreadySent() && this.state.isLogonTimedOut()) {
                this.disconnect("Timed out waiting for logon response", true);
            }
            return;
        }
        if (this.state.getHeartBeatInterval() == 0) {
            return;
        }
        if (this.state.isLogoutTimedOut()) {
            this.disconnect("Timed out waiting for logout response", true);
        }
        if (this.state.isTimedOut()) {
            if (!this.disableHeartBeatCheck) {
                this.disconnect("Timed out waiting for heartbeat", true);
                this.stateListener.onHeartBeatTimeout();
            } else {
                LOG.warn("Heartbeat failure detected but deactivated");
            }
        } else if (this.state.isTestRequestNeeded()) {
            this.generateTestRequest("TEST");
            this.getLog().onEvent("Sent test request TEST");
            this.stateListener.onMissedHeartBeat();
        } else if (this.state.isHeartBeatNeeded()) {
            this.generateHeartbeat();
        }
    }

    private long computeNextLogonDelayMillis() {
        int index = this.logonAttempts - 1;
        if (index < 0) {
            index = 0;
        }
        long secs = index >= this.logonIntervals.length ? (long)this.logonIntervals[this.logonIntervals.length - 1] : (long)this.logonIntervals[index];
        return secs * 1000L;
    }

    private boolean isTimeToGenerateLogon() {
        return SystemTime.currentTimeMillis() - this.lastSessionLogon >= this.computeNextLogonDelayMillis();
    }

    public void generateHeartbeat() {
        Message heartbeat = this.messageFactory.create(this.sessionID.getBeginString(), "0");
        this.initializeHeader(heartbeat.getHeader());
        this.sendRaw(heartbeat, 0);
    }

    public void generateTestRequest(String id) {
        this.state.incrementTestRequestCounter();
        Message testRequest = this.messageFactory.create(this.sessionID.getBeginString(), "1");
        this.initializeHeader(testRequest.getHeader());
        testRequest.setString(112, id);
        this.sendRaw(testRequest, 0);
    }

    private boolean generateLogon() throws IOException {
        Message logon = this.messageFactory.create(this.sessionID.getBeginString(), "A");
        logon.setInt(98, 0);
        logon.setInt(108, this.state.getHeartBeatInterval());
        if (this.sessionID.isFIXT()) {
            logon.setField(1137, this.senderDefaultApplVerID);
        }
        if (this.isStateRefreshNeeded("A")) {
            this.getLog().onEvent("Refreshing message/state store at logon");
            this.getStore().refresh();
            this.stateListener.onRefresh();
        }
        if (this.resetOnLogon) {
            this.resetState();
        }
        if (this.isResetNeeded()) {
            logon.setBoolean(141, true);
        }
        this.state.setLastReceivedTime(SystemTime.currentTimeMillis());
        this.state.clearTestRequestCounter();
        this.state.setLogonSent(true);
        ++this.logonAttempts;
        if (this.enableNextExpectedMsgSeqNum) {
            int nextExpectedMsgNum = this.getExpectedTargetNum();
            logon.setInt(789, nextExpectedMsgNum);
            this.state.setLastExpectedLogonNextSeqNum(nextExpectedMsgNum);
        }
        return this.sendRaw(logon, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(String reason, boolean logError) throws IOException {
        block16: {
            try {
                boolean logonReceived = this.state.isLogonReceived();
                boolean logonSent = this.state.isLogonSent();
                Object object = this.responderLock;
                synchronized (object) {
                    block15: {
                        if (this.hasResponder()) break block15;
                        if (!ENCOUNTERED_END_OF_STREAM.equals(reason)) {
                            this.getLog().onEvent("Already disconnected: " + reason);
                        }
                        return;
                    }
                    String msg = "Disconnecting: " + reason;
                    if (logError) {
                        this.getLog().onErrorEvent(msg);
                    } else {
                        this.getLog().onEvent(msg);
                    }
                    this.responder.disconnect();
                    this.setResponder(null);
                }
                if (!logonReceived && !logonSent) break block16;
                try {
                    this.application.onLogout(this.sessionID);
                }
                catch (Throwable t) {
                    this.logApplicationException("onLogout()", t);
                }
                this.stateListener.onLogout();
            }
            finally {
                if (!this.state.isInitiator()) {
                    this.setEnabled(true);
                }
                this.state.setLogonReceived(false);
                this.state.setLogonSent(false);
                this.state.setLogoutSent(false);
                this.state.setLogoutReceived(false);
                this.state.setResetReceived(false);
                this.state.setResetSent(false);
                this.state.clearQueue();
                this.state.clearLogoutReason();
                this.state.setResendRange(0, 0);
                if (this.resetOnDisconnect) {
                    this.resetState();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextLogon(Message logon) throws FieldNotFound, RejectLogon, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType, IOException, InvalidMessage {
        int targetWantsNextSeqNumToBe;
        boolean isLogonInNormalSequence;
        if (!this.isSessionTime()) {
            throw new RejectLogon("Logon attempt not within session time");
        }
        this.resetIfSessionNotCurrent(this.sessionID, SystemTime.currentTimeMillis());
        if (this.isStateRefreshNeeded("A")) {
            this.getLog().onEvent("Refreshing message/state store at logon");
            this.getStore().refresh();
            this.stateListener.onRefresh();
        }
        if (logon.isSetField(141)) {
            this.state.setResetReceived(logon.getBoolean(141));
        } else if (this.state.isResetSent() && logon.getHeader().getInt(34) == 1) {
            this.getLog().onEvent("Inferring ResetSeqNumFlag as sequence number is 1 in response to reset request");
            this.state.setResetReceived(true);
        }
        if (this.state.isResetReceived()) {
            this.getLog().onEvent("Logon contains ResetSeqNumFlag=Y, resetting sequence numbers to 1");
            if (!this.state.isResetSent()) {
                this.resetState();
            }
        }
        if (this.state.isLogonSendNeeded() && !this.state.isResetReceived()) {
            this.disconnect("Received logon response before sending request", true);
            return;
        }
        if (!this.state.isInitiator() && this.resetOnLogon) {
            this.resetState();
        }
        if (!this.verify(logon, false, this.validateSequenceNumbers)) {
            return;
        }
        this.state.setLogoutReceived(false);
        this.state.setLogoutSent(false);
        this.state.setLogonReceived(true);
        int nextSenderMsgNumAtLogonReceived = this.state.getMessageStore().getNextSenderMsgSeqNum();
        int sequence = logon.getHeader().getInt(34);
        boolean bl = isLogonInNormalSequence = !this.isTargetTooHigh(sequence) || this.resetOnLogon;
        if (logon.isSetField(789) && this.enableNextExpectedMsgSeqNum) {
            int actualNextNum;
            targetWantsNextSeqNumToBe = logon.getInt(789);
            this.state.lockSenderMsgSeqNum();
            try {
                actualNextNum = this.state.getNextSenderMsgSeqNum();
            }
            finally {
                this.state.unlockSenderMsgSeqNum();
            }
            if (targetWantsNextSeqNumToBe > actualNextNum) {
                String err = "Tag 789 (NextExpectedMsgSeqNum) is higher than expected. Expected " + actualNextNum + ", Received " + targetWantsNextSeqNumToBe;
                this.generateLogout(err);
                this.disconnect(err, true);
                return;
            }
        }
        this.getLog().onEvent("Received logon");
        if (!this.state.isInitiator()) {
            int nextExpectedTargetNum = this.state.getMessageStore().getNextTargetMsgSeqNum();
            if (isLogonInNormalSequence) {
                ++nextExpectedTargetNum;
            }
            this.generateLogon(logon, nextExpectedTargetNum);
        }
        if (this.state.isResetSent() && !this.state.isResetReceived()) {
            this.disconnect("Received logon response before sending request", true);
        }
        this.state.setResetSent(false);
        this.state.setResetReceived(false);
        if (!isLogonInNormalSequence) {
            if (this.state.isExpectedLogonNextSeqNumSent()) {
                this.state.setResetRangeFromLastExpectedLogonNextSeqNumLogon();
                this.getLog().onEvent("Required resend will be suppressed as we are setting tag 789");
            }
            if (this.validateSequenceNumbers) {
                this.doTargetTooHigh(logon);
            }
        } else {
            this.state.incrNextTargetMsgSeqNum();
            this.nextQueued();
        }
        if (logon.isSetField(789) && this.enableNextExpectedMsgSeqNum && (targetWantsNextSeqNumToBe = logon.getInt(789)) != nextSenderMsgNumAtLogonReceived) {
            int endSeqNo = nextSenderMsgNumAtLogonReceived;
            if (!this.persistMessages) {
                int next = this.state.getNextSenderMsgSeqNum();
                if (++endSeqNo > next) {
                    endSeqNo = next;
                }
                this.getLog().onEvent("Received implicit ResendRequest via Logon FROM: " + targetWantsNextSeqNumToBe + " TO: " + nextSenderMsgNumAtLogonReceived + " will be reset");
                this.generateSequenceReset(logon, targetWantsNextSeqNumToBe, endSeqNo);
            } else {
                this.getLog().onEvent("Received implicit ResendRequest via Logon FROM: " + targetWantsNextSeqNumToBe + " TO: " + nextSenderMsgNumAtLogonReceived + " will be resent");
                this.resendMessages(logon, targetWantsNextSeqNumToBe, endSeqNo);
            }
        }
        if (this.isLoggedOn()) {
            try {
                this.application.onLogon(this.sessionID);
            }
            catch (Throwable t) {
                this.logApplicationException("onLogon()", t);
            }
            this.stateListener.onLogon();
            this.lastSessionLogon = SystemTime.currentTimeMillis();
            this.logonAttempts = 0;
        }
    }

    private void resendMessages(Message receivedMessage, int beginSeqNo, int endSeqNo) throws IOException, InvalidMessage, FieldNotFound {
        ArrayList<String> messages = new ArrayList<String>();
        try {
            this.state.get(beginSeqNo, endSeqNo, messages);
        }
        catch (IOException e) {
            if (this.forceResendWhenCorruptedStore) {
                LOG.error("Cannot read messages from stores, resend HeartBeats", (Throwable)e);
                for (int i = beginSeqNo; i < endSeqNo; ++i) {
                    Message heartbeat = this.messageFactory.create(this.sessionID.getBeginString(), "0");
                    this.initializeHeader(heartbeat.getHeader());
                    heartbeat.getHeader().setInt(34, i);
                    messages.add(heartbeat.toString());
                }
            }
            throw e;
        }
        int msgSeqNum = 0;
        int begin = 0;
        int current = beginSeqNo;
        boolean appMessageJustSent = false;
        for (String message : messages) {
            String msgType;
            Message msg;
            appMessageJustSent = false;
            try {
                msg = this.parseMessage(message);
                msgSeqNum = msg.getHeader().getInt(34);
            }
            catch (Exception e) {
                this.getLog().onErrorEvent("Error handling ResendRequest: failed to parse message (" + e.getMessage() + "): " + message);
                continue;
            }
            if (current != msgSeqNum && begin == 0) {
                begin = current;
            }
            if (MessageUtils.isAdminMessage(msgType = msg.getHeader().getString(35)) && !this.forceResendWhenCorruptedStore) {
                if (begin == 0) {
                    begin = msgSeqNum;
                }
            } else {
                this.initializeResendFields(msg);
                if (this.resendApproved(msg)) {
                    if (begin != 0) {
                        this.generateSequenceReset(receivedMessage, begin, msgSeqNum);
                    }
                    this.getLog().onEvent("Resending message: " + msgSeqNum);
                    this.send(msg.toString());
                    begin = 0;
                    appMessageJustSent = true;
                } else if (begin == 0) {
                    begin = msgSeqNum;
                }
            }
            current = msgSeqNum + 1;
        }
        int newBegin = beginSeqNo;
        if (appMessageJustSent) {
            newBegin = msgSeqNum + 1;
        }
        if (this.enableNextExpectedMsgSeqNum) {
            if (begin != 0) {
                this.generateSequenceReset(receivedMessage, begin, msgSeqNum + 1);
            } else {
                this.generateSequenceResetIfNeeded(receivedMessage, newBegin, endSeqNo, msgSeqNum);
            }
        } else {
            if (begin != 0) {
                this.generateSequenceReset(receivedMessage, begin, msgSeqNum + 1);
            }
            this.generateSequenceResetIfNeeded(receivedMessage, newBegin, endSeqNo, msgSeqNum);
        }
    }

    private void generateSequenceResetIfNeeded(Message receivedMessage, int beginSeqNo, int endSeqNo, int msgSeqNum) throws IOException, FieldNotFound {
        if (endSeqNo > msgSeqNum) {
            int next = this.state.getNextSenderMsgSeqNum();
            if (++endSeqNo > next) {
                endSeqNo = next;
            }
            this.generateSequenceReset(receivedMessage, beginSeqNo, endSeqNo);
        }
    }

    private void nextQueued() throws FieldNotFound, RejectLogon, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType, IOException, InvalidMessage {
        while (this.nextQueued(this.getExpectedTargetNum())) {
        }
    }

    private boolean nextQueued(int num) throws FieldNotFound, RejectLogon, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType, IOException, InvalidMessage {
        Message msg = this.state.dequeue(num);
        if (msg != null) {
            this.getLog().onEvent("Processing queued message: " + num);
            String msgType = msg.getHeader().getString(35);
            if ("A".equals(msgType) || "2".equals(msgType)) {
                this.state.incrNextTargetMsgSeqNum();
            } else {
                this.nextQueued(msg, msgType);
            }
            return true;
        }
        return false;
    }

    private void nextQueued(Message msg, String msgType) throws InvalidMessage, FieldNotFound, RejectLogon, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType, IOException {
        try {
            this.next(msg, true);
        }
        catch (InvalidMessage e) {
            String message = "Invalid message: " + e;
            if ("A".equals(msgType)) {
                this.disconnect(message, true);
            } else {
                this.getLog().onErrorEvent(message);
                if (this.resetOrDisconnectIfRequired(null)) {
                    return;
                }
            }
            throw e;
        }
    }

    private void doTargetTooHigh(Message msg) throws FieldNotFound, IOException, InvalidMessage {
        Message.Header header = msg.getHeader();
        String beginString = header.getString(8);
        int msgSeqNum = header.getInt(34);
        this.getLog().onEvent("MsgSeqNum too high, expecting " + this.getExpectedTargetNum() + " but received " + msgSeqNum + ": " + msg);
        this.enqueueMessage(msg, msgSeqNum);
        if (this.state.isResendRequested()) {
            SessionState.ResendRange range = this.state.getResendRange();
            if (!this.redundantResentRequestsAllowed && msgSeqNum >= range.getBeginSeqNo()) {
                this.getLog().onEvent("Already sent ResendRequest FROM: " + range.getBeginSeqNo() + " TO: " + range.getEndSeqNo() + ".  Not sending another.");
                return;
            }
        }
        this.generateResendRequest(beginString, msgSeqNum);
    }

    private void generateResendRequest(String beginString, int msgSeqNum) {
        int beginSeqNo = this.getExpectedTargetNum();
        int endSeqNo = msgSeqNum - 1;
        this.sendResendRequest(beginString, msgSeqNum, beginSeqNo, endSeqNo);
    }

    private void sendResendRequest(String beginString, int msgSeqNum, int beginSeqNo, int endSeqNo) {
        int lastEndSeqNoSent;
        int n = lastEndSeqNoSent = this.resendRequestChunkSize == 0 ? endSeqNo : beginSeqNo + this.resendRequestChunkSize - 1;
        if (lastEndSeqNoSent > endSeqNo) {
            lastEndSeqNoSent = endSeqNo;
        }
        if (lastEndSeqNoSent == endSeqNo && !this.useClosedRangeForResend) {
            if (beginString.compareTo("FIX.4.2") >= 0) {
                endSeqNo = 0;
            } else if (beginString.compareTo("FIX.4.1") <= 0) {
                endSeqNo = 999999;
            }
        } else {
            endSeqNo = lastEndSeqNoSent;
        }
        Message resendRequest = this.messageFactory.create(beginString, "2");
        resendRequest.setInt(7, beginSeqNo);
        resendRequest.setInt(16, endSeqNo);
        this.initializeHeader(resendRequest.getHeader());
        this.sendRaw(resendRequest, 0);
        this.getLog().onEvent("Sent ResendRequest FROM: " + beginSeqNo + " TO: " + lastEndSeqNoSent);
        this.state.setResendRange(beginSeqNo, msgSeqNum - 1, this.resendRequestChunkSize == 0 ? 0 : lastEndSeqNoSent);
    }

    private boolean validatePossDup(Message msg) throws FieldNotFound, IOException {
        Message.Header header = msg.getHeader();
        String msgType = header.getString(35);
        if (!"4".equals(msgType)) {
            if (header.isSetField(122)) {
                LocalDateTime sendingTime;
                LocalDateTime origSendingTime = header.getUtcTimeStamp(122);
                if (origSendingTime.compareTo(sendingTime = header.getUtcTimeStamp(52)) > 0) {
                    this.generateReject(msg, 10, 122);
                    this.generateLogout(BAD_ORIG_TIME_TEXT);
                    return false;
                }
            } else if (this.requiresOrigSendingTime) {
                this.generateReject(msg, 1, 122);
                return false;
            }
        }
        return true;
    }

    private boolean isTargetTooHigh(int sequence) throws IOException {
        return sequence > this.state.getNextTargetMsgSeqNum();
    }

    private void generateLogon(Message otherLogon, int expectedTargetNum) throws FieldNotFound {
        Message logon = this.messageFactory.create(this.sessionID.getBeginString(), "A");
        logon.setInt(98, 0);
        if (this.state.isResetReceived()) {
            logon.setBoolean(141, true);
        }
        logon.setInt(108, otherLogon.getInt(108));
        if (this.sessionID.isFIXT()) {
            logon.setField(this.senderDefaultApplVerID);
        }
        if (this.enableLastMsgSeqNumProcessed) {
            logon.getHeader().setInt(369, otherLogon.getHeader().getInt(34));
        }
        this.initializeHeader(logon.getHeader());
        if (this.enableNextExpectedMsgSeqNum) {
            this.getLog().onEvent("Responding to Logon request with tag 789=" + expectedTargetNum);
            logon.setInt(789, expectedTargetNum);
            this.state.setLastExpectedLogonNextSeqNum(expectedTargetNum);
        } else {
            this.getLog().onEvent("Responding to Logon request");
        }
        this.sendRaw(logon, 0);
        this.state.setLogonSent(true);
    }

    /*
     * Exception decompiling
     */
    private boolean sendRaw(Message message, int num) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void enqueueMessage(Message msg, int msgSeqNum) {
        this.state.enqueue(msgSeqNum, msg);
        this.getLog().onEvent("Enqueued at pos " + msgSeqNum + ": " + msg);
    }

    private void resetState() {
        if (!this.isResettingState.compareAndSet(false, true)) {
            return;
        }
        try {
            this.state.reset();
            this.stateListener.onReset();
        }
        finally {
            this.isResettingState.set(false);
        }
    }

    public boolean send(Message message) {
        message.getHeader().removeField(43);
        message.getHeader().removeField(122);
        return this.sendRaw(message, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean send(String messageString) {
        Responder responder;
        this.getLog().onOutgoing(messageString);
        Object object = this.responderLock;
        synchronized (object) {
            responder = this.responder;
        }
        if (responder == null) {
            this.getLog().onEvent("No responder, not sending message: " + messageString);
            return false;
        }
        return responder.send(messageString);
    }

    private boolean isCorrectCompID(Message message) throws FieldNotFound {
        if (!this.checkCompID) {
            return true;
        }
        String senderCompID = Session.getSenderCompIDFromMessage(message);
        String targetCompID = Session.getTargetCompIDFromMessage(message);
        return this.sessionID.getSenderCompID().equals(targetCompID) && this.sessionID.getTargetCompID().equals(senderCompID);
    }

    public DataDictionary getDataDictionary() {
        if (!this.sessionID.isFIXT()) {
            return this.dataDictionaryProvider.getSessionDataDictionary(this.sessionID.getBeginString());
        }
        throw new SessionException("No default data dictionary for FIXT 1.1 and newer");
    }

    public DataDictionaryProvider getDataDictionaryProvider() {
        return this.dataDictionaryProvider;
    }

    public SessionID getSessionID() {
        return this.sessionID;
    }

    public boolean isSessionTime() {
        return this.sessionSchedule == null || this.sessionSchedule.isSessionTime();
    }

    public static boolean doesSessionExist(SessionID sessionID) {
        return sessions.containsKey(sessionID);
    }

    public static int numSessions() {
        return sessions.size();
    }

    public void setLogonTimeout(int seconds) {
        this.state.setLogonTimeout(seconds);
    }

    public void setLogoutTimeout(int seconds) {
        this.state.setLogoutTimeout(seconds);
    }

    public void setHeartBeatInterval(int heartbeatInterval) {
        this.state.setHeartBeatInterval(heartbeatInterval);
    }

    public boolean getCheckCompID() {
        return this.checkCompID;
    }

    public int getLogonTimeout() {
        return this.state.getLogonTimeout();
    }

    public int getLogoutTimeout() {
        return this.state.getLogoutTimeout();
    }

    public boolean getRedundantResentRequestsAllowed() {
        return this.redundantResentRequestsAllowed;
    }

    public boolean getRefreshOnLogon() {
        return this.refreshMessageStoreAtLogon;
    }

    public boolean getResetOnDisconnect() {
        return this.resetOnDisconnect;
    }

    public boolean getResetOnLogout() {
        return this.resetOnLogout;
    }

    public boolean isLogonAlreadySent() {
        return this.state.isLogonAlreadySent();
    }

    public boolean isLogonReceived() {
        return this.state.isLogonReceived();
    }

    public boolean isLogonSendNeeded() {
        return this.state.isLogonSendNeeded();
    }

    public boolean isLogonSent() {
        return this.state.isLogonSent();
    }

    public boolean isLogonTimedOut() {
        return this.state.isLogonTimedOut();
    }

    public boolean isLogoutReceived() {
        return this.state.isLogoutReceived();
    }

    public boolean isLogoutSent() {
        return this.state.isLogoutSent();
    }

    public boolean isLogoutTimedOut() {
        return this.state.isLogoutTimedOut();
    }

    public boolean isRejectGarbledMessage() {
        return this.rejectGarbledMessage;
    }

    public boolean isUsingDataDictionary() {
        return this.dataDictionaryProvider != null;
    }

    public Date getStartTime() throws IOException {
        return this.state.getCreationTime();
    }

    public double getTestRequestDelayMultiplier() {
        return this.state.getTestRequestDelayMultiplier();
    }

    public String toString() {
        String s = this.sessionID.toString();
        try {
            s = s + "[in:" + this.state.getNextTargetMsgSeqNum() + ",out:" + this.state.getNextSenderMsgSeqNum() + "]";
        }
        catch (IOException e) {
            LogUtil.logThrowable(this.sessionID, e.getMessage(), (Throwable)e);
        }
        return s;
    }

    public void addStateListener(SessionStateListener listener) {
        this.stateListeners.addListener(listener);
    }

    public void removeStateListener(SessionStateListener listener) {
        this.stateListeners.removeListener(listener);
    }

    public ApplVerID getSenderDefaultApplicationVersionID() {
        return new ApplVerID(this.senderDefaultApplVerID.getValue());
    }

    public ApplVerID getTargetDefaultApplicationVersionID() {
        return this.targetDefaultApplVerID.get();
    }

    public void setTargetDefaultApplicationVersionID(ApplVerID applVerID) {
        this.targetDefaultApplVerID.set(applVerID);
    }

    private static String extractNumber(String txt, int from) {
        StringBuilder ret = new StringBuilder(txt.length() - from);
        for (int i = from; i != txt.length(); ++i) {
            char c = txt.charAt(i);
            if (c >= '0' && c <= '9') {
                ret.append(c);
                continue;
            }
            if (ret.length() != 0) break;
        }
        return ret.toString();
    }

    protected static Integer extractExpectedSequenceNumber(String txt) {
        if (txt == null) {
            return null;
        }
        String keyword = "expecting";
        int pos = txt.indexOf(keyword);
        if (pos < 0) {
            keyword = "expected";
            pos = txt.indexOf("expected");
        }
        if (pos < 0) {
            return null;
        }
        int from = pos + keyword.length();
        String val = Session.extractNumber(txt, from);
        if (val.length() == 0) {
            return null;
        }
        try {
            return Integer.valueOf(val);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public int getMaxScheduledWriteRequests() {
        return this.maxScheduledWriteRequests;
    }

    public void setMaxScheduledWriteRequests(int maxScheduledWriteRequests) {
        this.maxScheduledWriteRequests = maxScheduledWriteRequests;
    }

    public void setIgnoreHeartBeatFailure(boolean ignoreHeartBeatFailure) {
        this.disableHeartBeatCheck = ignoreHeartBeatFailure;
    }

    public void setRejectGarbledMessage(boolean rejectGarbledMessage) {
        this.rejectGarbledMessage = rejectGarbledMessage;
    }

    public void setRejectInvalidMessage(boolean rejectInvalidMessage) {
        this.rejectInvalidMessage = rejectInvalidMessage;
    }

    public void setRejectMessageOnUnhandledException(boolean rejectMessageOnUnhandledException) {
        this.rejectMessageOnUnhandledException = rejectMessageOnUnhandledException;
    }

    public void setRequiresOrigSendingTime(boolean requiresOrigSendingTime) {
        this.requiresOrigSendingTime = requiresOrigSendingTime;
    }

    public void setForceResendWhenCorruptedStore(boolean forceResendWhenCorruptedStore) {
        this.forceResendWhenCorruptedStore = forceResendWhenCorruptedStore;
    }

    public boolean isAllowedForSession(InetAddress remoteInetAddress) {
        return this.allowedRemoteAddresses == null || this.allowedRemoteAddresses.isEmpty() || this.allowedRemoteAddresses.contains(remoteInetAddress);
    }

    @Override
    public void close() throws IOException {
        this.closeIfCloseable(this.getLog());
        this.closeIfCloseable(this.getStore());
        Session.unregisterSession(this.sessionID, false);
    }

    private void closeIfCloseable(Object resource) throws IOException {
        if (resource instanceof Closeable) {
            ((Closeable)resource).close();
        }
    }

    private void resetIfSessionNotCurrent(SessionID sessionID, long time) throws IOException {
        if (!this.isCurrentSession(time)) {
            this.getLog().onEvent("Session state is not current; resetting " + sessionID);
            this.reset();
        }
    }

    private String getMessageToLog(Message message) {
        return message.toRawString() != null ? message.toRawString() : message.toString();
    }
}

