/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import quickfix.mina.QueueTracker;

public class WatermarkTracker<E, S>
implements QueueTracker<E> {
    private final BlockingQueue<E> queue;
    private final long lowerWatermark;
    private final long upperWatermark;
    private final Consumer<S> onLowerWatermarkCrossed;
    private final Consumer<S> onUpperWatermarkCrossed;
    private final Function<E, S> classifier;
    private final Function<S, StreamTracker> trackerSupplier;

    static <E, Void> WatermarkTracker<E, Void> newMono(BlockingQueue<E> queue, long lowerWatermark, long upperWatermark, Runnable onLowerWatermarkCrossed, Runnable onUpperWatermarkCrossed) {
        return new WatermarkTracker(queue, lowerWatermark, upperWatermark, onLowerWatermarkCrossed, onUpperWatermarkCrossed);
    }

    static <E, S> WatermarkTracker<E, S> newMulti(BlockingQueue<E> queue, long lowerWatermark, long upperWatermark, Function<E, S> classifier, Consumer<S> onLowerWatermarkCrossed, Consumer<S> onUpperWatermarkCrossed) {
        return new WatermarkTracker<E, S>(queue, lowerWatermark, upperWatermark, classifier, onLowerWatermarkCrossed, onUpperWatermarkCrossed);
    }

    private WatermarkTracker(BlockingQueue<E> queue, long lowerWatermark, long upperWatermark, Function<E, S> classifier, Consumer<S> onLowerWatermarkCrossed, Consumer<S> onUpperWatermarkCrossed) {
        this.queue = queue;
        this.lowerWatermark = lowerWatermark;
        this.upperWatermark = upperWatermark;
        this.classifier = classifier;
        this.onLowerWatermarkCrossed = onLowerWatermarkCrossed;
        this.onUpperWatermarkCrossed = onUpperWatermarkCrossed;
        ConcurrentHashMap trackerMap = new ConcurrentHashMap();
        this.trackerSupplier = key -> trackerMap.computeIfAbsent(key, x$0 -> new StreamTracker(x$0));
    }

    private WatermarkTracker(BlockingQueue<E> queue, long lowerWatermark, long upperWatermark, Runnable onLowerWatermarkCrossed, Runnable onUpperWatermarkCrossed) {
        this.queue = queue;
        this.lowerWatermark = lowerWatermark;
        this.upperWatermark = upperWatermark;
        this.classifier = x -> null;
        this.onLowerWatermarkCrossed = x -> onLowerWatermarkCrossed.run();
        this.onUpperWatermarkCrossed = x -> onUpperWatermarkCrossed.run();
        StreamTracker streamTracker = new StreamTracker(null);
        this.trackerSupplier = key -> streamTracker;
    }

    @Override
    public void put(E e) throws InterruptedException {
        this.queue.put(e);
        this.trackerForPayload(e).incoming(1);
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        E e = this.queue.poll(timeout, unit);
        if (e != null) {
            this.trackerForPayload(e).outgoing(1);
        }
        return e;
    }

    @Override
    public int drainTo(final Collection<E> collection) {
        return this.queue.drainTo(new AbstractCollection<E>(){

            @Override
            public Iterator<E> iterator() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int size() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean add(E e) {
                boolean added = collection.add(e);
                if (added) {
                    WatermarkTracker.this.trackerForPayload(e).outgoing(1);
                }
                return added;
            }
        });
    }

    public boolean isSuspended(S key) {
        return this.trackerForStream(key).isSuspended();
    }

    public boolean isSuspended() {
        return this.isSuspended(null);
    }

    StreamTracker trackerForPayload(E e) {
        return this.trackerForStream(this.classifier.apply(e));
    }

    StreamTracker trackerForStream(S s) {
        return this.trackerSupplier.apply(s);
    }

    class StreamTracker {
        private final S key;
        long counter = 0L;
        private boolean suspended = false;

        StreamTracker(S key) {
            this.key = key;
        }

        synchronized void incoming(int n) {
            if ((this.counter += (long)n) >= WatermarkTracker.this.upperWatermark && !this.suspended) {
                this.suspended = true;
                WatermarkTracker.this.onUpperWatermarkCrossed.accept(this.key);
            }
        }

        synchronized void outgoing(int n) {
            if ((this.counter -= (long)n) == WatermarkTracker.this.lowerWatermark && this.suspended) {
                this.suspended = false;
                WatermarkTracker.this.onLowerWatermarkCrossed.accept(this.key);
            }
        }

        synchronized boolean isSuspended() {
            return this.suspended;
        }
    }
}

