/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.pulsar.client.api.BatcherBuilder;
import org.apache.pulsar.client.api.CompressionType;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.HashingScheme;
import org.apache.pulsar.client.api.MessageRouter;
import org.apache.pulsar.client.api.MessageRoutingMode;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerBuilder;
import org.apache.pulsar.client.api.ProducerCryptoFailureAction;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.interceptor.ProducerInterceptor;
import org.apache.pulsar.client.api.interceptor.ProducerInterceptorWrapper;
import org.apache.pulsar.client.impl.ProducerInterceptors;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.conf.ConfigurationDataUtils;
import org.apache.pulsar.client.impl.conf.ProducerConfigurationData;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;

public class ProducerBuilderImpl<T>
implements ProducerBuilder<T> {
    private final PulsarClientImpl client;
    private ProducerConfigurationData conf;
    private Schema<T> schema;
    private List<ProducerInterceptor> interceptorList;

    @VisibleForTesting
    public ProducerBuilderImpl(PulsarClientImpl client, Schema<T> schema) {
        this(client, new ProducerConfigurationData(), schema);
    }

    private ProducerBuilderImpl(PulsarClientImpl client, ProducerConfigurationData conf, Schema<T> schema) {
        this.client = client;
        this.conf = conf;
        this.schema = schema;
    }

    public ProducerBuilder<T> schema(Schema<T> schema) {
        this.schema = schema;
        return this;
    }

    public ProducerBuilder<T> clone() {
        return new ProducerBuilderImpl<T>(this.client, this.conf.clone(), this.schema);
    }

    public Producer<T> create() throws PulsarClientException {
        try {
            return this.createAsync().get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public CompletableFuture<Producer<T>> createAsync() {
        Preconditions.checkArgument(!this.conf.isBatchingEnabled() || !this.conf.isChunkingEnabled(), "Batching and chunking of messages can't be enabled together");
        if (this.conf.getTopicName() == null) {
            return FutureUtil.failedFuture(new IllegalArgumentException("Topic name must be set on the producer builder"));
        }
        try {
            this.setMessageRoutingMode();
        }
        catch (PulsarClientException pce) {
            return FutureUtil.failedFuture(pce);
        }
        return this.interceptorList == null || this.interceptorList.size() == 0 ? this.client.createProducerAsync(this.conf, this.schema, null) : this.client.createProducerAsync(this.conf, this.schema, new ProducerInterceptors(this.interceptorList));
    }

    public ProducerBuilder<T> loadConf(Map<String, Object> config) {
        this.conf = ConfigurationDataUtils.loadData(config, this.conf, ProducerConfigurationData.class);
        return this;
    }

    public ProducerBuilder<T> topic(String topicName) {
        Preconditions.checkArgument(StringUtils.isNotBlank(topicName), "topicName cannot be blank");
        this.conf.setTopicName(StringUtils.trim(topicName));
        return this;
    }

    public ProducerBuilder<T> producerName(String producerName) {
        this.conf.setProducerName(producerName);
        return this;
    }

    public ProducerBuilder<T> sendTimeout(int sendTimeout, @NonNull TimeUnit unit) {
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        this.conf.setSendTimeoutMs(sendTimeout, unit);
        return this;
    }

    public ProducerBuilder<T> maxPendingMessages(int maxPendingMessages) {
        this.conf.setMaxPendingMessages(maxPendingMessages);
        return this;
    }

    public ProducerBuilder<T> maxPendingMessagesAcrossPartitions(int maxPendingMessagesAcrossPartitions) {
        this.conf.setMaxPendingMessagesAcrossPartitions(maxPendingMessagesAcrossPartitions);
        return this;
    }

    public ProducerBuilder<T> blockIfQueueFull(boolean blockIfQueueFull) {
        this.conf.setBlockIfQueueFull(blockIfQueueFull);
        return this;
    }

    public ProducerBuilder<T> messageRoutingMode(@NonNull MessageRoutingMode messageRouteMode) {
        if (messageRouteMode == null) {
            throw new NullPointerException("messageRouteMode is marked non-null but is null");
        }
        this.conf.setMessageRoutingMode(messageRouteMode);
        return this;
    }

    public ProducerBuilder<T> compressionType(@NonNull CompressionType compressionType) {
        if (compressionType == null) {
            throw new NullPointerException("compressionType is marked non-null but is null");
        }
        this.conf.setCompressionType(compressionType);
        return this;
    }

    public ProducerBuilder<T> hashingScheme(@NonNull HashingScheme hashingScheme) {
        if (hashingScheme == null) {
            throw new NullPointerException("hashingScheme is marked non-null but is null");
        }
        this.conf.setHashingScheme(hashingScheme);
        return this;
    }

    public ProducerBuilder<T> messageRouter(@NonNull MessageRouter messageRouter) {
        if (messageRouter == null) {
            throw new NullPointerException("messageRouter is marked non-null but is null");
        }
        this.conf.setCustomMessageRouter(messageRouter);
        return this;
    }

    public ProducerBuilder<T> enableBatching(boolean batchMessagesEnabled) {
        this.conf.setBatchingEnabled(batchMessagesEnabled);
        return this;
    }

    public ProducerBuilder<T> enableChunking(boolean chunkingEnabled) {
        this.conf.setChunkingEnabled(chunkingEnabled);
        return this;
    }

    public ProducerBuilder<T> cryptoKeyReader(@NonNull CryptoKeyReader cryptoKeyReader) {
        if (cryptoKeyReader == null) {
            throw new NullPointerException("cryptoKeyReader is marked non-null but is null");
        }
        this.conf.setCryptoKeyReader(cryptoKeyReader);
        return this;
    }

    public ProducerBuilder<T> addEncryptionKey(String key) {
        Preconditions.checkArgument(StringUtils.isNotBlank(key), "Encryption key cannot be blank");
        this.conf.getEncryptionKeys().add(key);
        return this;
    }

    public ProducerBuilder<T> cryptoFailureAction(@NonNull ProducerCryptoFailureAction action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        this.conf.setCryptoFailureAction(action);
        return this;
    }

    public ProducerBuilder<T> batchingMaxPublishDelay(long batchDelay, @NonNull TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new NullPointerException("timeUnit is marked non-null but is null");
        }
        this.conf.setBatchingMaxPublishDelayMicros(batchDelay, timeUnit);
        return this;
    }

    public ProducerBuilder<T> roundRobinRouterBatchingPartitionSwitchFrequency(int frequency) {
        this.conf.setBatchingPartitionSwitchFrequencyByPublishDelay(frequency);
        return this;
    }

    public ProducerBuilder<T> batchingMaxMessages(int batchMessagesMaxMessagesPerBatch) {
        this.conf.setBatchingMaxMessages(batchMessagesMaxMessagesPerBatch);
        return this;
    }

    public ProducerBuilder<T> batchingMaxBytes(int batchingMaxBytes) {
        this.conf.setBatchingMaxBytes(batchingMaxBytes);
        return this;
    }

    public ProducerBuilder<T> batcherBuilder(BatcherBuilder batcherBuilder) {
        this.conf.setBatcherBuilder(batcherBuilder);
        return this;
    }

    public ProducerBuilder<T> initialSequenceId(long initialSequenceId) {
        this.conf.setInitialSequenceId(initialSequenceId);
        return this;
    }

    public ProducerBuilder<T> property(String key, String value) {
        Preconditions.checkArgument(StringUtils.isNotBlank(key) && StringUtils.isNotBlank(value), "property key/value cannot be blank");
        this.conf.getProperties().put(key, value);
        return this;
    }

    public ProducerBuilder<T> properties(@NonNull Map<String, String> properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        Preconditions.checkArgument(!properties.isEmpty(), "properties cannot be empty");
        properties.entrySet().forEach(entry -> Preconditions.checkArgument(StringUtils.isNotBlank((CharSequence)entry.getKey()) && StringUtils.isNotBlank((CharSequence)entry.getValue()), "properties' key/value cannot be blank"));
        this.conf.getProperties().putAll(properties);
        return this;
    }

    public ProducerBuilder<T> intercept(ProducerInterceptor ... interceptors) {
        if (this.interceptorList == null) {
            this.interceptorList = new ArrayList<ProducerInterceptor>();
        }
        this.interceptorList.addAll(Arrays.asList(interceptors));
        return this;
    }

    @Deprecated
    public ProducerBuilder<T> intercept(org.apache.pulsar.client.api.ProducerInterceptor<T> ... interceptors) {
        if (this.interceptorList == null) {
            this.interceptorList = new ArrayList<ProducerInterceptor>();
        }
        this.interceptorList.addAll(Arrays.stream(interceptors).map(ProducerInterceptorWrapper::new).collect(Collectors.toList()));
        return this;
    }

    public ProducerBuilder<T> autoUpdatePartitions(boolean autoUpdate) {
        this.conf.setAutoUpdatePartitions(autoUpdate);
        return this;
    }

    public ProducerBuilder<T> enableMultiSchema(boolean multiSchema) {
        this.conf.setMultiSchema(multiSchema);
        return this;
    }

    private void setMessageRoutingMode() throws PulsarClientException {
        if (this.conf.getMessageRoutingMode() == null && this.conf.getCustomMessageRouter() == null) {
            this.messageRoutingMode(MessageRoutingMode.RoundRobinPartition);
        } else if (this.conf.getMessageRoutingMode() == null && this.conf.getCustomMessageRouter() != null) {
            this.messageRoutingMode(MessageRoutingMode.CustomPartition);
        } else if (this.conf.getMessageRoutingMode() == MessageRoutingMode.CustomPartition && this.conf.getCustomMessageRouter() == null || this.conf.getMessageRoutingMode() != MessageRoutingMode.CustomPartition && this.conf.getCustomMessageRouter() != null) {
            throw new PulsarClientException("When 'messageRouter' is set, 'messageRoutingMode' should be set as " + MessageRoutingMode.CustomPartition);
        }
    }

    public String toString() {
        return this.conf != null ? this.conf.toString() : null;
    }

    public PulsarClientImpl getClient() {
        return this.client;
    }

    public ProducerConfigurationData getConf() {
        return this.conf;
    }

    public Schema<T> getSchema() {
        return this.schema;
    }

    public List<ProducerInterceptor> getInterceptorList() {
        return this.interceptorList;
    }
}

