/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;
import org.apache.pulsar.common.util.FieldParser;
import org.apache.pulsar.shade.com.google.common.base.MoreObjects;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;

public class OffloadPolicies
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final int DEFAULT_MAX_BLOCK_SIZE_IN_BYTES = 0x4000000;
    public static final int DEFAULT_READ_BUFFER_SIZE_IN_BYTES = 0x100000;
    public static final int DEFAULT_OFFLOAD_MAX_THREADS = 2;
    public static final int DEFAULT_OFFLOAD_MAX_PREFETCH_ROUNDS = 1;
    public static final String[] DRIVER_NAMES = new String[]{"S3", "aws-s3", "google-cloud-storage", "filesystem"};
    public static final String DEFAULT_OFFLOADER_DIRECTORY = "./offloaders";
    public static final long DEFAULT_OFFLOAD_THRESHOLD_IN_BYTES = -1L;
    public static final Long DEFAULT_OFFLOAD_DELETION_LAG_IN_MILLIS = null;
    private String offloadersDirectory = "./offloaders";
    private String managedLedgerOffloadDriver = null;
    private int managedLedgerOffloadMaxThreads = 2;
    private int managedLedgerOffloadPrefetchRounds = 1;
    private long managedLedgerOffloadThresholdInBytes = -1L;
    private Long managedLedgerOffloadDeletionLagInMillis = DEFAULT_OFFLOAD_DELETION_LAG_IN_MILLIS;
    private String s3ManagedLedgerOffloadRegion = null;
    private String s3ManagedLedgerOffloadBucket = null;
    private String s3ManagedLedgerOffloadServiceEndpoint = null;
    private int s3ManagedLedgerOffloadMaxBlockSizeInBytes = 0x4000000;
    private int s3ManagedLedgerOffloadReadBufferSizeInBytes = 0x100000;
    private String s3ManagedLedgerOffloadRole = null;
    private String s3ManagedLedgerOffloadRoleSessionName = "pulsar-s3-offload";
    private String gcsManagedLedgerOffloadRegion = null;
    private String gcsManagedLedgerOffloadBucket = null;
    private int gcsManagedLedgerOffloadMaxBlockSizeInBytes = 0x4000000;
    private int gcsManagedLedgerOffloadReadBufferSizeInBytes = 0x100000;
    private String gcsManagedLedgerOffloadServiceAccountKeyFile = null;
    private String fileSystemProfilePath = null;
    private String fileSystemURI = null;

    public static OffloadPolicies create(String driver, String region, String bucket, String endpoint, int maxBlockSizeInBytes, int readBufferSizeInBytes, long offloadThresholdInBytes, Long offloadDeletionLagInMillis) {
        OffloadPolicies offloadPolicies = new OffloadPolicies();
        offloadPolicies.setManagedLedgerOffloadDriver(driver);
        offloadPolicies.setManagedLedgerOffloadThresholdInBytes(offloadThresholdInBytes);
        offloadPolicies.setManagedLedgerOffloadDeletionLagInMillis(offloadDeletionLagInMillis);
        if (driver.equalsIgnoreCase(DRIVER_NAMES[0]) || driver.equalsIgnoreCase(DRIVER_NAMES[1])) {
            offloadPolicies.setS3ManagedLedgerOffloadRegion(region);
            offloadPolicies.setS3ManagedLedgerOffloadBucket(bucket);
            offloadPolicies.setS3ManagedLedgerOffloadServiceEndpoint(endpoint);
            offloadPolicies.setS3ManagedLedgerOffloadMaxBlockSizeInBytes(maxBlockSizeInBytes);
            offloadPolicies.setS3ManagedLedgerOffloadReadBufferSizeInBytes(readBufferSizeInBytes);
        } else if (driver.equalsIgnoreCase(DRIVER_NAMES[2])) {
            offloadPolicies.setGcsManagedLedgerOffloadRegion(region);
            offloadPolicies.setGcsManagedLedgerOffloadBucket(bucket);
            offloadPolicies.setGcsManagedLedgerOffloadMaxBlockSizeInBytes(maxBlockSizeInBytes);
            offloadPolicies.setGcsManagedLedgerOffloadReadBufferSizeInBytes(readBufferSizeInBytes);
        }
        return offloadPolicies;
    }

    public static OffloadPolicies create(Properties properties) {
        OffloadPolicies data = new OffloadPolicies();
        Field[] fields = OffloadPolicies.class.getDeclaredFields();
        Arrays.stream(fields).forEach(f -> {
            if (properties.containsKey(f.getName())) {
                try {
                    f.setAccessible(true);
                    f.set(data, FieldParser.value((String)properties.get(f.getName()), f));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("failed to initialize %s field while setting value %s", f.getName(), properties.get(f.getName())), e);
                }
            }
        });
        return data;
    }

    public boolean driverSupported() {
        return Arrays.stream(DRIVER_NAMES).anyMatch(d -> d.equalsIgnoreCase(this.managedLedgerOffloadDriver));
    }

    public static String getSupportedDriverNames() {
        return StringUtils.join((Object[])DRIVER_NAMES, ",");
    }

    public boolean isS3Driver() {
        if (this.managedLedgerOffloadDriver == null) {
            return false;
        }
        return this.managedLedgerOffloadDriver.equalsIgnoreCase(DRIVER_NAMES[0]) || this.managedLedgerOffloadDriver.equalsIgnoreCase(DRIVER_NAMES[1]);
    }

    public boolean isGcsDriver() {
        if (this.managedLedgerOffloadDriver == null) {
            return false;
        }
        return this.managedLedgerOffloadDriver.equalsIgnoreCase(DRIVER_NAMES[2]);
    }

    public boolean isFileSystemDriver() {
        if (this.managedLedgerOffloadDriver == null) {
            return false;
        }
        return this.managedLedgerOffloadDriver.equalsIgnoreCase(DRIVER_NAMES[3]);
    }

    public boolean bucketValid() {
        if (this.managedLedgerOffloadDriver == null) {
            return false;
        }
        if (this.isS3Driver()) {
            return StringUtils.isNotEmpty(this.s3ManagedLedgerOffloadBucket);
        }
        if (this.isGcsDriver()) {
            return StringUtils.isNotEmpty(this.gcsManagedLedgerOffloadBucket);
        }
        return this.isFileSystemDriver();
    }

    public int hashCode() {
        return Objects.hash(this.managedLedgerOffloadDriver, this.managedLedgerOffloadMaxThreads, this.managedLedgerOffloadPrefetchRounds, this.managedLedgerOffloadThresholdInBytes, this.managedLedgerOffloadDeletionLagInMillis, this.s3ManagedLedgerOffloadRegion, this.s3ManagedLedgerOffloadBucket, this.s3ManagedLedgerOffloadServiceEndpoint, this.s3ManagedLedgerOffloadMaxBlockSizeInBytes, this.s3ManagedLedgerOffloadReadBufferSizeInBytes, this.s3ManagedLedgerOffloadRole, this.s3ManagedLedgerOffloadRoleSessionName, this.gcsManagedLedgerOffloadRegion, this.gcsManagedLedgerOffloadBucket, this.gcsManagedLedgerOffloadMaxBlockSizeInBytes, this.gcsManagedLedgerOffloadReadBufferSizeInBytes, this.gcsManagedLedgerOffloadServiceAccountKeyFile, this.fileSystemProfilePath, this.fileSystemURI);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OffloadPolicies other = (OffloadPolicies)obj;
        return Objects.equals(this.managedLedgerOffloadDriver, other.getManagedLedgerOffloadDriver()) && Objects.equals(this.managedLedgerOffloadMaxThreads, other.getManagedLedgerOffloadMaxThreads()) && Objects.equals(this.managedLedgerOffloadPrefetchRounds, other.getManagedLedgerOffloadPrefetchRounds()) && Objects.equals(this.managedLedgerOffloadThresholdInBytes, other.getManagedLedgerOffloadThresholdInBytes()) && Objects.equals(this.managedLedgerOffloadDeletionLagInMillis, other.getManagedLedgerOffloadDeletionLagInMillis()) && Objects.equals(this.s3ManagedLedgerOffloadRegion, other.getS3ManagedLedgerOffloadRegion()) && Objects.equals(this.s3ManagedLedgerOffloadBucket, other.getS3ManagedLedgerOffloadBucket()) && Objects.equals(this.s3ManagedLedgerOffloadServiceEndpoint, other.getS3ManagedLedgerOffloadServiceEndpoint()) && Objects.equals(this.s3ManagedLedgerOffloadMaxBlockSizeInBytes, other.getS3ManagedLedgerOffloadMaxBlockSizeInBytes()) && Objects.equals(this.s3ManagedLedgerOffloadReadBufferSizeInBytes, other.getS3ManagedLedgerOffloadReadBufferSizeInBytes()) && Objects.equals(this.s3ManagedLedgerOffloadRole, other.getS3ManagedLedgerOffloadRole()) && Objects.equals(this.s3ManagedLedgerOffloadRoleSessionName, other.getS3ManagedLedgerOffloadRoleSessionName()) && Objects.equals(this.gcsManagedLedgerOffloadRegion, other.getGcsManagedLedgerOffloadRegion()) && Objects.equals(this.gcsManagedLedgerOffloadBucket, other.getGcsManagedLedgerOffloadBucket()) && Objects.equals(this.gcsManagedLedgerOffloadMaxBlockSizeInBytes, other.getGcsManagedLedgerOffloadMaxBlockSizeInBytes()) && Objects.equals(this.gcsManagedLedgerOffloadReadBufferSizeInBytes, other.getGcsManagedLedgerOffloadReadBufferSizeInBytes()) && Objects.equals(this.gcsManagedLedgerOffloadServiceAccountKeyFile, other.getGcsManagedLedgerOffloadServiceAccountKeyFile()) && Objects.equals(this.fileSystemProfilePath, other.getFileSystemProfilePath()) && Objects.equals(this.fileSystemURI, other.getFileSystemURI());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("managedLedgerOffloadDriver", this.managedLedgerOffloadDriver).add("managedLedgerOffloadMaxThreads", this.managedLedgerOffloadMaxThreads).add("managedLedgerOffloadPrefetchRounds", this.managedLedgerOffloadPrefetchRounds).add("managedLedgerOffloadThresholdInBytes", this.managedLedgerOffloadThresholdInBytes).add("managedLedgerOffloadDeletionLagInMillis", this.managedLedgerOffloadDeletionLagInMillis).add("s3ManagedLedgerOffloadRegion", this.s3ManagedLedgerOffloadRegion).add("s3ManagedLedgerOffloadBucket", this.s3ManagedLedgerOffloadBucket).add("s3ManagedLedgerOffloadServiceEndpoint", this.s3ManagedLedgerOffloadServiceEndpoint).add("s3ManagedLedgerOffloadMaxBlockSizeInBytes", this.s3ManagedLedgerOffloadMaxBlockSizeInBytes).add("s3ManagedLedgerOffloadReadBufferSizeInBytes", this.s3ManagedLedgerOffloadReadBufferSizeInBytes).add("s3ManagedLedgerOffloadRole", this.s3ManagedLedgerOffloadRole).add("s3ManagedLedgerOffloadRoleSessionName", this.s3ManagedLedgerOffloadRoleSessionName).add("gcsManagedLedgerOffloadRegion", this.gcsManagedLedgerOffloadRegion).add("gcsManagedLedgerOffloadBucket", this.gcsManagedLedgerOffloadBucket).add("gcsManagedLedgerOffloadMaxBlockSizeInBytes", this.gcsManagedLedgerOffloadMaxBlockSizeInBytes).add("gcsManagedLedgerOffloadReadBufferSizeInBytes", this.gcsManagedLedgerOffloadReadBufferSizeInBytes).add("gcsManagedLedgerOffloadServiceAccountKeyFile", this.gcsManagedLedgerOffloadServiceAccountKeyFile).add("fileSystemProfilePath", this.fileSystemProfilePath).add("fileSystemURI", this.fileSystemURI).toString();
    }

    public String getOffloadersDirectory() {
        return this.offloadersDirectory;
    }

    public String getManagedLedgerOffloadDriver() {
        return this.managedLedgerOffloadDriver;
    }

    public int getManagedLedgerOffloadMaxThreads() {
        return this.managedLedgerOffloadMaxThreads;
    }

    public int getManagedLedgerOffloadPrefetchRounds() {
        return this.managedLedgerOffloadPrefetchRounds;
    }

    public long getManagedLedgerOffloadThresholdInBytes() {
        return this.managedLedgerOffloadThresholdInBytes;
    }

    public Long getManagedLedgerOffloadDeletionLagInMillis() {
        return this.managedLedgerOffloadDeletionLagInMillis;
    }

    public String getS3ManagedLedgerOffloadRegion() {
        return this.s3ManagedLedgerOffloadRegion;
    }

    public String getS3ManagedLedgerOffloadBucket() {
        return this.s3ManagedLedgerOffloadBucket;
    }

    public String getS3ManagedLedgerOffloadServiceEndpoint() {
        return this.s3ManagedLedgerOffloadServiceEndpoint;
    }

    public int getS3ManagedLedgerOffloadMaxBlockSizeInBytes() {
        return this.s3ManagedLedgerOffloadMaxBlockSizeInBytes;
    }

    public int getS3ManagedLedgerOffloadReadBufferSizeInBytes() {
        return this.s3ManagedLedgerOffloadReadBufferSizeInBytes;
    }

    public String getS3ManagedLedgerOffloadRole() {
        return this.s3ManagedLedgerOffloadRole;
    }

    public String getS3ManagedLedgerOffloadRoleSessionName() {
        return this.s3ManagedLedgerOffloadRoleSessionName;
    }

    public String getGcsManagedLedgerOffloadRegion() {
        return this.gcsManagedLedgerOffloadRegion;
    }

    public String getGcsManagedLedgerOffloadBucket() {
        return this.gcsManagedLedgerOffloadBucket;
    }

    public int getGcsManagedLedgerOffloadMaxBlockSizeInBytes() {
        return this.gcsManagedLedgerOffloadMaxBlockSizeInBytes;
    }

    public int getGcsManagedLedgerOffloadReadBufferSizeInBytes() {
        return this.gcsManagedLedgerOffloadReadBufferSizeInBytes;
    }

    public String getGcsManagedLedgerOffloadServiceAccountKeyFile() {
        return this.gcsManagedLedgerOffloadServiceAccountKeyFile;
    }

    public String getFileSystemProfilePath() {
        return this.fileSystemProfilePath;
    }

    public String getFileSystemURI() {
        return this.fileSystemURI;
    }

    public void setOffloadersDirectory(String offloadersDirectory) {
        this.offloadersDirectory = offloadersDirectory;
    }

    public void setManagedLedgerOffloadDriver(String managedLedgerOffloadDriver) {
        this.managedLedgerOffloadDriver = managedLedgerOffloadDriver;
    }

    public void setManagedLedgerOffloadMaxThreads(int managedLedgerOffloadMaxThreads) {
        this.managedLedgerOffloadMaxThreads = managedLedgerOffloadMaxThreads;
    }

    public void setManagedLedgerOffloadPrefetchRounds(int managedLedgerOffloadPrefetchRounds) {
        this.managedLedgerOffloadPrefetchRounds = managedLedgerOffloadPrefetchRounds;
    }

    public void setManagedLedgerOffloadThresholdInBytes(long managedLedgerOffloadThresholdInBytes) {
        this.managedLedgerOffloadThresholdInBytes = managedLedgerOffloadThresholdInBytes;
    }

    public void setManagedLedgerOffloadDeletionLagInMillis(Long managedLedgerOffloadDeletionLagInMillis) {
        this.managedLedgerOffloadDeletionLagInMillis = managedLedgerOffloadDeletionLagInMillis;
    }

    public void setS3ManagedLedgerOffloadRegion(String s3ManagedLedgerOffloadRegion) {
        this.s3ManagedLedgerOffloadRegion = s3ManagedLedgerOffloadRegion;
    }

    public void setS3ManagedLedgerOffloadBucket(String s3ManagedLedgerOffloadBucket) {
        this.s3ManagedLedgerOffloadBucket = s3ManagedLedgerOffloadBucket;
    }

    public void setS3ManagedLedgerOffloadServiceEndpoint(String s3ManagedLedgerOffloadServiceEndpoint) {
        this.s3ManagedLedgerOffloadServiceEndpoint = s3ManagedLedgerOffloadServiceEndpoint;
    }

    public void setS3ManagedLedgerOffloadMaxBlockSizeInBytes(int s3ManagedLedgerOffloadMaxBlockSizeInBytes) {
        this.s3ManagedLedgerOffloadMaxBlockSizeInBytes = s3ManagedLedgerOffloadMaxBlockSizeInBytes;
    }

    public void setS3ManagedLedgerOffloadReadBufferSizeInBytes(int s3ManagedLedgerOffloadReadBufferSizeInBytes) {
        this.s3ManagedLedgerOffloadReadBufferSizeInBytes = s3ManagedLedgerOffloadReadBufferSizeInBytes;
    }

    public void setS3ManagedLedgerOffloadRole(String s3ManagedLedgerOffloadRole) {
        this.s3ManagedLedgerOffloadRole = s3ManagedLedgerOffloadRole;
    }

    public void setS3ManagedLedgerOffloadRoleSessionName(String s3ManagedLedgerOffloadRoleSessionName) {
        this.s3ManagedLedgerOffloadRoleSessionName = s3ManagedLedgerOffloadRoleSessionName;
    }

    public void setGcsManagedLedgerOffloadRegion(String gcsManagedLedgerOffloadRegion) {
        this.gcsManagedLedgerOffloadRegion = gcsManagedLedgerOffloadRegion;
    }

    public void setGcsManagedLedgerOffloadBucket(String gcsManagedLedgerOffloadBucket) {
        this.gcsManagedLedgerOffloadBucket = gcsManagedLedgerOffloadBucket;
    }

    public void setGcsManagedLedgerOffloadMaxBlockSizeInBytes(int gcsManagedLedgerOffloadMaxBlockSizeInBytes) {
        this.gcsManagedLedgerOffloadMaxBlockSizeInBytes = gcsManagedLedgerOffloadMaxBlockSizeInBytes;
    }

    public void setGcsManagedLedgerOffloadReadBufferSizeInBytes(int gcsManagedLedgerOffloadReadBufferSizeInBytes) {
        this.gcsManagedLedgerOffloadReadBufferSizeInBytes = gcsManagedLedgerOffloadReadBufferSizeInBytes;
    }

    public void setGcsManagedLedgerOffloadServiceAccountKeyFile(String gcsManagedLedgerOffloadServiceAccountKeyFile) {
        this.gcsManagedLedgerOffloadServiceAccountKeyFile = gcsManagedLedgerOffloadServiceAccountKeyFile;
    }

    public void setFileSystemProfilePath(String fileSystemProfilePath) {
        this.fileSystemProfilePath = fileSystemProfilePath;
    }

    public void setFileSystemURI(String fileSystemURI) {
        this.fileSystemURI = fileSystemURI;
    }
}

