/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.impl.ClientCnx;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.client.util.ObjectCache;
import org.apache.pulsar.common.protocol.ByteBufPair;
import org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.common.util.keystoretls.KeyStoreSSLContext;
import org.apache.pulsar.common.util.keystoretls.NettySSLContextAutoRefreshBuilder;
import org.apache.pulsar.shade.io.netty.channel.ChannelHandler;
import org.apache.pulsar.shade.io.netty.channel.ChannelInitializer;
import org.apache.pulsar.shade.io.netty.channel.socket.SocketChannel;
import org.apache.pulsar.shade.io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.apache.pulsar.shade.io.netty.handler.ssl.SslContext;
import org.apache.pulsar.shade.io.netty.handler.ssl.SslHandler;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private static final Logger log = LoggerFactory.getLogger(PulsarChannelInitializer.class);
    public static final String TLS_HANDLER = "tls";
    private final Supplier<ClientCnx> clientCnxSupplier;
    private final boolean tlsEnabled;
    private final boolean tlsEnabledWithKeyStore;
    private final Supplier<SslContext> sslContextSupplier;
    private NettySSLContextAutoRefreshBuilder nettySSLContextAutoRefreshBuilder;
    private String sniHostName;
    private int sniHostPort;
    private static final long TLS_CERTIFICATE_CACHE_MILLIS = TimeUnit.MINUTES.toMillis(1L);

    public PulsarChannelInitializer(ClientConfigurationData conf, Supplier<ClientCnx> clientCnxSupplier) throws Exception {
        this.clientCnxSupplier = clientCnxSupplier;
        this.tlsEnabled = conf.isUseTls();
        this.tlsEnabledWithKeyStore = conf.isUseKeyStoreTls();
        if (this.tlsEnabled) {
            if (this.tlsEnabledWithKeyStore) {
                AuthenticationDataProvider authData1 = conf.getAuthentication().getAuthData();
                this.nettySSLContextAutoRefreshBuilder = new NettySSLContextAutoRefreshBuilder(conf.getSslProvider(), conf.isTlsAllowInsecureConnection(), conf.getTlsTrustStoreType(), conf.getTlsTrustStorePath(), conf.getTlsTrustStorePassword(), conf.getTlsCiphers(), conf.getTlsProtocols(), TLS_CERTIFICATE_CACHE_MILLIS, authData1);
            }
            this.sslContextSupplier = new ObjectCache<SslContext>(() -> {
                try {
                    AuthenticationDataProvider authData = conf.getAuthentication().getAuthData();
                    if (authData.hasDataForTls()) {
                        return SecurityUtility.createNettySslContextForClient(conf.isTlsAllowInsecureConnection(), conf.getTlsTrustCertsFilePath(), (X509Certificate[])authData.getTlsCertificates(), authData.getTlsPrivateKey());
                    }
                    return SecurityUtility.createNettySslContextForClient(conf.isTlsAllowInsecureConnection(), conf.getTlsTrustCertsFilePath());
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to create TLS context", e);
                }
            }, TLS_CERTIFICATE_CACHE_MILLIS, TimeUnit.MILLISECONDS);
        } else {
            this.sslContextSupplier = null;
        }
    }

    @Override
    public void initChannel(SocketChannel ch) throws Exception {
        if (this.tlsEnabled) {
            if (this.tlsEnabledWithKeyStore) {
                ch.pipeline().addLast(TLS_HANDLER, (ChannelHandler)new SslHandler(((KeyStoreSSLContext)this.nettySSLContextAutoRefreshBuilder.get()).createSSLEngine()));
            } else {
                SslHandler handler = StringUtils.isNotBlank(this.sniHostName) ? this.sslContextSupplier.get().newHandler(ch.alloc(), this.sniHostName, this.sniHostPort) : this.sslContextSupplier.get().newHandler(ch.alloc());
                ch.pipeline().addLast(TLS_HANDLER, (ChannelHandler)handler);
            }
            ch.pipeline().addLast("ByteBufPairEncoder", (ChannelHandler)ByteBufPair.COPYING_ENCODER);
        } else {
            ch.pipeline().addLast("ByteBufPairEncoder", (ChannelHandler)ByteBufPair.ENCODER);
        }
        ch.pipeline().addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(5253120, 0, 4, 0, 4));
        ch.pipeline().addLast("handler", (ChannelHandler)this.clientCnxSupplier.get());
    }

    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    public void setSniHostName(String sniHostName) {
        this.sniHostName = sniHostName;
    }

    public void setSniHostPort(int sniHostPort) {
        this.sniHostPort = sniHostPort;
    }
}

