/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.Worker;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.functions.WorkerInfo;
import org.apache.pulsar.common.policies.data.WorkerFunctionInstanceStats;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.shade.javax.ws.rs.ClientErrorException;
import org.apache.pulsar.shade.javax.ws.rs.client.InvocationCallback;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;
import org.apache.pulsar.shade.javax.ws.rs.core.GenericType;
import org.apache.pulsar.shade.javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerImpl
extends BaseResource
implements Worker {
    private static final Logger log = LoggerFactory.getLogger(WorkerImpl.class);
    private final WebTarget workerStats;
    private final WebTarget worker;

    public WorkerImpl(WebTarget web, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.worker = web.path("/admin/v2/worker");
        this.workerStats = web.path("/admin/v2/worker-stats");
    }

    public List<WorkerFunctionInstanceStats> getFunctionsStats() throws PulsarAdminException {
        try {
            return this.getFunctionsStatsAsync().get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<List<WorkerFunctionInstanceStats>> getFunctionsStatsAsync() {
        WebTarget path = this.workerStats.path("functionsmetrics");
        final CompletableFuture<List<WorkerFunctionInstanceStats>> future = new CompletableFuture<List<WorkerFunctionInstanceStats>>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            @Override
            public void completed(Response response) {
                if (!response.getStatusInfo().equals(Response.Status.OK)) {
                    future.completeExceptionally(new ClientErrorException(response));
                } else {
                    List<WorkerFunctionInstanceStats> metricsList = response.readEntity(new GenericType<List<WorkerFunctionInstanceStats>>(){});
                    future.complete(metricsList);
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(WorkerImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public Collection<Metrics> getMetrics() throws PulsarAdminException {
        try {
            return this.getMetricsAsync().get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Collection<Metrics>> getMetricsAsync() {
        WebTarget path = this.workerStats.path("metrics");
        final CompletableFuture<Collection<Metrics>> future = new CompletableFuture<Collection<Metrics>>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            @Override
            public void completed(Response response) {
                if (!response.getStatusInfo().equals(Response.Status.OK)) {
                    future.completeExceptionally(new ClientErrorException(response));
                } else {
                    future.complete((Collection)response.readEntity(new GenericType<List<Metrics>>(){}));
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(WorkerImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public List<WorkerInfo> getCluster() throws PulsarAdminException {
        try {
            return this.getClusterAsync().get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<List<WorkerInfo>> getClusterAsync() {
        WebTarget path = this.worker.path("cluster");
        final CompletableFuture<List<WorkerInfo>> future = new CompletableFuture<List<WorkerInfo>>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            @Override
            public void completed(Response response) {
                if (!response.getStatusInfo().equals(Response.Status.OK)) {
                    future.completeExceptionally(new ClientErrorException(response));
                } else {
                    future.complete(response.readEntity(new GenericType<List<WorkerInfo>>(){}));
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(WorkerImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public WorkerInfo getClusterLeader() throws PulsarAdminException {
        try {
            return this.getClusterLeaderAsync().get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<WorkerInfo> getClusterLeaderAsync() {
        WebTarget path = this.worker.path("cluster").path("leader");
        final CompletableFuture<WorkerInfo> future = new CompletableFuture<WorkerInfo>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            @Override
            public void completed(Response response) {
                if (!response.getStatusInfo().equals(Response.Status.OK)) {
                    future.completeExceptionally(new ClientErrorException(response));
                } else {
                    future.complete(response.readEntity(new GenericType<WorkerInfo>(){}));
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(WorkerImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public Map<String, Collection<String>> getAssignments() throws PulsarAdminException {
        try {
            return this.getAssignmentsAsync().get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Map<String, Collection<String>>> getAssignmentsAsync() {
        WebTarget path = this.worker.path("assignments");
        final CompletableFuture<Map<String, Collection<String>>> future = new CompletableFuture<Map<String, Collection<String>>>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            @Override
            public void completed(Response response) {
                if (!response.getStatusInfo().equals(Response.Status.OK)) {
                    future.completeExceptionally(new ClientErrorException(response));
                } else {
                    future.complete(response.readEntity(new GenericType<Map<String, Collection<String>>>(){}));
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(WorkerImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }
}

