/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.managers;

import com.pubnub.api.PNConfiguration;

public class BasePathManager {
    private PNConfiguration config;
    private int currentSubdomain;
    private static final int MAX_SUBDOMAIN = 20;
    private static final String DEFAULT_SUBDOMAIN = "ps";
    private static final String DEFAULT_BASE_PATH = "pndsn.com";

    public BasePathManager(PNConfiguration initialConfig) {
        this.config = initialConfig;
        this.currentSubdomain = 1;
    }

    public String getBasePath() {
        StringBuilder constructedUrl = new StringBuilder("http");
        if (this.config.isSecure()) {
            constructedUrl.append("s");
        }
        constructedUrl.append("://");
        if (this.config.getOrigin() != null) {
            constructedUrl.append(this.config.getOrigin());
        } else if (this.config.isCacheBusting()) {
            constructedUrl.append(DEFAULT_SUBDOMAIN).append(this.currentSubdomain).append(".").append(DEFAULT_BASE_PATH);
            this.currentSubdomain = this.currentSubdomain == 20 ? 1 : ++this.currentSubdomain;
        } else {
            constructedUrl.append(DEFAULT_SUBDOMAIN).append(".").append(DEFAULT_BASE_PATH);
        }
        return constructedUrl.toString();
    }
}

