/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.api.endpoints.presence;

import com.google.gson.JsonElement;
import com.pubnub.api.PubNub;
import com.pubnub.api.PubNubException;
import com.pubnub.api.PubNubUtil;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.endpoints.Endpoint;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.managers.MapperManager;
import com.pubnub.api.managers.RetrofitManager;
import com.pubnub.api.managers.TelemetryManager;
import com.pubnub.api.models.consumer.presence.PNHereNowChannelData;
import com.pubnub.api.models.consumer.presence.PNHereNowOccupantData;
import com.pubnub.api.models.consumer.presence.PNHereNowResult;
import com.pubnub.api.models.server.Envelope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Response;

public class HereNow
extends Endpoint<Envelope<JsonElement>, PNHereNowResult> {
    private List<String> channels = new ArrayList<String>();
    private List<String> channelGroups = new ArrayList<String>();
    private Boolean includeState;
    private Boolean includeUUIDs;

    public HereNow(PubNub pubnubInstance, TelemetryManager telemetryManager, RetrofitManager retrofit) {
        super(pubnubInstance, telemetryManager, retrofit);
    }

    @Override
    protected List<String> getAffectedChannels() {
        return this.channels;
    }

    @Override
    protected List<String> getAffectedChannelGroups() {
        return this.channelGroups;
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.getPubnub().getConfiguration().getSubscribeKey() == null || this.getPubnub().getConfiguration().getSubscribeKey().isEmpty()) {
            throw PubNubException.builder().pubnubError(PubNubErrorBuilder.PNERROBJ_SUBSCRIBE_KEY_MISSING).build();
        }
    }

    @Override
    protected Call<Envelope<JsonElement>> doWork(Map<String, String> params) {
        if (this.includeState == null) {
            this.includeState = false;
        }
        if (this.includeUUIDs == null) {
            this.includeUUIDs = true;
        }
        if (this.includeState.booleanValue()) {
            params.put("state", "1");
        }
        if (!this.includeUUIDs.booleanValue()) {
            params.put("disable_uuids", "1");
        }
        if (this.channelGroups.size() > 0) {
            params.put("channel-group", PubNubUtil.joinString(this.channelGroups, ","));
        }
        String channelCSV = this.channels.size() > 0 ? PubNubUtil.joinString(this.channels, ",") : ",";
        if (this.channels.size() > 0 || this.channelGroups.size() > 0) {
            return this.getRetrofit().getPresenceService().hereNow(this.getPubnub().getConfiguration().getSubscribeKey(), channelCSV, params);
        }
        return this.getRetrofit().getPresenceService().globalHereNow(this.getPubnub().getConfiguration().getSubscribeKey(), params);
    }

    @Override
    protected PNHereNowResult createResponse(Response<Envelope<JsonElement>> input) {
        PNHereNowResult herenowData = this.channels.isEmpty() && this.channelGroups.isEmpty() ? this.parseMultipleChannelResponse((JsonElement)((Envelope)input.body()).getPayload()) : (this.channels.size() > 1 || this.channelGroups.size() > 0 ? this.parseMultipleChannelResponse((JsonElement)((Envelope)input.body()).getPayload()) : this.parseSingleChannelResponse((Envelope)input.body()));
        return herenowData;
    }

    private PNHereNowResult parseSingleChannelResponse(Envelope<JsonElement> input) {
        PNHereNowResult hereNowData = PNHereNowResult.builder().totalChannels(1).channels(new HashMap<String, PNHereNowChannelData>()).totalOccupancy(input.getOccupancy()).build();
        PNHereNowChannelData.PNHereNowChannelDataBuilder hereNowChannelData = PNHereNowChannelData.builder().channelName(this.channels.get(0)).occupancy(input.getOccupancy());
        if (this.includeUUIDs.booleanValue()) {
            hereNowChannelData.occupants(this.prepareOccupantData(input.getUuids()));
            hereNowData.getChannels().put(this.channels.get(0), hereNowChannelData.build());
        }
        return hereNowData;
    }

    private PNHereNowResult parseMultipleChannelResponse(JsonElement input) {
        MapperManager mapper = this.getPubnub().getMapper();
        PNHereNowResult hereNowData = PNHereNowResult.builder().channels(new HashMap<String, PNHereNowChannelData>()).totalChannels(mapper.elementToInt(input, "total_channels")).totalOccupancy(mapper.elementToInt(input, "total_occupancy")).build();
        Iterator<Map.Entry<String, JsonElement>> it = mapper.getObjectIterator(input, "channels");
        while (it.hasNext()) {
            Map.Entry<String, JsonElement> entry = it.next();
            PNHereNowChannelData.PNHereNowChannelDataBuilder hereNowChannelData = PNHereNowChannelData.builder().channelName(entry.getKey()).occupancy(mapper.elementToInt(entry.getValue(), "occupancy"));
            if (this.includeUUIDs.booleanValue()) {
                hereNowChannelData.occupants(this.prepareOccupantData(mapper.getField(entry.getValue(), "uuids")));
            } else {
                hereNowChannelData.occupants(null);
            }
            hereNowData.getChannels().put(entry.getKey(), hereNowChannelData.build());
        }
        return hereNowData;
    }

    private List<PNHereNowOccupantData> prepareOccupantData(JsonElement input) {
        ArrayList<PNHereNowOccupantData> occupantsResults = new ArrayList<PNHereNowOccupantData>();
        MapperManager mapper = this.getPubnub().getMapper();
        if (this.includeState != null && this.includeState.booleanValue()) {
            Iterator<JsonElement> it = mapper.getArrayIterator(input);
            while (it.hasNext()) {
                JsonElement occupant = it.next();
                PNHereNowOccupantData.PNHereNowOccupantDataBuilder hereNowOccupantData = PNHereNowOccupantData.builder();
                hereNowOccupantData.uuid(mapper.elementToString(occupant, "uuid"));
                hereNowOccupantData.state(mapper.getField(occupant, "state"));
                occupantsResults.add(hereNowOccupantData.build());
            }
        } else {
            Iterator<JsonElement> it = mapper.getArrayIterator(input);
            while (it.hasNext()) {
                JsonElement occupant = it.next();
                PNHereNowOccupantData.PNHereNowOccupantDataBuilder hereNowOccupantData = PNHereNowOccupantData.builder();
                hereNowOccupantData.uuid(mapper.elementToString(occupant));
                hereNowOccupantData.state(null);
                occupantsResults.add(hereNowOccupantData.build());
            }
        }
        return occupantsResults;
    }

    @Override
    protected PNOperationType getOperationType() {
        return PNOperationType.PNHereNowOperation;
    }

    @Override
    protected boolean isAuthRequired() {
        return true;
    }

    public HereNow channels(List<String> channels) {
        this.channels = channels;
        return this;
    }

    public HereNow channelGroups(List<String> channelGroups) {
        this.channelGroups = channelGroups;
        return this;
    }

    public HereNow includeState(Boolean includeState) {
        this.includeState = includeState;
        return this;
    }

    public HereNow includeUUIDs(Boolean includeUUIDs) {
        this.includeUUIDs = includeUUIDs;
        return this;
    }
}

