/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.cloud;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.CamelContext;
import org.apache.camel.model.cloud.ServiceCallDefinition;
import org.apache.camel.model.cloud.ServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="routing,cloud,service-discovery")
@XmlRootElement(name="staticServiceDiscovery")
@XmlAccessorType(value=XmlAccessType.FIELD)
@Configurer(extended=true)
public class StaticServiceCallServiceDiscoveryConfiguration
extends ServiceCallServiceDiscoveryConfiguration {
    @XmlElement
    private List<String> servers;

    public StaticServiceCallServiceDiscoveryConfiguration() {
        this(null);
    }

    public StaticServiceCallServiceDiscoveryConfiguration(ServiceCallDefinition parent) {
        super(parent, "static-service-discovery");
    }

    public List<String> getServers() {
        return this.servers;
    }

    public void setServers(List<String> servers) {
        this.servers = servers;
    }

    public StaticServiceCallServiceDiscoveryConfiguration servers(List<String> servers) {
        this.setServers(servers);
        return this;
    }

    public StaticServiceCallServiceDiscoveryConfiguration servers(String servers) {
        if (ObjectHelper.isNotEmpty((String)servers)) {
            String[] parts = servers.split(",");
            if (this.servers == null) {
                this.servers = new ArrayList<String>();
            }
            this.servers.addAll(Arrays.asList(parts));
        }
        return this;
    }

    @Override
    protected void postProcessFactoryParameters(CamelContext camelContext, Map<String, Object> parameters) throws Exception {
        List servers = (List)List.class.cast(parameters.get("servers"));
        if (ObjectHelper.isNotEmpty((Collection)servers)) {
            ListIterator<String> it = servers.listIterator();
            while (it.hasNext()) {
                it.set(camelContext.resolvePropertyPlaceholders((String)it.next()));
            }
            parameters.put("servers", servers);
        }
    }
}

