/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.cloud;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.CamelContext;
import org.apache.camel.cloud.ServiceDiscovery;
import org.apache.camel.model.cloud.CachingServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.ConsulServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.DnsServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.KubernetesServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.ServiceCallDefinition;
import org.apache.camel.model.cloud.ServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.StaticServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;

@Metadata(label="routing,cloud,service-discovery")
@XmlRootElement(name="combinedServiceDiscovery")
@XmlAccessorType(value=XmlAccessType.FIELD)
@Configurer(extended=true)
public class CombinedServiceCallServiceDiscoveryConfiguration
extends ServiceCallServiceDiscoveryConfiguration {
    @XmlElements(value={@XmlElement(name="consulServiceDiscovery", type=ConsulServiceCallServiceDiscoveryConfiguration.class), @XmlElement(name="dnsServiceDiscovery", type=DnsServiceCallServiceDiscoveryConfiguration.class), @XmlElement(name="kubernetesServiceDiscovery", type=KubernetesServiceCallServiceDiscoveryConfiguration.class), @XmlElement(name="staticServiceDiscovery", type=StaticServiceCallServiceDiscoveryConfiguration.class), @XmlElement(name="cachingServiceDiscovery", type=CachingServiceCallServiceDiscoveryConfiguration.class)})
    private List<ServiceCallServiceDiscoveryConfiguration> serviceDiscoveryConfigurations;

    public CombinedServiceCallServiceDiscoveryConfiguration() {
        this(null);
    }

    public CombinedServiceCallServiceDiscoveryConfiguration(ServiceCallDefinition parent) {
        super(parent, "combined-service-discovery");
    }

    public List<ServiceCallServiceDiscoveryConfiguration> getServiceDiscoveryConfigurations() {
        return this.serviceDiscoveryConfigurations;
    }

    public void setServiceDiscoveryConfigurations(List<ServiceCallServiceDiscoveryConfiguration> serviceDiscoveryConfigurations) {
        this.serviceDiscoveryConfigurations = serviceDiscoveryConfigurations;
    }

    public void addServiceDiscoveryConfigurations(ServiceCallServiceDiscoveryConfiguration serviceDiscoveryConfiguration) {
        if (this.serviceDiscoveryConfigurations == null) {
            this.serviceDiscoveryConfigurations = new ArrayList<ServiceCallServiceDiscoveryConfiguration>();
        }
        this.serviceDiscoveryConfigurations.add(serviceDiscoveryConfiguration);
    }

    public CombinedServiceCallServiceDiscoveryConfiguration serviceDiscoveryConfigurations(List<ServiceCallServiceDiscoveryConfiguration> serviceDiscoveryConfigurations) {
        this.setServiceDiscoveryConfigurations(serviceDiscoveryConfigurations);
        return this;
    }

    public CombinedServiceCallServiceDiscoveryConfiguration serviceDiscoveryConfiguration(ServiceCallServiceDiscoveryConfiguration serviceDiscoveryConfiguration) {
        this.addServiceDiscoveryConfigurations(serviceDiscoveryConfiguration);
        return this;
    }

    public CachingServiceCallServiceDiscoveryConfiguration cachingServiceDiscovery() {
        CachingServiceCallServiceDiscoveryConfiguration conf = new CachingServiceCallServiceDiscoveryConfiguration();
        this.addServiceDiscoveryConfigurations(conf);
        return conf;
    }

    public ConsulServiceCallServiceDiscoveryConfiguration consulServiceDiscovery() {
        ConsulServiceCallServiceDiscoveryConfiguration conf = new ConsulServiceCallServiceDiscoveryConfiguration();
        this.addServiceDiscoveryConfigurations(conf);
        return conf;
    }

    public DnsServiceCallServiceDiscoveryConfiguration dnsServiceDiscovery() {
        DnsServiceCallServiceDiscoveryConfiguration conf = new DnsServiceCallServiceDiscoveryConfiguration();
        this.addServiceDiscoveryConfigurations(conf);
        return conf;
    }

    public KubernetesServiceCallServiceDiscoveryConfiguration kubernetesServiceDiscovery() {
        KubernetesServiceCallServiceDiscoveryConfiguration conf = new KubernetesServiceCallServiceDiscoveryConfiguration();
        this.addServiceDiscoveryConfigurations(conf);
        return conf;
    }

    public CombinedServiceCallServiceDiscoveryConfiguration combinedServiceDiscovery() {
        CombinedServiceCallServiceDiscoveryConfiguration conf = new CombinedServiceCallServiceDiscoveryConfiguration();
        this.addServiceDiscoveryConfigurations(conf);
        return conf;
    }

    public StaticServiceCallServiceDiscoveryConfiguration staticServiceDiscovery() {
        StaticServiceCallServiceDiscoveryConfiguration conf = new StaticServiceCallServiceDiscoveryConfiguration();
        this.addServiceDiscoveryConfigurations(conf);
        return conf;
    }

    @Override
    protected void postProcessFactoryParameters(CamelContext camelContext, Map<String, Object> parameters) throws Exception {
        if (this.serviceDiscoveryConfigurations != null && !this.serviceDiscoveryConfigurations.isEmpty()) {
            ArrayList<ServiceDiscovery> discoveries = new ArrayList<ServiceDiscovery>(this.serviceDiscoveryConfigurations.size());
            for (ServiceCallServiceDiscoveryConfiguration conf : this.serviceDiscoveryConfigurations) {
                discoveries.add(conf.newInstance(camelContext));
            }
            parameters.put("serviceDiscoveryList", discoveries);
        }
    }
}

