/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.api.data.Path;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.BaseBinaryDecoder;
import com.impossibl.postgres.system.procs.BaseBinaryEncoder;
import com.impossibl.postgres.system.procs.BaseTextDecoder;
import com.impossibl.postgres.system.procs.BaseTextEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.GeometryParsers;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.text.ParseException;

public class Paths
extends SimpleProcProvider {
    public Paths() {
        super((Type.Codec.Encoder<StringBuilder>)new TxtEncoder(), (Type.Codec.Decoder<CharSequence>)new TxtDecoder(), (Type.Codec.Encoder<ByteBuf>)new BinEncoder(), (Type.Codec.Decoder<ByteBuf>)new BinDecoder(), "path_");
    }

    static class TxtEncoder
    extends BaseTextEncoder {
        TxtEncoder() {
        }

        @Override
        protected void encodeValue(Context context, Type type, Object value, Object sourceContext, StringBuilder buffer) throws IOException {
            buffer.append(value.toString());
        }
    }

    static class TxtDecoder
    extends BaseTextDecoder {
        TxtDecoder() {
        }

        @Override
        public Class<?> getDefaultClass() {
            return Path.class;
        }

        @Override
        protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Class<?> targetClass, Object targetContext) throws IOException, ParseException {
            return GeometryParsers.INSTANCE.parsePath(buffer);
        }
    }

    static class BinEncoder
    extends BaseBinaryEncoder {
        BinEncoder() {
        }

        @Override
        protected void encodeValue(Context context, Type type, Object value, Object sourceContext, ByteBuf buffer) throws IOException {
            Path path = (Path)value;
            double[][] points = path.getPoints();
            buffer.writeByte(path.isClosed() ? 1 : 0);
            buffer.writeInt(points == null ? 0 : points.length);
            if (points != null) {
                for (double[] point : points) {
                    buffer.writeDouble(point[0]);
                    buffer.writeDouble(point[1]);
                }
            }
        }
    }

    static class BinDecoder
    extends BaseBinaryDecoder {
        BinDecoder() {
        }

        @Override
        public Class<?> getDefaultClass() {
            return Path.class;
        }

        @Override
        protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Class<?> targetClass, Object targetContext) throws IOException {
            boolean closed = buffer.readByte() != 0;
            int npts = buffer.readInt();
            if (npts <= 0 || npts >= Integer.MAX_VALUE) {
                throw new IOException("invalid number of points in external \"path\" value");
            }
            double[][] points = new double[npts][];
            for (int i = 0; i < npts; ++i) {
                double[] point = new double[]{buffer.readDouble(), buffer.readDouble()};
                points[i] = point;
            }
            return new Path(points, closed);
        }
    }
}

