/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.guava.Preconditions;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

abstract class BaseBinaryDecoder
implements Type.Codec.Decoder<ByteBuf> {
    private Integer requiredLength;
    private boolean respectMaxLength;

    protected BaseBinaryDecoder() {
        this(null);
    }

    protected BaseBinaryDecoder(Integer requiredLength) {
        this.requiredLength = requiredLength;
    }

    protected boolean shouldRespectMaxLength() {
        return this.respectMaxLength;
    }

    protected void enableRespectMaxLength() {
        this.respectMaxLength = true;
    }

    @Override
    public Object decode(Context context, Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Class<?> targetClass, Object targetContext) throws IOException {
        Class<?> clazz = targetClass = targetClass != null ? targetClass : this.getDefaultClass();
        if (this.requiredLength != null) {
            Preconditions.checkArgument(buffer.readableBytes() == this.requiredLength.intValue(), "invalid length");
        }
        return this.decodeValue(context, type, typeLength, typeModifier, buffer, targetClass, targetContext);
    }

    protected abstract Object decodeValue(Context var1, Type var2, Short var3, Integer var4, ByteBuf var5, Class<?> var6, Object var7) throws IOException;
}

