/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.ErrorUtils;
import com.impossibl.postgres.jdbc.Exceptions;
import com.impossibl.postgres.jdbc.JDBCTypeMapping;
import com.impossibl.postgres.jdbc.JDBCTypeMetaData;
import com.impossibl.postgres.jdbc.PGDirectConnection;
import com.impossibl.postgres.jdbc.PGMetaData;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.system.CustomTypes;
import com.impossibl.postgres.system.SystemSettings;
import com.impossibl.postgres.types.CompositeType;
import com.impossibl.postgres.types.Registry;
import com.impossibl.postgres.types.Type;
import java.io.IOException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class PGResultSetMetaData
extends PGMetaData
implements ResultSetMetaData {
    private ResultField[] resultFields;
    private Map<Integer, List<PGMetaData.ColumnData>> relationsColumnsData;
    private Map<String, Class<?>> typeMap;

    PGResultSetMetaData(PGDirectConnection connection, ResultField[] resultFields, Map<String, Class<?>> typeMap) {
        super(connection);
        this.resultFields = resultFields;
        this.relationsColumnsData = new HashMap<Integer, List<PGMetaData.ColumnData>>();
        this.typeMap = typeMap;
    }

    private PGMetaData.ColumnData getRelationColumnData(ResultField field) throws SQLException {
        List<PGMetaData.ColumnData> relationColumnsData = this.getRelationColumnsData(field.getRelationId());
        for (PGMetaData.ColumnData relationColumnData : relationColumnsData) {
            if (relationColumnData.relationAttributeNumber != field.getRelationAttributeNumber()) continue;
            return relationColumnData;
        }
        return null;
    }

    private List<PGMetaData.ColumnData> getRelationColumnsData(int relationId) throws SQLException {
        if (relationId == 0) {
            return Collections.emptyList();
        }
        List<PGMetaData.ColumnData> data = this.relationsColumnsData.get(relationId);
        if (data == null) {
            data = this.loadRelationColumsData(relationId);
            this.relationsColumnsData.put(relationId, data);
        }
        return data;
    }

    private List<PGMetaData.ColumnData> loadRelationColumsData(int relationId) throws SQLException {
        String sql = this.getColumnSQL(" AND c.oid = ?").toString();
        return this.getColumnData(sql, Collections.singletonList(relationId));
    }

    ResultField get(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.resultFields.length) {
            throw Exceptions.COLUMN_INDEX_OUT_OF_BOUNDS;
        }
        return this.resultFields[columnIndex - 1];
    }

    private CompositeType getRelType(int columnIndex) throws SQLException {
        ResultField field = this.get(columnIndex);
        if (field.getRelationId() == 0) {
            return null;
        }
        try {
            return this.connection.getRegistry().loadRelationType(field.getRelationId());
        }
        catch (IOException e) {
            throw ErrorUtils.makeSQLException(e);
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!iface.isAssignableFrom(this.getClass())) {
            throw Exceptions.UNWRAP_ERROR;
        }
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public int getColumnCount() {
        return this.resultFields.length;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        ResultField field = this.get(column);
        PGMetaData.ColumnData columnData = this.getRelationColumnData(field);
        if (columnData == null) {
            try {
                return this.connection.getRegistry().resolve(field.getTypeRef()).isAutoIncrement();
            }
            catch (IOException e) {
                throw ErrorUtils.makeSQLException(e);
            }
        }
        return Type.isAutoIncrement(columnData.defaultValue) || columnData.type.isAutoIncrement();
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        Registry registry = this.connection.getRegistry();
        try {
            return JDBCTypeMetaData.isCaseSensitive(registry.resolve(this.get(column).getTypeRef()));
        }
        catch (IOException e) {
            throw ErrorUtils.makeSQLException(e);
        }
    }

    @Override
    public boolean isSearchable(int column) {
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        try {
            return JDBCTypeMetaData.isCurrency(this.connection.getRegistry().resolve(this.get(column).getTypeRef()));
        }
        catch (IOException e) {
            throw ErrorUtils.makeSQLException(e);
        }
    }

    @Override
    public int isNullable(int column) throws SQLException {
        Boolean nullable;
        ResultField field = this.get(column);
        PGMetaData.ColumnData columnData = this.getRelationColumnData(field);
        if (columnData == null) {
            try {
                nullable = this.connection.getRegistry().resolve(field.getTypeRef()).isNullable();
            }
            catch (IOException e) {
                throw ErrorUtils.makeSQLException(e);
            }
        } else {
            Boolean bl = nullable = columnData.nullable != null ? columnData.nullable : columnData.type.isNullable();
        }
        return nullable != null ? (nullable.booleanValue() ? 1 : 0) : 2;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        try {
            return JDBCTypeMetaData.isSigned(this.connection.getRegistry().resolve(this.get(column).getTypeRef()));
        }
        catch (IOException e) {
            throw ErrorUtils.makeSQLException(e);
        }
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        String val = this.get(column).getName();
        if (val == null) {
            val = this.getColumnName(column);
        }
        return val;
    }

    @Override
    public String getCatalogName(int column) {
        return this.connection.getSetting(SystemSettings.DATABASE_NAME);
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        CompositeType relType = this.getRelType(column);
        if (relType == null) {
            return "";
        }
        return relType.getNamespace();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        CompositeType relType = this.getRelType(column);
        if (relType == null) {
            return "";
        }
        return relType.getName();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        String val;
        if (!this.connection.isStrictMode() && (val = this.get(column).getName()) != null) {
            return val;
        }
        ResultField field = this.get(column);
        PGMetaData.ColumnData columnData = this.getRelationColumnData(field);
        if (columnData == null) {
            return field.getName();
        }
        return columnData.columnName;
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        ResultField field = this.get(column);
        try {
            return JDBCTypeMapping.getJDBCTypeCode(this.connection.getRegistry().resolve(field.getTypeRef()));
        }
        catch (IOException e) {
            throw ErrorUtils.makeSQLException(e);
        }
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        ResultField field = this.get(column);
        PGMetaData.ColumnData columnData = this.getRelationColumnData(field);
        if (columnData == null) {
            try {
                return this.connection.getRegistry().resolve(field.getTypeRef()).getName();
            }
            catch (IOException e) {
                throw ErrorUtils.makeSQLException(e);
            }
        }
        return JDBCTypeMetaData.getTypeName(columnData.type, columnData.defaultValue);
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        Type type;
        try {
            type = this.connection.getRegistry().resolve(this.get(column).getTypeRef());
        }
        catch (IOException e) {
            throw ErrorUtils.makeSQLException(e);
        }
        return CustomTypes.lookupCustomType(type, this.typeMap, type.getCodec(type.getResultFormat()).getDecoder().getDefaultClass()).getName();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        ResultField field = this.get(column);
        try {
            return JDBCTypeMetaData.getPrecision(this.connection.getRegistry().resolve(field.getTypeRef()), field.getTypeLength(), field.getTypeModifier());
        }
        catch (IOException e) {
            throw ErrorUtils.makeSQLException(e);
        }
    }

    @Override
    public int getScale(int column) throws SQLException {
        ResultField field = this.get(column);
        try {
            return JDBCTypeMetaData.getScale(this.connection.getRegistry().resolve(field.getTypeRef()), field.getTypeModifier());
        }
        catch (IOException e) {
            throw ErrorUtils.makeSQLException(e);
        }
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        ResultField field = this.get(column);
        try {
            return JDBCTypeMetaData.getDisplaySize(this.connection.getRegistry().resolve(field.getTypeRef()), field.getTypeLength(), field.getTypeModifier());
        }
        catch (IOException e) {
            throw ErrorUtils.makeSQLException(e);
        }
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return this.get(column).getRelationAttributeNumber() == 0;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return !this.isReadOnly(column);
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return this.isWritable(column);
    }
}

