/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.ConnectionUtil;
import com.impossibl.postgres.jdbc.DataSourceSettings;
import com.impossibl.postgres.jdbc.JDBCSettings;
import com.impossibl.postgres.jdbc.PGDataSource;
import com.impossibl.postgres.jdbc.PGDirectConnection;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.ServerConnectionInfo;
import com.impossibl.postgres.system.Setting;
import com.impossibl.postgres.system.Settings;
import com.impossibl.postgres.system.SystemSettings;
import com.impossibl.postgres.types.SharedRegistry;
import com.impossibl.postgres.utils.StringTransforms;
import io.netty.channel.unix.DomainSocketAddress;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.CommonDataSource;

public abstract class AbstractDataSource
implements CommonDataSource {
    protected Settings settings = new Settings(DataSourceSettings.DS, JDBCSettings.JDBC, SystemSettings.SYS, SystemSettings.PROTO);
    private Map<ServerConnectionInfo, SharedRegistry> sharedRegistries = new ConcurrentHashMap<ServerConnectionInfo, SharedRegistry>();

    protected AbstractDataSource() {
    }

    protected PGDirectConnection createConnection(String username, String password) throws SQLException {
        Settings settings = this.settings.duplicateKnowingAll();
        settings.set(SystemSettings.CREDENTIALS_USERNAME, username);
        settings.set(SystemSettings.CREDENTIALS_PASSWORD, password);
        SharedRegistry.Factory sharedRegistryFactory = !settings.enabled(JDBCSettings.REGISTRY_SHARING) ? connInfo -> new SharedRegistry(connInfo.getServerInfo(), PGDataSource.class.getClassLoader()) : connInfo -> this.sharedRegistries.computeIfAbsent(connInfo, key -> new SharedRegistry(key.getServerInfo(), PGDataSource.class.getClassLoader()));
        String url = settings.get(SystemSettings.DATABASE_URL);
        if (url != null) {
            settings.unsetAll(DataSourceSettings.DS.getAllOwnedSettings());
            PGDirectConnection connection = ConnectionUtil.createConnection(url, settings.asProperties(), sharedRegistryFactory);
            if (connection == null) {
                throw new SQLException("Unsupported database URL");
            }
            return connection;
        }
        ConnectionUtil.ConnectionSpecifier connSpec = AbstractDataSource.buildConnectionSpecifier(settings);
        settings.set(SystemSettings.DATABASE_URL, connSpec.getURL());
        settings.unsetAll(DataSourceSettings.DS.getAllOwnedSettings());
        return ConnectionUtil.createConnection(connSpec.getAddresses(), settings, sharedRegistryFactory);
    }

    static ConnectionUtil.ConnectionSpecifier buildConnectionSpecifier(Settings settings) throws SQLException {
        ConnectionUtil.ConnectionSpecifier connSpec = new ConnectionUtil.ConnectionSpecifier();
        String serverAddressesSetting = settings.getStored(DataSourceSettings.SERVER_ADDRESSES);
        if (serverAddressesSetting != null) {
            String[] serverAddresses;
            for (String serverAddress : serverAddresses = serverAddressesSetting.split(",")) {
                connSpec.appendAddress(AbstractDataSource.parseServerAddress(serverAddress.trim()));
            }
        } else {
            if (settings.hasStoredValue(DataSourceSettings.LOCAL_SERVER_NAME)) {
                connSpec.appendAddress((SocketAddress)new DomainSocketAddress(settings.get(DataSourceSettings.LOCAL_SERVER_NAME)));
            }
            connSpec.appendAddress(new InetSocketAddress(settings.get(DataSourceSettings.SERVER_NAME), (int)settings.get(DataSourceSettings.PORT_NUMBER)));
        }
        connSpec.setDatabase(settings.get(DataSourceSettings.DATABASE_NAME));
        return connSpec;
    }

    static SocketAddress parseServerAddress(String address) throws SQLException {
        String host;
        if (address.contains("/")) {
            return new DomainSocketAddress(address);
        }
        if (address.startsWith("[")) {
            int closingBracketPos = address.indexOf(93);
            if (closingBracketPos == -1) {
                throw new SQLException("Invalid host name in server address list");
            }
            String host2 = address.substring(0, closingBracketPos + 1);
            int port = DataSourceSettings.PORT_NUMBER.getDefault();
            if (address.length() > closingBracketPos + 1) {
                int colonPos = closingBracketPos + 1;
                if (address.charAt(colonPos) != ':' || address.length() <= colonPos + 1) {
                    throw new SQLException("Invalid port in server address list");
                }
                try {
                    port = Integer.parseInt(address.substring(colonPos + 1));
                }
                catch (Exception e) {
                    throw new SQLException("Invalid port in server address list");
                }
            }
            if (host2.equals("[]")) {
                throw new SQLException("Invalid host in server address list");
            }
            return new InetSocketAddress(host2, port);
        }
        int port = DataSourceSettings.PORT_NUMBER.getDefault();
        int colonPos = address.lastIndexOf(58);
        if (colonPos != -1) {
            host = address.substring(0, colonPos);
            if (address.length() <= colonPos + 1) {
                throw new SQLException("Invalid port in server address list");
            }
            try {
                port = Integer.parseInt(address.substring(colonPos + 1));
            }
            catch (Exception e) {
                throw new SQLException("Invalid port in server address list");
            }
        } else {
            host = address;
        }
        if (host.isEmpty()) {
            throw new SQLException("Invalid host in server address list");
        }
        return new InetSocketAddress(host, port);
    }

    protected abstract Reference createReference();

    private void addRefAddrIfSet(Reference ref, Setting<?> setting) {
        if (!this.settings.hasStoredValue(setting)) {
            return;
        }
        ref.add(new StringRefAddr(StringTransforms.toLowerCamelCase(setting.getName()), this.settings.getText(setting)));
    }

    private void addRefAddrIfMissing(Reference ref, Setting<?> setting) {
        if (this.settings.hasStoredValue(setting)) {
            return;
        }
        ref.add(new StringRefAddr(StringTransforms.toLowerCamelCase(setting.getName()), this.settings.getText(setting)));
    }

    public Reference getReference() {
        Reference ref = this.createReference();
        for (Setting<?> setting : this.settings.knownSet()) {
            this.addRefAddrIfSet(ref, setting);
        }
        this.addRefAddrIfMissing(ref, DataSourceSettings.DATASOURCE_NAME);
        this.addRefAddrIfMissing(ref, DataSourceSettings.SERVER_NAME);
        this.addRefAddrIfMissing(ref, DataSourceSettings.PORT_NUMBER);
        this.addRefAddrIfMissing(ref, DataSourceSettings.DATABASE_NAME);
        return ref;
    }

    public void init(Reference reference) {
        for (Setting<?> setting : this.settings.knownSet()) {
            String value = AbstractDataSource.getReferenceValue(reference, StringTransforms.toLowerCamelCase(setting.getName()));
            if (value == null) continue;
            this.settings.setText(setting, value);
        }
    }

    private static String getReferenceValue(Reference reference, String key) {
        RefAddr refAddr = reference.get(key);
        if (refAddr == null) {
            return null;
        }
        return (String)refAddr.getContent();
    }

    public abstract String getDescription();

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.settings.get(DataSourceSettings.LOGIN_TIMEOUT);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.settings.set(DataSourceSettings.LOGIN_TIMEOUT, seconds);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return Logger.getLogger(Context.class.getPackage().getName());
    }

    public String getUrl() {
        return this.settings.get(SystemSettings.DATABASE_URL);
    }

    public void setUrl(String v) {
        this.settings.set(SystemSettings.DATABASE_URL, v);
    }

    public String getHost() {
        return this.settings.get(DataSourceSettings.SERVER_NAME);
    }

    public void setHost(String v) {
        this.settings.set(DataSourceSettings.SERVER_NAME, v);
    }

    public int getPort() {
        return this.settings.get(DataSourceSettings.PORT_NUMBER);
    }

    public void setPort(int v) {
        this.settings.set(DataSourceSettings.PORT_NUMBER, v);
    }

    public String getClientEncoding() {
        return this.settings.getText(SystemSettings.PROTOCOL_ENCODING);
    }

    public void setClientEncoding(String v) {
        this.settings.setText(SystemSettings.PROTOCOL_ENCODING, v);
    }
}

