/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.ClobReader;
import com.impossibl.postgres.jdbc.ClobWriter;
import com.impossibl.postgres.jdbc.Exceptions;
import com.impossibl.postgres.jdbc.LargeObject;
import com.impossibl.postgres.jdbc.PGDirectConnection;
import com.impossibl.postgres.utils.guava.CharStreams;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.List;

public class PGClob
implements Clob {
    static final Charset CHARSET = Charset.forName("UTF_32BE");
    static final int CHAR_SIZE = 4;
    LargeObject lo;
    List<LargeObject> streamLos;

    public PGClob(PGDirectConnection connection, int oid) throws SQLException {
        if (connection.getAutoCommit()) {
            throw new SQLException("Clobs require connection to be in manual-commit mode... setAutoCommit(false)");
        }
        this.lo = LargeObject.open(connection, oid);
        this.streamLos = new ArrayList<LargeObject>();
    }

    public int getOid() {
        return this.lo.oid;
    }

    private void checkClosed() throws SQLException {
        if (this.lo == null) {
            throw Exceptions.CLOSED_CLOB;
        }
    }

    private static void checkPosition(long pos) throws SQLException {
        if (pos < 1L) {
            throw Exceptions.ILLEGAL_ARGUMENT;
        }
    }

    @Override
    public long length() throws SQLException {
        this.checkClosed();
        long cur = this.lo.tell();
        this.lo.lseek(0L, 2);
        long len = this.lo.tell();
        this.lo.lseek(cur, 0);
        return len / 4L;
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        this.checkClosed();
        PGClob.checkPosition(pos);
        this.lo.lseek((pos - 1L) * 4L, 0);
        return new String(this.lo.read(length * 4), CHARSET);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.checkClosed();
        LargeObject streamLo = this.lo.dup();
        this.streamLos.add(streamLo);
        return new ClobReader(this, streamLo);
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        this.checkClosed();
        PGClob.checkPosition(pos);
        LargeObject streamLo = this.lo.dup();
        this.streamLos.add(streamLo);
        streamLo.lseek((pos - 1L) * 4L, 0);
        return CharStreams.limit(new ClobReader(this, streamLo), length * 4L);
    }

    @Override
    public long position(String pattern, long start) throws SQLException {
        this.checkClosed();
        PGClob.checkPosition(start);
        LOCharIterator iter = new LOCharIterator(start - 1L);
        long curPos = start;
        long matchStartPos = 0L;
        int patternIdx = 0;
        while (iter.hasNext()) {
            int ch = iter.next();
            if (ch == pattern.charAt(patternIdx)) {
                if (patternIdx == 0) {
                    matchStartPos = curPos;
                }
                if (++patternIdx == pattern.length()) {
                    return matchStartPos;
                }
            } else {
                patternIdx = 0;
            }
            ++curPos;
        }
        return -1L;
    }

    @Override
    public long position(Clob pattern, long start) throws SQLException {
        this.checkClosed();
        return this.position(pattern.getSubString(1L, (int)pattern.length()), start);
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        return this.setString(pos, str, 0, str.length());
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        this.checkClosed();
        PGClob.checkPosition(pos);
        this.lo.lseek((pos - 1L) * 4L, 0);
        return this.lo.write(str.substring(offset, offset + len).getBytes(CHARSET), 0, len * 4);
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        this.checkClosed();
        PGClob.checkPosition(pos);
        LargeObject streamLo = this.lo.dup();
        this.streamLos.add(streamLo);
        streamLo.lseek((pos - 1L) * 4L, 0);
        return new ClobWriter(this, streamLo);
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.checkClosed();
        this.lo.truncate(len * 4L);
    }

    @Override
    public void free() throws SQLException {
        if (this.lo == null) {
            return;
        }
        this.lo.close();
        this.lo = null;
        for (LargeObject streamLo : this.streamLos) {
            streamLo.close();
        }
        this.streamLos.clear();
    }

    void removeStream(LargeObject lo) {
        this.streamLos.remove(lo);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    private class LOCharIterator {
        private static final int MAX_BUFFER_CHARS = 1024;
        private static final int MAX_BUFFER_SIZE = 4096;
        private byte[] buffer = new byte[0];
        private int idx = 0;

        LOCharIterator(long start) throws SQLException {
            PGClob.this.lo.lseek(start * 4L, 0);
        }

        boolean hasNext() throws SQLException {
            boolean result;
            if (this.idx < this.buffer.length) {
                result = true;
            } else {
                this.buffer = PGClob.this.lo.read(4096L);
                this.idx = 0;
                result = this.buffer.length > 0;
            }
            return result;
        }

        private int next() {
            return (this.buffer[this.idx++] & 0xFF) << 24 | (this.buffer[this.idx++] & 0xFF) << 16 | (this.buffer[this.idx++] & 0xFF) << 8 | (this.buffer[this.idx++] & 0xFF) << 0;
        }
    }
}

