/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pgevent;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class PgEventEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":host:port/database/channel";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "pgevent".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "host", "localhost", false, copy);
        uri = this.buildPathParameter(syntax, uri, "port", "5432", false, copy);
        uri = this.buildPathParameter(syntax, uri, "database", null, true, copy);
        uri = this.buildPathParameter(syntax, uri, "channel", null, true, copy);
        uri = this.buildQueryParameters(uri, copy);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(13);
        props.add("basicPropertyBinding");
        props.add("pass");
        props.add("synchronous");
        props.add("channel");
        props.add("exchangePattern");
        props.add("database");
        props.add("lazyStartProducer");
        props.add("bridgeErrorHandler");
        props.add("port");
        props.add("datasource");
        props.add("host");
        props.add("exceptionHandler");
        props.add("user");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("pass");
        secretProps.add("user");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

