/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.jdbc.PGBlob;
import com.impossibl.postgres.jdbc.PGClob;
import com.impossibl.postgres.jdbc.PGDirectConnection;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.ConversionException;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.system.procs.UInt4s;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;

public class Oids
extends SimpleProcProvider {
    public Oids() {
        super((Type.Codec.Encoder<StringBuilder>)new TxtEncoder(), (Type.Codec.Decoder<CharSequence>)new TxtDecoder(), (Type.Codec.Encoder<ByteBuf>)new BinEncoder(), (Type.Codec.Decoder<ByteBuf>)new BinDecoder(), "oid");
    }

    static class TxtEncoder
    extends UInt4s.TxtEncoder {
        TxtEncoder() {
        }

        @Override
        protected Integer convertInput(Context context, Type type, Object source, Object sourceContext) throws ConversionException {
            if (source instanceof PGBlob) {
                return ((PGBlob)source).getOid();
            }
            if (source instanceof PGClob) {
                return ((PGClob)source).getOid();
            }
            return (Integer)super.convertInput(context, type, source, sourceContext);
        }
    }

    static class TxtDecoder
    extends UInt4s.TxtDecoder {
        TxtDecoder() {
        }

        @Override
        protected Object convertOutput(Context context, Integer decoded, Class<?> targetClass, Object targetContext) throws IOException {
            if (Blob.class.isAssignableFrom(targetClass)) {
                try {
                    return new PGBlob((PGDirectConnection)context.unwrap(), decoded);
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            }
            if (Clob.class.isAssignableFrom(targetClass)) {
                try {
                    return new PGClob((PGDirectConnection)context.unwrap(), decoded);
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            }
            return super.convertOutput(context, decoded, targetClass, targetContext);
        }
    }

    static class BinEncoder
    extends UInt4s.BinEncoder {
        BinEncoder() {
        }

        @Override
        protected Integer convertInput(Context context, Type type, Object source, Object sourceContext) throws ConversionException {
            if (source instanceof PGBlob) {
                return ((PGBlob)source).getOid();
            }
            if (source instanceof PGClob) {
                return ((PGClob)source).getOid();
            }
            return (Integer)super.convertInput(context, type, source, sourceContext);
        }
    }

    static class BinDecoder
    extends UInt4s.BinDecoder {
        BinDecoder() {
        }

        @Override
        protected Object convertOutput(Context context, Integer decoded, Class<?> targetClass, Object targetContext) throws IOException {
            if (Blob.class.isAssignableFrom(targetClass)) {
                try {
                    return new PGBlob((PGDirectConnection)context.unwrap(), decoded);
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            }
            if (Clob.class.isAssignableFrom(targetClass)) {
                try {
                    return new PGClob((PGDirectConnection)context.unwrap(), decoded);
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            }
            return super.convertOutput(context, decoded, targetClass, targetContext);
        }
    }
}

