/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.jdbc.PGArray;
import com.impossibl.postgres.jdbc.PGBuffersArray;
import com.impossibl.postgres.protocol.FieldFormat;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.ConversionException;
import com.impossibl.postgres.system.procs.BaseBinaryDecoder;
import com.impossibl.postgres.system.procs.BaseBinaryEncoder;
import com.impossibl.postgres.system.procs.BaseTextDecoder;
import com.impossibl.postgres.system.procs.BaseTextEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.types.ArrayType;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.ByteBufs;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import java.io.IOException;
import java.lang.reflect.Array;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

public class Arrays
extends SimpleProcProvider {
    public Arrays() {
        super((Type.Codec.Encoder<StringBuilder>)new TxtEncoder(), (Type.Codec.Decoder<CharSequence>)new TxtDecoder(), (Type.Codec.Encoder<ByteBuf>)new BinEncoder(), (Type.Codec.Decoder<ByteBuf>)new BinDecoder(), "array_", "anyarray_");
    }

    static Object convertOutput(PGArray array, Class<?> targetClass) throws IOException {
        if (targetClass == java.sql.Array.class) {
            return array;
        }
        if (targetClass.isArray()) {
            try {
                Object result = array.getArray(targetClass.getComponentType());
                array.free();
                return result;
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
        throw new ConversionException(array.getType(), targetClass);
    }

    private static int getDimensions(Class<?> type) {
        if (type.isArray()) {
            return 1 + Arrays.getDimensions(type.getComponentType());
        }
        return 0;
    }

    public static int strideOfDimensions(int[] dimensions) {
        return Arrays.strideOfDimensions(dimensions, 0);
    }

    public static int strideOfDimensions(int[] dimensions, int offset) {
        if (dimensions.length == 0) {
            return 0;
        }
        int stride = 1;
        for (int c = offset; c < dimensions.length; ++c) {
            stride *= dimensions[c];
        }
        return stride;
    }

    static class TxtEncoder
    extends BaseTextEncoder {
        TxtEncoder() {
        }

        @Override
        protected void encodeValue(Context context, Type type, Object value, Object sourceContext, StringBuilder buffer) throws IOException {
            Class<?> valueType = value.getClass();
            if (value instanceof PGArray) {
                try {
                    value = ((PGArray)value).getArray();
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            } else if (!valueType.isArray()) {
                throw new ConversionException(valueType, type);
            }
            ArrayType arrayType = (ArrayType)type;
            Type elementType = arrayType.getElementType();
            this.writeArray(context, elementType, elementType.getDelimeter(), value, sourceContext, buffer);
        }

        void writeArray(Context context, Type elementType, char delim, Object value, Object sourceContext, StringBuilder buffer) throws IOException {
            Type.Codec.Encoder<StringBuilder> encoder = elementType.getTextCodec().getEncoder();
            buffer.append('{');
            int len = Array.getLength(value);
            for (int c = 0; c < len; ++c) {
                Object elementValue = Array.get(value, c);
                StringBuilder elementBuffer = new StringBuilder();
                if (elementValue == null) {
                    buffer.append("NULL");
                } else if (elementValue.getClass().isArray() && elementValue.getClass() != byte[].class) {
                    this.writeArray(context, elementType, delim, elementValue, sourceContext, buffer);
                } else {
                    encoder.encode(context, elementType, elementValue, sourceContext, elementBuffer);
                    String elemStr = elementBuffer.toString();
                    if (TxtEncoder.needsQuotes(elemStr, delim)) {
                        elemStr = elemStr.replace("\\", "\\\\");
                        elemStr = elemStr.replace("\"", "\\\"");
                        buffer.append('\"').append(elemStr).append('\"');
                    } else {
                        buffer.append(elemStr);
                    }
                }
                if (c >= len - 1) continue;
                buffer.append(delim);
            }
            buffer.append('}');
        }

        private static boolean needsQuotes(String elemStr, char delim) {
            if (elemStr.isEmpty()) {
                return true;
            }
            if (elemStr.equalsIgnoreCase("NULL")) {
                return true;
            }
            for (int c = 0; c < elemStr.length(); ++c) {
                char ch = elemStr.charAt(c);
                if (ch != delim && ch != '\"' && ch != '\\' && ch != '{' && ch != '}' && ch != ' ' && ch != '\t' && ch != '\n' && ch != '\r' && ch != '\f') continue;
                return true;
            }
            return false;
        }
    }

    static class TxtDecoder
    extends BaseTextDecoder {
        TxtDecoder() {
        }

        @Override
        public Class<?> getDefaultClass() {
            return java.sql.Array.class;
        }

        @Override
        protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Class<?> targetClass, Object targetContext) throws IOException, ParseException {
            ByteBufAllocator byteBufAllocator = context.getAllocator();
            ArrayType atype = (ArrayType)type;
            ArrayList<CharSequence> elementBuffers = new ArrayList<CharSequence>();
            int[] dimensions = this.parseElementBuffers(atype.getDelimeter(), buffer, elementBuffers);
            ByteBuf[] elementBinaryBuffers = new ByteBuf[elementBuffers.size()];
            for (int elementIdx = 0; elementIdx < elementBuffers.size(); ++elementIdx) {
                CharSequence elementBuffer = (CharSequence)elementBuffers.get(elementIdx);
                if (elementBuffer == null) continue;
                elementBinaryBuffers[elementIdx] = ByteBufUtil.writeUtf8((ByteBufAllocator)byteBufAllocator, (CharSequence)elementBuffer);
            }
            return Arrays.convertOutput(new PGBuffersArray(context, atype, FieldFormat.Text, elementBinaryBuffers, dimensions), targetClass);
        }

        int[] parseElementBuffers(char delim, CharSequence buffer, List<CharSequence> elements) throws IOException {
            int[] dimensions = new int[]{};
            int len = buffer.length();
            StringBuilder elementText = null;
            int depth = -1;
            block6: for (int charIdx = 0; charIdx < len; ++charIdx) {
                char ch = buffer.charAt(charIdx);
                switch (ch) {
                    case '{': {
                        if (dimensions.length < ++depth + 1) {
                            dimensions = java.util.Arrays.copyOf(dimensions, depth + 1);
                        }
                        dimensions[depth] = 0;
                        continue block6;
                    }
                    case '}': {
                        if (elementText != null) {
                            int n = depth;
                            dimensions[n] = dimensions[n] + 1;
                            elementText = this.addTextElement(elementText, elements);
                        }
                        if (--depth < 0) break block6;
                        int n = depth;
                        dimensions[n] = dimensions[n] + 1;
                        continue block6;
                    }
                    case '\"': {
                        elementText = new StringBuilder();
                        charIdx = this.readString(buffer, charIdx, elementText);
                        continue block6;
                    }
                    case '[': {
                        if (depth == -1) {
                            while (ch != '=' && charIdx < len) {
                                ch = buffer.charAt(++charIdx);
                            }
                            continue block6;
                        }
                    }
                    default: {
                        if (Character.isWhitespace(ch)) {
                            charIdx = this.skipWhitespace(buffer, charIdx);
                            continue block6;
                        }
                        if (ch == delim) {
                            if (elementText == null) continue block6;
                            int n = depth;
                            dimensions[n] = dimensions[n] + 1;
                            elementText = this.addTextElement(elementText, elements);
                            continue block6;
                        }
                        if (elementText == null) {
                            elementText = new StringBuilder();
                        }
                        elementText.append(ch);
                    }
                }
            }
            return dimensions;
        }

        StringBuilder addTextElement(StringBuilder text, List<CharSequence> elements) {
            String textStr = text.toString();
            if (textStr.equalsIgnoreCase("NULL")) {
                elements.add(null);
            } else {
                elements.add(textStr);
            }
            return null;
        }

        int skipWhitespace(CharSequence data, int start) {
            int c;
            int len = data.length();
            for (c = start; c < len && Character.isWhitespace(data.charAt(c)); ++c) {
            }
            return c;
        }

        int readString(CharSequence data, int start, Appendable out) throws IOException {
            int charIdx;
            int len = data.length();
            block4: for (charIdx = start + 1; charIdx < len; ++charIdx) {
                char ch = data.charAt(charIdx);
                switch (ch) {
                    case '\"': {
                        if (charIdx >= data.length() - 1 || data.charAt(charIdx + 1) != '\"') break block4;
                        ++charIdx;
                        out.append('\"');
                        continue block4;
                    }
                    case '\\': {
                        if (++charIdx < data.length()) {
                            ch = data.charAt(charIdx);
                        }
                    }
                    default: {
                        out.append(ch);
                    }
                }
            }
            return charIdx;
        }
    }

    static class BinEncoder
    extends BaseBinaryEncoder {
        BinEncoder() {
        }

        @Override
        protected void encodeValue(Context context, Type type, Object value, Object sourceContext, ByteBuf buffer) throws IOException {
            Class<?> valueType = value.getClass();
            if (value instanceof PGArray) {
                try {
                    value = ((PGArray)value).getArray();
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            } else if (!valueType.isArray()) {
                throw new ConversionException(valueType, type);
            }
            ArrayType atype = (ArrayType)type;
            Type elementType = atype.getElementType();
            int dimensionCount = Arrays.getDimensions(value.getClass());
            buffer.writeInt(dimensionCount);
            buffer.writeInt(this.hasNulls(value) ? 1 : 0);
            buffer.writeInt(elementType.getId());
            Object array = value;
            for (int d = 0; d < dimensionCount; ++d) {
                int dimension = array != null ? Array.getLength(array) : 0;
                buffer.writeInt(dimension);
                buffer.writeInt(1);
                array = dimension == 0 ? null : Array.get(array, 0);
            }
            this.writeArray(context, elementType, value, buffer);
        }

        void writeArray(Context context, Type type, Object val, ByteBuf buffer) throws IOException {
            if (val.getClass().getComponentType().isArray()) {
                this.writeSubArray(context, type, val, buffer);
            } else {
                this.writeElements(context, type, val, buffer);
            }
        }

        void writeElements(Context context, Type type, Object val, ByteBuf buffer) throws IOException {
            int len = Array.getLength(val);
            for (int c = 0; c < len; ++c) {
                Object element = Array.get(val, c);
                ByteBufs.lengthEncodeBinary(type.getBinaryCodec().getEncoder(), context, type, element, null, buffer);
            }
        }

        void writeSubArray(Context context, Type type, Object val, ByteBuf buffer) throws IOException {
            int len = Array.getLength(val);
            for (int c = 0; c < len; ++c) {
                this.writeArray(context, type, Array.get(val, c), buffer);
            }
        }

        boolean hasNulls(Object value) {
            int sz = Array.getLength(value);
            for (int c = 0; c < sz; ++c) {
                if (Array.get(value, c) != null) continue;
                return true;
            }
            return false;
        }
    }

    static class BinDecoder
    extends BaseBinaryDecoder {
        BinDecoder() {
        }

        @Override
        public Class<?> getDefaultClass() {
            return java.sql.Array.class;
        }

        @Override
        protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Class<?> targetClass, Object targetContext) throws IOException {
            ArrayType atype = (ArrayType)type;
            int dimensionCount = buffer.readInt();
            buffer.readInt();
            Type elementType = context.getRegistry().loadType(buffer.readInt());
            if (!atype.getElementType().equals(elementType)) {
                throw new IllegalStateException("Array element type mismatch");
            }
            int[] dimensions = new int[dimensionCount];
            for (int d = 0; d < dimensionCount; ++d) {
                dimensions[d] = buffer.readInt();
                buffer.readInt();
            }
            int totalItems = Arrays.strideOfDimensions(dimensions);
            ByteBuf[] elementBufs = new ByteBuf[totalItems];
            for (int elementIdx = 0; elementIdx < totalItems; ++elementIdx) {
                int elementLength = buffer.readInt();
                elementBufs[elementIdx] = elementLength != -1 ? buffer.readRetainedSlice(elementLength) : null;
            }
            return Arrays.convertOutput(new PGBuffersArray(context, atype, FieldFormat.Binary, elementBufs, dimensions), targetClass);
        }
    }
}

