/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system;

import com.impossibl.postgres.utils.guava.Preconditions;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Setting<T> {
    private static final String SYSTEM_PROPERTY_PREFIX = "pgjdbc.";
    private Group group;
    private String[] names;
    private Class<? extends T> type;
    private T staticDefaultValue;
    private Supplier<String> dynamicDefaultSupplier;
    private Converter<T> fromString;
    private Function<T, String> toString;
    private String description;
    private static final Pattern SIMPLE_NAME_PATTERN = Pattern.compile("(?:[a-z][a-z0-9\\-]+)(?:\\.[a-z0-9][a-z0-9\\-]+)*");

    public static <U> Setting<U> declare() {
        return new Setting(null);
    }

    private Setting(Supplier<String> dynamicDefaultSupplier) {
        this.dynamicDefaultSupplier = dynamicDefaultSupplier;
    }

    public Setting(Group group, String description, Class<T> type, T defaultValue, Converter<T> fromString, Function<T, String> toString, String[] names) {
        this.staticDefaultValue = defaultValue;
        this.init(group, description, type, fromString, toString, names);
    }

    public Setting(Group group, String description, Class<T> type, Supplier<String> dynamicDefaultSupplier, Converter<T> fromString, Function<T, String> toString, String[] names) {
        this.dynamicDefaultSupplier = dynamicDefaultSupplier;
        this.init(group, description, type, fromString, toString, names);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Group group, String description, Class<T> type, Converter<T> fromString, Function<T, String> toString, String[] names) {
        Preconditions.checkArgument(type != null, "Setting already initialized.");
        if (names.length < 1) {
            throw new IllegalArgumentException("names must not be empty");
        }
        this.group = group;
        this.names = names;
        this.type = type;
        this.fromString = fromString;
        this.toString = toString;
        this.description = description;
        Class<Setting> clazz = Setting.class;
        synchronized (Setting.class) {
            if (group.global && !Setting.isSimpleNameFormat(names[0])) {
                throw new IllegalArgumentException("Duplicate setting name found '" + names[0] + "'. Settings in global groups must be unique across all groups.");
            }
            Setting.addAll(group.allNamed, this);
            group.all.add(this);
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return;
        }
    }

    public void init(String groupId, String description, Class<T> type, String defaultValue, Converter<T> fromString, Function<T, String> toString, String[] names) {
        Group group = (Group)Group.ALL.get(groupId);
        if (group == null) {
            throw new IllegalArgumentException("Unknown group: " + groupId);
        }
        this.init(group, description, type, fromString, toString, names);
        this.staticDefaultValue = defaultValue != null ? this.fromString(defaultValue) : null;
    }

    public void init(String groupId, String description, Class<T> type, Supplier<String> defaultValue, Converter<T> fromString, Function<T, String> toString, String[] names) {
        Group group = (Group)Group.ALL.get(groupId);
        if (group == null) {
            throw new IllegalArgumentException("Unknown group: " + groupId);
        }
        this.init(group, description, type, fromString, toString, names);
        this.dynamicDefaultSupplier = defaultValue;
    }

    private static boolean isSimpleNameFormat(String name) {
        return SIMPLE_NAME_PATTERN.matcher(name).matches();
    }

    private static void addAll(Map<String, Setting<?>> settings, Setting<?> instance) {
        for (String name : instance.names) {
            if (settings.containsKey(name)) {
                throw new IllegalStateException("Setting with name '" + name + "' already exists");
            }
            settings.put(name, instance);
        }
    }

    public Group getGroup() {
        return this.group;
    }

    public String getName() {
        return this.names[0];
    }

    public String[] getNames() {
        return this.names;
    }

    public Class<? extends T> getType() {
        return this.type;
    }

    public boolean isDefaultDynamic() {
        return this.dynamicDefaultSupplier != null;
    }

    public T getDefault() {
        if (this.isDefaultDynamic()) {
            String value = this.dynamicDefaultSupplier.get();
            if (value == null) {
                return null;
            }
            return this.fromString(value);
        }
        return this.staticDefaultValue;
    }

    public String getDefaultText() {
        if (this.isDefaultDynamic()) {
            return this.dynamicDefaultSupplier.get();
        }
        if (this.staticDefaultValue != null) {
            return this.toString(this.staticDefaultValue);
        }
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public T fromString(String value) {
        try {
            return this.fromString.convert(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to parse setting \"" + this.getName() + "\" from '" + value + "'");
        }
    }

    public String toString(T value) {
        return this.toString.apply(value);
    }

    public T getSystem() {
        for (String name : this.names) {
            String value = System.getProperty(SYSTEM_PROPERTY_PREFIX + name);
            if (value == null) continue;
            return this.fromString(value);
        }
        return this.getDefault();
    }

    public T get(Properties properties) {
        for (String name : this.names) {
            String value = properties.getProperty(name);
            if (value == null) continue;
            return this.fromString(value);
        }
        return this.getDefault();
    }

    public String getText(Properties properties) {
        for (String name : this.names) {
            String value = properties.getProperty(name);
            if (value == null) continue;
            return value;
        }
        return this.getDefaultText();
    }

    public String toString() {
        String defaultValue = this.getDefaultText();
        return this.group + ": " + Arrays.toString(this.names) + " (" + this.type + ") = " + (defaultValue != null ? defaultValue : "null") + " : " + this.description;
    }

    public static interface Converter<U> {
        public U convert(String var1) throws Exception;

        public static Converter<String> identity() {
            return t -> t;
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface Description {
        public String value();
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface Info {
        public static final String NO_DEFAULT = "$$$NULL$$$";

        public String name();

        public String group();

        public String desc();

        public String def() default "$$$NULL$$$";

        public String defDynamic() default "$$$NULL$$$";

        public String defStatic() default "$$$NULL$$$";

        public int min() default -2147483648;

        public int max() default 0x7FFFFFFF;

        public String[] alternateNames() default {};
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface Factory {
    }

    public static class Group {
        private static final Map<String, Group> ALL = new LinkedHashMap<String, Group>();
        private String name;
        private String description;
        private boolean global;
        private Map<String, Setting<?>> allNamed = new LinkedHashMap();
        private Set<Setting<?>> all = new LinkedHashSet();

        public static Group declare() {
            return new Group(null, null);
        }

        public static Map<String, Group> getAll() {
            return Collections.unmodifiableMap(ALL);
        }

        public Group(String name, String description) {
            this(name, description, true);
        }

        public Group(String name, String description, boolean global) {
            this.init(name, description, global);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void init(String name, String description, boolean global) {
            this.name = name;
            this.description = description;
            this.global = global;
            Class<Group> clazz = Group.class;
            synchronized (Group.class) {
                ALL.putIfAbsent(name, this);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> Setting<T> add(Setting<T> setting) {
            Class<Setting> clazz = Setting.class;
            synchronized (Setting.class) {
                Setting.addAll(this.allNamed, (Setting)setting);
                this.all.add(setting);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return setting;
            }
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public Map<String, Setting<?>> getAllNamedSettings() {
            return Collections.unmodifiableMap(this.allNamed);
        }

        public Set<Setting<?>> getAllOwnedSettings() {
            return Collections.unmodifiableSet(this.all).stream().filter(setting -> ((Setting)setting).group == this).collect(Collectors.toSet());
        }

        public Set<Setting<?>> getAllSettings() {
            return Collections.unmodifiableSet(this.all);
        }

        public String toString() {
            return this.name;
        }

        @Target(value={ElementType.FIELD})
        @Retention(value=RetentionPolicy.CLASS)
        public static @interface Info {
            public String id();

            public String desc();

            public boolean global() default true;

            public int order() default 0x7FFFFFFF;
        }
    }
}

