/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.v30;

import com.impossibl.postgres.protocol.CopyFormat;
import com.impossibl.postgres.protocol.FieldFormat;
import com.impossibl.postgres.protocol.Notice;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.protocol.TransactionStatus;
import com.impossibl.postgres.protocol.TypeOid;
import com.impossibl.postgres.protocol.TypeRef;
import com.impossibl.postgres.protocol.v30.ProtocolChannel;
import com.impossibl.postgres.protocol.v30.ProtocolHandler;
import com.impossibl.postgres.protocol.v30.ProtocolHandlers;
import com.impossibl.postgres.protocol.v30.ServerRequest;
import com.impossibl.postgres.utils.ByteBufs;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundInvoker;
import io.netty.channel.ChannelPromise;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;

public class MessageDispatchHandler
extends ChannelDuplexHandler {
    private TransactionStatus transactionStatus;
    private Deque<ProtocolHandler> protocolHandlers = new ConcurrentLinkedDeque<ProtocolHandler>();
    private ProtocolHandler defaultHandler;
    private Charset charset;
    private Writer traceWriter;
    private boolean requiresFlush = false;
    private static final byte NEGOTIATE_PROTOCOL_VERSION_ID = 66;
    private static final byte AUTHENTICATION_MSG_ID = 82;
    private static final byte BACKEND_KEY_MSG_ID = 75;
    private static final byte PARAMETER_STATUS_MSG_ID = 83;
    private static final byte ERROR_MSG_ID = 69;
    private static final byte NOTICE_MSG_ID = 78;
    private static final byte NOTIFICATION_MSG_ID = 65;
    private static final byte READY_FOR_QUERY_MSG_ID = 90;
    private static final byte COMMAND_COMPLETE_MSG_ID = 67;
    private static final byte PARAMETER_DESC_MSG_ID = 116;
    private static final byte ROW_DESC_MSG_ID = 84;
    private static final byte ROW_DATA_MSG_ID = 68;
    private static final byte PORTAL_SUSPENDED_MSG_ID = 115;
    private static final byte NO_DATA_MSG_ID = 110;
    private static final byte EMPTY_QUERY_MSG_ID = 73;
    private static final byte PARSE_COMPLETE_MSG_ID = 49;
    private static final byte BIND_COMPLETE_MSG_ID = 50;
    private static final byte CLOSE_COMPLETE_MSG_ID = 51;
    private static final byte FUNCTION_RESULT_MSG_ID = 86;
    private static final byte COPY_IN_RESPONSE_MSG_ID = 71;
    private static final byte COPY_OUT_RESPONSE_MSG_ID = 72;
    private static final byte COPY_BOTH_RESPONSE_MSG_ID = 87;
    private static final byte COPY_DATA_MSG_ID = 100;
    private static final byte COPY_DONE_MSG_ID = 99;
    private static final byte COPY_FAIL_MSG_ID = 102;

    MessageDispatchHandler(Charset charset, Writer traceWriter) {
        this.charset = charset;
        this.traceWriter = traceWriter;
    }

    void setDefaultHandler(ProtocolHandler defaultHandler) {
        this.defaultHandler = defaultHandler;
    }

    TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws IOException {
        if (msg instanceof ServerRequest) {
            ServerRequest request = (ServerRequest)msg;
            ProtocolHandler requestProtocolHandler = request.createHandler();
            if (requestProtocolHandler != null) {
                this.protocolHandlers.offer(requestProtocolHandler);
            }
            request.execute(new ProtocolChannel(ctx.channel(), (ChannelOutboundInvoker)ctx, this.charset));
            promise.setSuccess();
        } else if (msg instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)msg;
            this.trace('<', (char)buf.getByte(0));
            ctx.write(msg, promise);
            this.requiresFlush = true;
        }
    }

    public void flush(ChannelHandlerContext ctx) throws Exception {
        this.trace("\n");
        this.flushTrace();
        if (this.requiresFlush) {
            super.flush(ctx);
            this.requiresFlush = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object message) throws IOException {
        ByteBuf msg = (ByteBuf)message;
        try {
            byte id = msg.readByte();
            int length = msg.readInt() - 4;
            ByteBuf data = msg.readSlice(length);
            this.trace('>', (char)id);
            ProtocolHandler protocolHandler = this.protocolHandlers.peek();
            this.dispatch(ctx, id, data, protocolHandler);
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        this.trace("\n");
        this.flushTrace();
        super.channelReadComplete(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.exceptionCaught(ctx, new ClosedChannelException());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ProtocolHandler handler = this.protocolHandlers.poll();
        ProtocolHandler protocolHandler = handler = handler != null ? handler : this.defaultHandler;
        if (handler == null) {
            return;
        }
        try {
            handler.exception(ctx.channel(), cause);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch(ChannelHandlerContext ctx, byte id, ByteBuf data, ProtocolHandler protocolHandler) throws IOException {
        Enum action = null;
        if (protocolHandler != null) {
            try {
                action = this.parseAndDispatch(ctx, id, data, protocolHandler);
            }
            catch (IOException e) {
                try {
                    protocolHandler.exception(e);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Enum enum_ = action = MessageDispatchHandler.isReadyForQuery(id) ? ProtocolHandler.Action.Complete : ProtocolHandler.Action.Sync;
            }
        }
        if (action == null) {
            if (this.defaultHandler != null && (action = this.parseAndDispatch(ctx, id, data.resetReaderIndex(), this.defaultHandler)) != ProtocolHandler.Action.Resume) {
                String handlerName = protocolHandler != null ? protocolHandler.getClass().getName() : "<No Handler>";
                String failMessage = "Unhandled message: " + (char)id + " @ " + handlerName;
                throw new IllegalStateException(failMessage);
            }
            return;
        }
        switch (1.$SwitchMap$com$impossibl$postgres$protocol$v30$ProtocolHandler$Action[action.ordinal()]) {
            case 1: {
                this.trace(".");
                break;
            }
            case 2: {
                this.trace(".^");
                ProtocolHandler resume = this.protocolHandlers.pop();
                try {
                    this.dispatch(ctx, id, data.resetReaderIndex(), this.protocolHandlers.peek());
                    break;
                }
                finally {
                    this.protocolHandlers.addFirst(resume);
                }
            }
            case 3: {
                this.trace("*");
                this.protocolHandlers.pop();
                break;
            }
            case 4: {
                this.trace("*^");
                this.protocolHandlers.pop();
                this.dispatch(ctx, id, data.resetReaderIndex(), this.protocolHandlers.peek());
                break;
            }
            case 5: {
                this.trace("$");
                this.protocolHandlers.pop();
                this.protocolHandlers.addFirst(ProtocolHandlers.SYNC);
            }
        }
    }

    private static boolean isReadyForQuery(byte id) {
        return id == 90;
    }

    private ProtocolHandler.Action parseAndDispatch(ChannelHandlerContext ctx, byte id, ByteBuf data, ProtocolHandler handler) throws IOException {
        switch (id) {
            case 65: {
                if (!(handler instanceof ProtocolHandler.Notification)) {
                    return null;
                }
                return this.receiveNotification(data, (ProtocolHandler.Notification)((Object)handler));
            }
            case 78: {
                if (!(handler instanceof ProtocolHandler.ReportNotice)) {
                    return null;
                }
                return this.receiveNotice(data, (ProtocolHandler.ReportNotice)handler);
            }
            case 66: {
                if (!(handler instanceof ProtocolHandler.NegotiateProtocolVersion)) {
                    return null;
                }
                return this.receiveNegotiation(data, (ProtocolHandler.NegotiateProtocolVersion)handler);
            }
            case 82: {
                if (!(handler instanceof ProtocolHandler.Authentication)) {
                    return null;
                }
                return this.receiveAuthentication(ctx, data, (ProtocolHandler.Authentication)handler);
            }
            case 75: {
                if (!(handler instanceof ProtocolHandler.BackendKeyData)) {
                    return null;
                }
                return this.receiveBackendKeyData(data, (ProtocolHandler.BackendKeyData)handler);
            }
            case 83: {
                if (!(handler instanceof ProtocolHandler.ParameterStatus)) {
                    return null;
                }
                return this.receiveParameterStatus(data, (ProtocolHandler.ParameterStatus)handler);
            }
            case 116: {
                if (!(handler instanceof ProtocolHandler.ParameterDescriptions)) {
                    return null;
                }
                return this.receiveParameterDescriptions(data, (ProtocolHandler.ParameterDescriptions)handler);
            }
            case 84: {
                if (!(handler instanceof ProtocolHandler.RowDescription)) {
                    return null;
                }
                return this.receiveRowDescription(data, (ProtocolHandler.RowDescription)handler);
            }
            case 68: {
                if (!(handler instanceof ProtocolHandler.DataRow)) {
                    return null;
                }
                return this.receiveRowData(data, (ProtocolHandler.DataRow)handler);
            }
            case 115: {
                if (!(handler instanceof ProtocolHandler.PortalSuspended)) {
                    return null;
                }
                return this.receivePortalSuspended((ProtocolHandler.PortalSuspended)handler);
            }
            case 110: {
                if (!(handler instanceof ProtocolHandler.NoData)) {
                    return null;
                }
                return this.receiveNoData((ProtocolHandler.NoData)handler);
            }
            case 49: {
                if (!(handler instanceof ProtocolHandler.ParseComplete)) {
                    return null;
                }
                return this.receiveParseComplete((ProtocolHandler.ParseComplete)handler);
            }
            case 50: {
                if (!(handler instanceof ProtocolHandler.BindComplete)) {
                    return null;
                }
                return this.receiveBindComplete((ProtocolHandler.BindComplete)handler);
            }
            case 51: {
                if (!(handler instanceof ProtocolHandler.CloseComplete)) {
                    return null;
                }
                return this.receiveCloseComplete((ProtocolHandler.CloseComplete)handler);
            }
            case 73: {
                if (!(handler instanceof ProtocolHandler.EmptyQuery)) {
                    return null;
                }
                return this.receiveEmptyQuery((ProtocolHandler.EmptyQuery)handler);
            }
            case 86: {
                if (!(handler instanceof ProtocolHandler.FunctionResult)) {
                    return null;
                }
                return this.receiveFunctionResult(data, (ProtocolHandler.FunctionResult)handler);
            }
            case 69: {
                if (!(handler instanceof ProtocolHandler.CommandError)) {
                    return null;
                }
                return this.receiveError(data, (ProtocolHandler.CommandError)handler);
            }
            case 67: {
                if (!(handler instanceof ProtocolHandler.CommandComplete)) {
                    return null;
                }
                return this.receiveCommandComplete(data, (ProtocolHandler.CommandComplete)handler);
            }
            case 90: {
                if (!(handler instanceof ProtocolHandler.ReadyForQuery)) {
                    return null;
                }
                return this.receiveReadyForQuery(data, (ProtocolHandler.ReadyForQuery)handler);
            }
            case 71: {
                if (!(handler instanceof ProtocolHandler.CopyInResponse)) {
                    return null;
                }
                return this.receiveCopyInResponse(ctx, data, (ProtocolHandler.CopyInResponse)handler);
            }
            case 72: {
                if (!(handler instanceof ProtocolHandler.CopyOutResponse)) {
                    return null;
                }
                return this.receiveCopyOutResponse(data, (ProtocolHandler.CopyOutResponse)handler);
            }
            case 87: {
                if (!(handler instanceof ProtocolHandler.CopyBothResponse)) {
                    return null;
                }
                return this.receiveCopyBothResponse(data, (ProtocolHandler.CopyBothResponse)handler);
            }
            case 100: {
                if (!(handler instanceof ProtocolHandler.CopyData)) {
                    return null;
                }
                return this.receiveCopyData(data, (ProtocolHandler.CopyData)handler);
            }
            case 99: {
                if (!(handler instanceof ProtocolHandler.CopyDone)) {
                    return null;
                }
                return this.receiveCopyDone(data, (ProtocolHandler.CopyDone)handler);
            }
            case 102: {
                if (!(handler instanceof ProtocolHandler.CopyFail)) {
                    return null;
                }
                return this.receiveCopyFail(data, (ProtocolHandler.CopyFail)handler);
            }
        }
        throw new IOException("unsupported message type: " + (id & 0xFF));
    }

    private ProtocolHandler.Action receiveNotification(ByteBuf buffer, ProtocolHandler.Notification notificationHandler) throws IOException {
        int processId = buffer.readInt();
        String channelName = ByteBufs.readCString(buffer, this.charset);
        String payload = ByteBufs.readCString(buffer, this.charset);
        notificationHandler.notification(processId, channelName, payload);
        return ProtocolHandler.Action.Resume;
    }

    private ProtocolHandler.Action receiveNegotiation(ByteBuf buffer, ProtocolHandler.NegotiateProtocolVersion handler) throws IOException {
        int minorProtocol = buffer.readInt();
        int unsupportedParameterCount = buffer.readInt();
        String[] unsupportedParameters = new String[unsupportedParameterCount];
        for (int c = 0; c < unsupportedParameterCount; ++c) {
            unsupportedParameters[c] = ByteBufs.readCString(buffer, this.charset);
        }
        return handler.negotiate(minorProtocol, Arrays.asList(unsupportedParameters));
    }

    private ProtocolHandler.Action receiveAuthentication(ChannelHandlerContext ctx, ByteBuf buffer, ProtocolHandler.Authentication handler) throws IOException {
        ProtocolChannel protocolChannel = new ProtocolChannel(ctx.channel(), (ChannelOutboundInvoker)ctx, this.charset);
        int code = buffer.readInt();
        switch (code) {
            case 0: {
                return handler.authenticated();
            }
            case 2: {
                handler.authenticateKerberos(protocolChannel);
                return ProtocolHandler.Action.Resume;
            }
            case 3: {
                handler.authenticateClear(protocolChannel);
                return ProtocolHandler.Action.Resume;
            }
            case 5: {
                byte[] salt = new byte[4];
                buffer.readBytes(salt);
                handler.authenticateMD5(salt, protocolChannel);
                return ProtocolHandler.Action.Resume;
            }
            case 6: {
                handler.authenticateSCM(protocolChannel);
                return ProtocolHandler.Action.Resume;
            }
            case 7: {
                handler.authenticateGSS(buffer, protocolChannel);
                return ProtocolHandler.Action.Resume;
            }
            case 8: {
                handler.authenticateContinue(buffer, protocolChannel);
                return ProtocolHandler.Action.Resume;
            }
            case 9: {
                handler.authenticateSSPI(buffer, protocolChannel);
                return ProtocolHandler.Action.Resume;
            }
        }
        throw new IOException("invalid authentication type");
    }

    private ProtocolHandler.Action receiveBackendKeyData(ByteBuf buffer, ProtocolHandler.BackendKeyData handler) throws IOException {
        int processId = buffer.readInt();
        int secretKey = buffer.readInt();
        return handler.backendKeyData(processId, secretKey);
    }

    private ProtocolHandler.Action receiveParameterStatus(ByteBuf buffer, ProtocolHandler.ParameterStatus handler) throws IOException {
        String name = ByteBufs.readCString(buffer, this.charset);
        String value = ByteBufs.readCString(buffer, this.charset);
        if ("client_encoding".equals(name)) {
            this.charset = Charset.forName(value);
        }
        return handler.parameterStatus(name, value);
    }

    private ProtocolHandler.Action receiveError(ByteBuf buffer, ProtocolHandler.CommandError handler) throws IOException {
        Notice notice = this.parseNotice(buffer, this.charset);
        return handler.error(notice);
    }

    private ProtocolHandler.Action receiveNotice(ByteBuf buffer, ProtocolHandler.ReportNotice handler) throws IOException {
        Notice notice = this.parseNotice(buffer, this.charset);
        return handler.notice(notice);
    }

    private ProtocolHandler.Action receiveParameterDescriptions(ByteBuf buffer, ProtocolHandler.ParameterDescriptions handler) throws IOException {
        int paramCount = buffer.readUnsignedShort();
        TypeRef[] paramTypes = new TypeRef[paramCount];
        for (int c = 0; c < paramCount; ++c) {
            paramTypes[c] = TypeOid.valueOf(buffer.readInt());
        }
        return handler.parameterDescriptions(paramTypes);
    }

    private ProtocolHandler.Action receiveRowDescription(ByteBuf buffer, ProtocolHandler.RowDescription handler) throws IOException {
        int fieldCount = buffer.readUnsignedShort();
        ResultField[] fields = new ResultField[fieldCount];
        for (int c = 0; c < fieldCount; ++c) {
            ResultField field;
            fields[c] = field = new ResultField(ByteBufs.readCString(buffer, this.charset), buffer.readInt(), (short)buffer.readUnsignedShort(), TypeOid.valueOf(buffer.readInt()), buffer.readShort(), buffer.readInt(), FieldFormat.values()[buffer.readUnsignedShort()]);
        }
        return handler.rowDescription(fields);
    }

    private ProtocolHandler.Action receiveRowData(ByteBuf buffer, ProtocolHandler.DataRow handler) throws IOException {
        return handler.rowData(buffer);
    }

    private ProtocolHandler.Action receivePortalSuspended(ProtocolHandler.PortalSuspended handler) throws IOException {
        return handler.portalSuspended();
    }

    private ProtocolHandler.Action receiveNoData(ProtocolHandler.NoData handler) throws IOException {
        return handler.noData();
    }

    private ProtocolHandler.Action receiveCloseComplete(ProtocolHandler.CloseComplete handler) throws IOException {
        return handler.closeComplete();
    }

    private ProtocolHandler.Action receiveBindComplete(ProtocolHandler.BindComplete handler) throws IOException {
        return handler.bindComplete();
    }

    private ProtocolHandler.Action receiveParseComplete(ProtocolHandler.ParseComplete handler) throws IOException {
        return handler.parseComplete();
    }

    private ProtocolHandler.Action receiveEmptyQuery(ProtocolHandler.EmptyQuery handler) throws IOException {
        return handler.emptyQuery();
    }

    private ProtocolHandler.Action receiveFunctionResult(ByteBuf buffer, ProtocolHandler.FunctionResult handler) throws IOException {
        return handler.functionResult(buffer);
    }

    private ProtocolHandler.Action receiveCopyInResponse(ChannelHandlerContext ctx, ByteBuf buffer, ProtocolHandler.CopyInResponse handler) throws IOException {
        CopyFormat copyFormat = buffer.readByte() == 0 ? CopyFormat.Text : CopyFormat.Binary;
        FieldFormat[] fieldFormats = new FieldFormat[buffer.readUnsignedShort()];
        for (int fieldFormatIdx = 0; fieldFormatIdx < fieldFormats.length; ++fieldFormatIdx) {
            fieldFormats[fieldFormatIdx] = buffer.readUnsignedShort() == 0 ? FieldFormat.Text : FieldFormat.Binary;
        }
        InputStream stream = handler.copyIn(copyFormat, fieldFormats);
        if (stream == null) {
            throw new IOException("No InputStream for Copy-In");
        }
        new ProtocolChannel(ctx.channel(), this.charset).writeCopyData(stream).flush();
        return ProtocolHandler.Action.Resume;
    }

    private ProtocolHandler.Action receiveCopyOutResponse(ByteBuf buffer, ProtocolHandler.CopyOutResponse handler) throws IOException {
        CopyFormat copyFormat = buffer.readByte() == 0 ? CopyFormat.Text : CopyFormat.Binary;
        FieldFormat[] fieldFormats = new FieldFormat[buffer.readUnsignedShort()];
        for (int fieldFormatIdx = 0; fieldFormatIdx < fieldFormats.length; ++fieldFormatIdx) {
            fieldFormats[fieldFormatIdx] = buffer.readUnsignedShort() == 0 ? FieldFormat.Text : FieldFormat.Binary;
        }
        ProtocolHandler subProtocolHandler = handler.copyOut(copyFormat, fieldFormats);
        if (subProtocolHandler == null) {
            throw new IOException("Copy-Out Not Handled");
        }
        this.protocolHandlers.offerFirst(subProtocolHandler);
        return ProtocolHandler.Action.Resume;
    }

    private ProtocolHandler.Action receiveCopyBothResponse(ByteBuf buffer, ProtocolHandler.CopyBothResponse handler) throws IOException {
        CopyFormat copyFormat = buffer.readByte() == 0 ? CopyFormat.Text : CopyFormat.Binary;
        FieldFormat[] fieldFormats = new FieldFormat[buffer.readUnsignedShort()];
        for (int fieldFormatIdx = 0; fieldFormatIdx < fieldFormats.length; ++fieldFormatIdx) {
            fieldFormats[fieldFormatIdx] = buffer.readUnsignedShort() == 0 ? FieldFormat.Text : FieldFormat.Binary;
        }
        ProtocolHandler subProtocolHandler = handler.copyBoth(copyFormat, fieldFormats);
        if (subProtocolHandler == null) {
            throw new IOException("Copy-Both Not Handled");
        }
        this.protocolHandlers.offer(subProtocolHandler);
        return ProtocolHandler.Action.Resume;
    }

    private ProtocolHandler.Action receiveCopyData(ByteBuf data, ProtocolHandler.CopyData handler) throws IOException {
        handler.copyData(data);
        return ProtocolHandler.Action.Resume;
    }

    private ProtocolHandler.Action receiveCopyDone(ByteBuf data, ProtocolHandler.CopyDone handler) throws IOException {
        handler.copyDone();
        return ProtocolHandler.Action.Complete;
    }

    private ProtocolHandler.Action receiveCopyFail(ByteBuf data, ProtocolHandler.CopyFail handler) throws IOException {
        String message = data.readCharSequence(data.readableBytes(), this.charset).toString();
        handler.copyFail(message);
        return ProtocolHandler.Action.Complete;
    }

    private ProtocolHandler.Action receiveCommandComplete(ByteBuf buffer, ProtocolHandler.CommandComplete handler) throws IOException {
        String command;
        String commandTag = ByteBufs.readCString(buffer, this.charset);
        Long rowsAffected = null;
        Long insertedOid = null;
        try {
            int lastSpace = commandTag.lastIndexOf(32);
            if (lastSpace != -1 && Character.isDigit(commandTag.charAt(lastSpace + 1))) {
                rowsAffected = Long.valueOf(commandTag.substring(lastSpace + 1));
                if (Character.isDigit(commandTag.charAt(lastSpace - 1))) {
                    int nextToLastSpace = commandTag.lastIndexOf(32, lastSpace - 1);
                    insertedOid = Long.valueOf(commandTag.substring(nextToLastSpace + 1, lastSpace));
                    command = commandTag.substring(0, nextToLastSpace);
                } else {
                    command = commandTag.substring(0, lastSpace);
                }
            } else {
                command = commandTag;
            }
        }
        catch (NumberFormatException | StringIndexOutOfBoundsException e) {
            throw new IOException("Unrecognized command tag: " + commandTag);
        }
        return handler.commandComplete(command, rowsAffected, insertedOid);
    }

    private ProtocolHandler.Action receiveReadyForQuery(ByteBuf buffer, ProtocolHandler.ReadyForQuery handler) throws IOException {
        TransactionStatus previousTransactionStatus = this.transactionStatus;
        switch (buffer.readByte()) {
            case 84: {
                this.transactionStatus = TransactionStatus.Active;
                this.trace("[");
                break;
            }
            case 69: {
                this.transactionStatus = TransactionStatus.Failed;
                this.trace("!");
                break;
            }
            case 73: {
                this.transactionStatus = TransactionStatus.Idle;
                if (previousTransactionStatus == TransactionStatus.Idle) break;
                this.trace("]");
                break;
            }
            default: {
                throw new IllegalStateException("invalid transaction status");
            }
        }
        return handler.readyForQuery(this.transactionStatus);
    }

    private Notice parseNotice(ByteBuf buffer, Charset charset) {
        byte msgId;
        Notice notice = new Notice();
        block17: while ((msgId = buffer.readByte()) != 0) {
            switch (msgId) {
                case 83: {
                    notice.setSeverity(ByteBufs.readCString(buffer, charset));
                    continue block17;
                }
                case 67: {
                    notice.setCode(ByteBufs.readCString(buffer, charset));
                    continue block17;
                }
                case 77: {
                    notice.setMessage(ByteBufs.readCString(buffer, charset));
                    continue block17;
                }
                case 68: {
                    notice.setDetail(ByteBufs.readCString(buffer, charset));
                    continue block17;
                }
                case 72: {
                    notice.setHint(ByteBufs.readCString(buffer, charset));
                    continue block17;
                }
                case 80: {
                    notice.setPosition(ByteBufs.readCString(buffer, charset));
                    continue block17;
                }
                case 87: {
                    notice.setWhere(ByteBufs.readCString(buffer, charset));
                    continue block17;
                }
                case 70: {
                    notice.setFile(ByteBufs.readCString(buffer, charset));
                    continue block17;
                }
                case 76: {
                    notice.setLine(ByteBufs.readCString(buffer, charset));
                    continue block17;
                }
                case 82: {
                    notice.setRoutine(ByteBufs.readCString(buffer, charset));
                    continue block17;
                }
                case 115: {
                    notice.setSchema(ByteBufs.readCString(buffer, charset));
                    continue block17;
                }
                case 116: {
                    notice.setTable(ByteBufs.readCString(buffer, charset));
                    continue block17;
                }
                case 99: {
                    notice.setColumn(ByteBufs.readCString(buffer, charset));
                    continue block17;
                }
                case 100: {
                    notice.setDatatype(ByteBufs.readCString(buffer, charset));
                    continue block17;
                }
                case 110: {
                    notice.setConstraint(ByteBufs.readCString(buffer, charset));
                    continue block17;
                }
            }
            ByteBufs.readCString(buffer, charset);
        }
        return notice;
    }

    private void flushTrace() {
        if (this.traceWriter == null) {
            return;
        }
        try {
            this.traceWriter.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void trace(char dir, char id) {
        if (this.traceWriter == null) {
            return;
        }
        try {
            this.traceWriter.append(dir);
            this.traceWriter.append(id);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void trace(CharSequence code) {
        if (this.traceWriter == null) {
            return;
        }
        try {
            this.traceWriter.append(code);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

