/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.PGDirectConnection;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PGSQLXML
implements SQLXML {
    private PGDirectConnection connection;
    private byte[] data;
    private int dataLen;
    private boolean initialized;

    public PGSQLXML(PGDirectConnection conn) {
        this(conn, null, false);
    }

    public PGSQLXML(PGDirectConnection conn, byte[] data) {
        this(conn, data, true);
    }

    private PGSQLXML(PGDirectConnection connection, byte[] data, boolean initialized) {
        this.connection = connection;
        this.data = data;
        this.dataLen = data != null ? data.length : -1;
        this.initialized = initialized;
    }

    public boolean isNull() {
        return this.data == null;
    }

    public byte[] getData() {
        if (this.data == null) {
            return null;
        }
        return Arrays.copyOf(this.data, this.dataLen);
    }

    private void checkFreed() throws SQLException {
        if (this.connection == null) {
            throw new SQLException("SQLXML object has already been freed");
        }
    }

    private void checkReadable() throws SQLException {
        if (!this.initialized) {
            throw new SQLException("SQLXML object has not been initialized");
        }
    }

    private void checkWritable() throws SQLException {
        if (this.initialized) {
            throw new SQLException("SQLXML object has already been initialized");
        }
    }

    @Override
    public void free() {
        this.connection = null;
        this.data = null;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.checkFreed();
        this.checkReadable();
        if (this.data == null) {
            return null;
        }
        return new ByteArrayInputStream(this.data, 0, this.dataLen);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.checkFreed();
        this.checkReadable();
        if (this.data == null) {
            return null;
        }
        return new InputStreamReader((InputStream)new ByteArrayInputStream(this.data, 0, this.dataLen), this.connection.getCharset());
    }

    @Override
    public <T extends Source> T getSource(Class<T> sourceClass) throws SQLException {
        this.checkFreed();
        this.checkReadable();
        if (this.data == null) {
            return null;
        }
        try {
            if (sourceClass == null || DOMSource.class.equals(sourceClass)) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                builder.setErrorHandler(new ErrorHandler(){

                    @Override
                    public void warning(SAXParseException exception) throws SAXException {
                    }

                    @Override
                    public void error(SAXParseException exception) throws SAXException {
                    }

                    @Override
                    public void fatalError(SAXParseException exception) throws SAXException {
                    }
                });
                InputSource input = new InputSource(this.getCharacterStream());
                return (T)((Source)sourceClass.cast(new DOMSource(builder.parse(input))));
            }
            if (SAXSource.class.equals(sourceClass)) {
                InputSource is = new InputSource(this.getCharacterStream());
                return (T)((Source)sourceClass.cast(new SAXSource(is)));
            }
            if (StreamSource.class.equals(sourceClass)) {
                return (T)((Source)sourceClass.cast(new StreamSource(this.getCharacterStream())));
            }
            if (StAXSource.class.equals(sourceClass)) {
                XMLInputFactory xif = XMLInputFactory.newInstance();
                XMLStreamReader xsr = xif.createXMLStreamReader(this.getCharacterStream());
                return (T)((Source)sourceClass.cast(new StAXSource(xsr)));
            }
        }
        catch (IOException | ParserConfigurationException | XMLStreamException | SAXException e) {
            throw new SQLException("Error initializing XML source");
        }
        throw new SQLException("Unsupported XML Source class" + sourceClass.getName());
    }

    @Override
    public String getString() throws SQLException {
        this.checkFreed();
        this.checkReadable();
        if (this.data == null) {
            return null;
        }
        return new String(this.data, 0, this.dataLen, this.connection.getCharset());
    }

    @Override
    public OutputStream setBinaryStream() throws SQLException {
        this.checkFreed();
        this.checkWritable();
        return new OutputStream();
    }

    @Override
    public Writer setCharacterStream() throws SQLException {
        this.checkFreed();
        this.checkWritable();
        return new OutputStreamWriter((java.io.OutputStream)new OutputStream(), this.connection.getCharset());
    }

    @Override
    public <T extends Result> T setResult(Class<T> resultClassIn) throws SQLException {
        this.checkFreed();
        this.checkWritable();
        Class resultClass = DOMResult.class;
        if (resultClassIn != null) {
            resultClass = resultClassIn;
        }
        if (DOMResult.class.equals(resultClass)) {
            return (T)((Result)resultClass.cast(new InternalDOMResult()));
        }
        if (SAXResult.class.equals(resultClass)) {
            try {
                SAXTransformerFactory transformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
                TransformerHandler transformerHandler = transformerFactory.newTransformerHandler();
                Writer writer = this.setCharacterStream();
                transformerHandler.setResult(new StreamResult(writer));
                return (T)((Result)resultClass.cast(new SAXResult(transformerHandler)));
            }
            catch (TransformerException te) {
                throw new SQLException("Error initializing SAXResult");
            }
        }
        if (StreamResult.class.equals((Object)resultClass)) {
            Writer writer = this.setCharacterStream();
            return (T)((Result)resultClass.cast(new StreamResult(writer)));
        }
        if (StAXResult.class.equals((Object)resultClass)) {
            Writer writer = this.setCharacterStream();
            try {
                XMLOutputFactory xof = XMLOutputFactory.newInstance();
                XMLStreamWriter xsw = xof.createXMLStreamWriter(writer);
                return (T)((Result)resultClass.cast(new StAXResult(xsw)));
            }
            catch (XMLStreamException xse) {
                throw new SQLException("Error initializing StAXResult");
            }
        }
        throw new SQLException("Unsupported XML Result class" + resultClass.getName());
    }

    @Override
    public void setString(String value) throws SQLException {
        this.checkFreed();
        this.checkWritable();
        this.initialized = true;
        if (value != null) {
            this.data = value.getBytes(this.connection.getCharset());
            this.dataLen = this.data.length;
        } else {
            this.data = null;
            this.dataLen = -1;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.data);
        result = 31 * result + this.dataLen;
        result = 31 * result + (this.initialized ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PGSQLXML other = (PGSQLXML)obj;
        if (!Arrays.equals(this.data, other.data)) {
            return false;
        }
        if (this.dataLen != other.dataLen) {
            return false;
        }
        return this.initialized == other.initialized;
    }

    static /* synthetic */ byte[] access$002(PGSQLXML x0, byte[] x1) {
        x0.data = x1;
        return x1;
    }

    class InternalDOMResult
    extends DOMResult {
        InternalDOMResult() {
        }

        @Override
        public void setNode(Node node) {
            super.setNode(node);
            try {
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer transformer = factory.newTransformer();
                DOMSource domSource = new DOMSource(node);
                OutputStreamWriter writer = new OutputStreamWriter((java.io.OutputStream)new OutputStream(), PGSQLXML.this.connection.getCharset());
                StreamResult streamResult = new StreamResult(writer);
                transformer.transform(domSource, streamResult);
            }
            catch (TransformerException | TransformerFactoryConfigurationError e) {
                PGSQLXML.access$002(PGSQLXML.this, null);
                PGSQLXML.this.initialized = true;
            }
        }
    }

    class OutputStream
    extends ByteArrayOutputStream {
        OutputStream() {
        }

        @Override
        public void flush() throws IOException {
            PGSQLXML.access$002(PGSQLXML.this, this.buf);
            PGSQLXML.this.dataLen = this.count;
            PGSQLXML.this.initialized = true;
        }
    }
}

