/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.utils;

import com.impossibl.postgres.utils.guava.Strings;
import java.util.Locale;

public class Locales {
    public static Locale parseLocale(String localeValue) {
        Locale locale;
        localeValue = localeValue.split("\\.", 2)[0];
        switch (localeValue.toUpperCase(Locale.ROOT)) {
            case "C": 
            case "POSIX": {
                return Locale.ROOT;
            }
        }
        String[] tokens = Locales.tokenizeLocaleSource(localeValue);
        if (tokens.length == 1) {
            Locales.validateLocalePart(localeValue);
            Locale resolved = Locale.forLanguageTag(localeValue);
            if (resolved.getLanguage().length() > 0) {
                return resolved;
            }
        }
        if ((locale = Locales.parseLocaleTokens(localeValue, tokens)) == null) {
            String language = tokens.length > 0 ? tokens[0] : "";
            String country = tokens.length > 1 ? tokens[1] : "";
            for (Locale availLocale : Locale.getAvailableLocales()) {
                if (!availLocale.getDisplayLanguage(Locale.ENGLISH).equals(language) || !availLocale.getDisplayCountry(Locale.ENGLISH).equals(country)) continue;
                locale = availLocale;
                break;
            }
        }
        return locale;
    }

    private static String[] tokenizeLocaleSource(String localeSource) {
        return localeSource.split("_");
    }

    private static Locale parseLocaleTokens(String localeString, String[] tokens) {
        int endIndexOfCountryCode;
        String language = tokens.length > 0 ? tokens[0] : "";
        String country = tokens.length > 1 ? tokens[1] : "";
        Locales.validateLocalePart(language);
        Locales.validateLocalePart(country);
        String variant = "";
        if (tokens.length > 2 && (variant = Locales.trimLeadingWhitespace(localeString.substring(endIndexOfCountryCode = localeString.indexOf(country, language.length()) + country.length()))).startsWith("_")) {
            variant = Locales.trimLeadingCharacter(variant, '_');
        }
        if (variant.isEmpty() && country.startsWith("#")) {
            variant = country;
            country = "";
        }
        if (!Locales.isISOLanguage(language) || !Locales.isISOCountry(country)) {
            return null;
        }
        return language.length() > 0 ? new Locale(language, country, variant) : null;
    }

    private static boolean isISOCountry(String code) {
        if (code.length() > 2) {
            return false;
        }
        code = code.toUpperCase();
        for (String isoCode : Locale.getISOCountries()) {
            if (!code.equals(isoCode)) continue;
            return true;
        }
        return false;
    }

    private static boolean isISOLanguage(String code) {
        if (code.length() > 2) {
            return false;
        }
        code = code.toLowerCase();
        for (String isoCode : Locale.getISOLanguages()) {
            if (!code.equals(isoCode)) continue;
            return true;
        }
        return false;
    }

    private static void validateLocalePart(String localePart) {
        for (int i = 0; i < localePart.length(); ++i) {
            char ch = localePart.charAt(i);
            if (ch == ' ' || ch == '_' || ch == '-' || ch == '#' || Character.isLetterOrDigit(ch)) continue;
            throw new IllegalArgumentException("Locale part \"" + localePart + "\" contains invalid characters");
        }
    }

    private static String trimLeadingWhitespace(String str) {
        if (Strings.isNullOrEmpty(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(0))) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    private static String trimLeadingCharacter(String str, char leadingCharacter) {
        if (Strings.isNullOrEmpty(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && sb.charAt(0) == leadingCharacter) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }
}

