/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.api.data.Path;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.ConversionException;
import com.impossibl.postgres.system.procs.BaseBinaryDecoder;
import com.impossibl.postgres.system.procs.BaseBinaryEncoder;
import com.impossibl.postgres.system.procs.BaseTextDecoder;
import com.impossibl.postgres.system.procs.BaseTextEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.GeometryParsers;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.text.ParseException;

public class Polygons
extends SimpleProcProvider {
    public Polygons() {
        super((Type.Codec.Encoder<StringBuilder>)new TxtEncoder(), (Type.Codec.Decoder<CharSequence>)new TxtDecoder(), (Type.Codec.Encoder<ByteBuf>)new BinEncoder(), (Type.Codec.Decoder<ByteBuf>)new BinDecoder(), "poly_");
    }

    private static double[][] convertInput(Type type, Object value) throws ConversionException {
        if (value instanceof double[][]) {
            return (double[][])value;
        }
        if (value instanceof Path) {
            return ((Path)value).getPoints();
        }
        throw new ConversionException(value.getClass(), type);
    }

    private static Object convertOutput(Type type, double[][] value, Class<?> targetClass) throws ConversionException {
        if (targetClass == double[][].class) {
            return value;
        }
        if (targetClass == Path.class) {
            return new Path(value, true);
        }
        throw new ConversionException(type, targetClass);
    }

    static class TxtEncoder
    extends BaseTextEncoder {
        TxtEncoder() {
        }

        @Override
        protected void encodeValue(Context context, Type type, Object value, Object sourceContext, StringBuilder buffer) throws IOException {
            buffer.append(new Path((double[][])value, true));
        }
    }

    static class TxtDecoder
    extends BaseTextDecoder {
        TxtDecoder() {
        }

        @Override
        public Class<?> getDefaultClass() {
            return double[][].class;
        }

        @Override
        protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Class<?> targetClass, Object targetContext) throws IOException, ParseException {
            return GeometryParsers.INSTANCE.parsePolygon(buffer);
        }
    }

    static class BinEncoder
    extends BaseBinaryEncoder {
        BinEncoder() {
        }

        @Override
        protected void encodeValue(Context context, Type type, Object value, Object sourceContext, ByteBuf buffer) throws IOException {
            double[][] points = Polygons.convertInput(type, value);
            buffer.writeInt(points.length);
            for (double[] point : points) {
                buffer.writeDouble(point[0]);
                buffer.writeDouble(point[1]);
            }
        }
    }

    static class BinDecoder
    extends BaseBinaryDecoder {
        BinDecoder() {
        }

        @Override
        public Class<?> getDefaultClass() {
            return double[][].class;
        }

        @Override
        protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Class<?> targetClass, Object targetContext) throws IOException {
            int npts = buffer.readInt();
            if (npts <= 0 || npts >= Integer.MAX_VALUE) {
                throw new IOException("invalid number of points in external \"polygon\" value");
            }
            double[][] points = new double[npts][];
            for (int i = 0; i < npts; ++i) {
                double[] point = new double[]{buffer.readDouble(), buffer.readDouble()};
                points[i] = point;
            }
            return Polygons.convertOutput(type, points, targetClass);
        }
    }
}

