/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.api.data.ACLItem;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.ConversionException;
import com.impossibl.postgres.system.procs.AutoConvertingTextDecoder;
import com.impossibl.postgres.system.procs.AutoConvertingTextEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.types.Type;
import java.io.IOException;
import java.text.ParseException;

public class ACLItems
extends SimpleProcProvider {
    public ACLItems() {
        super((Type.Codec.Encoder<StringBuilder>)new TxtEncoder(), (Type.Codec.Decoder<CharSequence>)new TxtDecoder(), null, null, "aclitem");
    }

    static class TxtEncoder
    extends AutoConvertingTextEncoder<ACLItem> {
        private static ACLItem parse(String value) throws ConversionException {
            try {
                ACLItem item = ACLItem.parse(value);
                if (item == null) {
                    throw new ConversionException("Invalid ACLItem");
                }
                return item;
            }
            catch (ParseException e) {
                throw new ConversionException(e);
            }
        }

        TxtEncoder() {
            super(TxtEncoder::parse);
        }

        @Override
        protected Class<ACLItem> getDefaultClass() {
            return ACLItem.class;
        }

        @Override
        protected void encodeNativeValue(Context context, Type type, ACLItem value, Object sourceContext, StringBuilder buffer) throws IOException {
            buffer.append(value.toString());
        }
    }

    static class TxtDecoder
    extends AutoConvertingTextDecoder<ACLItem> {
        TxtDecoder() {
            super(ACLItem::toString);
        }

        @Override
        public Class<ACLItem> getDefaultClass() {
            return ACLItem.class;
        }

        @Override
        protected ACLItem decodeNativeValue(Context context, Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Class<?> targetClass, Object targetContext) throws IOException, ParseException {
            return ACLItem.parse(buffer.toString());
        }
    }
}

