/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.PGSQLIntegrityConstraintViolationException;
import com.impossibl.postgres.jdbc.PGSQLSimpleException;
import com.impossibl.postgres.protocol.Notice;
import com.impossibl.postgres.protocol.RequestExecutorHandlers;
import com.impossibl.postgres.system.NoticeException;
import com.impossibl.postgres.utils.guava.Strings;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Iterator;
import java.util.List;

public class ErrorUtils {
    public static SQLWarning makeSQLWarningChain(List<Notice> notices) {
        Iterator<Notice> noticeIter = notices.iterator();
        SQLWarning root = null;
        if (noticeIter.hasNext()) {
            SQLWarning current = root = ErrorUtils.makeSQLWarning(noticeIter.next());
            while (noticeIter.hasNext()) {
                Notice notice = noticeIter.next();
                if (!notice.isWarning()) continue;
                SQLWarning nextWarning = ErrorUtils.makeSQLWarning(notice);
                current.setNextWarning(nextWarning);
                current = nextWarning;
            }
        }
        return root;
    }

    public static SQLException makeSQLExceptionChain(List<Notice> notices) {
        Iterator<Notice> noticeIter = notices.iterator();
        SQLException root = null;
        if (noticeIter.hasNext()) {
            SQLException current = root = ErrorUtils.makeSQLException("", noticeIter.next());
            while (noticeIter.hasNext()) {
                SQLException nextException = ErrorUtils.makeSQLException("", noticeIter.next());
                current.setNextException(nextException);
                current = nextException;
            }
        }
        return root;
    }

    public static SQLWarning makeSQLWarning(Notice notice) {
        return new SQLWarning(notice.getMessage(), notice.getCode());
    }

    public static SQLException makeSQLException(String messagePrefix, String sqlState, Exception cause) {
        if (cause instanceof NoticeException) {
            return ErrorUtils.makeSQLException(messagePrefix, ((NoticeException)cause).getNotice());
        }
        String message = cause != null && cause.getMessage() != null ? cause.getMessage() : "Unknown";
        return new PGSQLSimpleException(messagePrefix + message, sqlState, cause);
    }

    public static SQLException makeSQLException(String message, Exception cause) {
        if (cause instanceof SQLException) {
            return (SQLException)cause;
        }
        if (cause instanceof NoticeException) {
            return ErrorUtils.makeSQLException(message, cause);
        }
        return new PGSQLSimpleException(message, cause);
    }

    public static SQLException makeSQLException(Exception cause) {
        if (cause instanceof SQLException) {
            return (SQLException)cause;
        }
        if (cause instanceof NoticeException) {
            return ErrorUtils.makeSQLException(((NoticeException)cause).getNotice());
        }
        return new PGSQLSimpleException(cause.getMessage(), cause);
    }

    public static SQLException makeSQLException(Notice notice) {
        return ErrorUtils.makeSQLException("", notice);
    }

    public static SQLException makeSQLException(String messagePrefix, Notice notice) {
        String code = notice.getCode();
        SQLException e = code.startsWith("23") ? new PGSQLIntegrityConstraintViolationException(messagePrefix + Strings.nullToEmpty(notice.getMessage()), notice.getCode()) : new PGSQLSimpleException(messagePrefix + Strings.nullToEmpty(notice.getMessage()), notice.getCode());
        e.setSchema(notice.getSchema());
        e.setTable(notice.getTable());
        e.setColumn(notice.getColumn());
        e.setDatatype(notice.getDatatype());
        e.setConstraint(notice.getConstraint());
        return e;
    }

    public static SQLWarning chainWarnings(SQLWarning base, SQLWarning add) {
        if (base == null) {
            return add;
        }
        SQLWarning current = base;
        while (current.getNextWarning() != null) {
            current = current.getNextWarning();
        }
        current.setNextWarning(add);
        return base;
    }

    public static SQLWarning chainWarnings(SQLWarning base, RequestExecutorHandlers.Result result) {
        if (result.getNotices().isEmpty()) {
            return base;
        }
        return ErrorUtils.chainWarnings(base, ErrorUtils.makeSQLWarningChain(result.getNotices()));
    }
}

