/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.utils;

import java.util.concurrent.TimeUnit;

public class Await {
    public static boolean awaitUninterruptibly(long timeout, TimeUnit timeoutUnits, InterruptibleTimeoutFunction waiter) {
        if (timeout < 1L) {
            timeout = Long.MAX_VALUE;
        }
        while (timeout > 0L) {
            long start = System.currentTimeMillis();
            try {
                return waiter.await(timeout, timeoutUnits);
            }
            catch (InterruptedException interruptedException) {
                timeout -= timeoutUnits.convert(System.currentTimeMillis() - start, TimeUnit.MILLISECONDS);
            }
        }
        return false;
    }

    public static void awaitUninterruptibly(InterruptibleFunction waiter) {
        while (true) {
            try {
                waiter.await();
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public static interface InterruptibleFunction {
        public void await() throws InterruptedException;
    }

    public static interface InterruptibleTimeoutFunction {
        public boolean await(long var1, TimeUnit var3) throws InterruptedException;
    }
}

