/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.jdbc.PGBlob;
import com.impossibl.postgres.jdbc.PGBufferBlob;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.ConversionException;
import com.impossibl.postgres.system.SystemSettings;
import com.impossibl.postgres.system.procs.BaseBinaryDecoder;
import com.impossibl.postgres.system.procs.BaseBinaryEncoder;
import com.impossibl.postgres.system.procs.BaseTextDecoder;
import com.impossibl.postgres.system.procs.BaseTextEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.guava.ByteStreams;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class Bytes
extends SimpleProcProvider {
    private static final char[] HEX_CHARS = "0123456789ABCDEF".toCharArray();

    public Bytes() {
        super((Type.Codec.Encoder<StringBuilder>)new TxtEncoder(), (Type.Codec.Decoder<CharSequence>)new TxtDecoder(), (Type.Codec.Encoder<ByteBuf>)new BinEncoder(), (Type.Codec.Decoder<ByteBuf>)new BinDecoder(), "bytea");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] coerceInput(Type type, Object source, Long length) throws IOException {
        if (source instanceof byte[]) {
            return (byte[])source;
        }
        if (source instanceof InputStream) {
            InputStream is = (InputStream)source;
            if (length == null) return ByteStreams.toByteArray(is);
            is = ByteStreams.limit(is, length);
            return ByteStreams.toByteArray(is);
        }
        if (!(source instanceof PGBlob)) throw new ConversionException(source.getClass(), type);
        PGBlob blob = (PGBlob)source;
        try (InputStream in = blob.getBinaryStream();){
            byte[] byArray = ByteStreams.toByteArray(in);
            return byArray;
        }
        catch (SQLException e) {
            throw new IOException("Error loading blob data", e);
        }
    }

    private static Object convertOutput(Context context, Type type, ByteBuf decoded, Class<?> targetClass) throws ConversionException {
        if (targetClass == InputStream.class) {
            return new ByteBufInputStream(decoded, true);
        }
        if (targetClass == byte[].class) {
            byte[] bytes = new byte[decoded.readableBytes()];
            decoded.readBytes(bytes);
            decoded.release();
            return bytes;
        }
        if (targetClass == String.class) {
            byte[] bytes = new byte[decoded.readableBytes()];
            decoded.readBytes(bytes);
            decoded.release();
            return new String(bytes, context.getCharset());
        }
        if (targetClass == Blob.class) {
            return new PGBufferBlob(decoded.retainedDuplicate());
        }
        throw new ConversionException(type, targetClass);
    }

    public static byte[] decodeHex(CharSequence buffer) throws ConversionException {
        return Bytes.decodeHex(buffer, false);
    }

    public static byte[] decodeHex(CharSequence buffer, boolean ignoreDelimeters) throws ConversionException {
        int hexChars = 0;
        block6: for (int i = 0; i < buffer.length(); ++i) {
            char ch = buffer.charAt(i);
            switch (ch) {
                case ',': 
                case '-': 
                case '.': 
                case ':': 
                case '_': {
                    continue block6;
                }
                default: {
                    if (ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F' || ch >= '0' && ch <= '9') {
                        ++hexChars;
                        continue block6;
                    }
                    if (ignoreDelimeters) continue block6;
                    throw new ConversionException("Invalid hex input");
                }
            }
        }
        if (hexChars % 2 != 0) {
            throw new ConversionException("Invalid hex input");
        }
        int length = buffer.length();
        byte[] data = new byte[hexChars / 2];
        int i = 0;
        int j = 0;
        while (i < length) {
            char ch = buffer.charAt(i);
            switch (ch) {
                case ',': 
                case '-': 
                case '.': 
                case ':': 
                case '_': {
                    ch = buffer.charAt(++i);
                }
            }
            char ch2 = buffer.charAt(i + 1);
            data[j] = (byte)((Character.digit(ch, 16) << 4) + Character.digit(ch2, 16));
            i += 2;
            ++j;
        }
        return data;
    }

    public static String encodeHex(byte[] value) {
        StringBuilder out = new StringBuilder();
        Bytes.encodeHex(value, out);
        return out.toString();
    }

    public static void encodeHex(byte[] value, StringBuilder buffer) {
        buffer.ensureCapacity(buffer.capacity() + value.length * 2);
        for (byte b : value) {
            buffer.append(HEX_CHARS[b >>> 4 & 0xF]).append(HEX_CHARS[b & 0xF]);
        }
    }

    static class TxtEncoder
    extends BaseTextEncoder {
        TxtEncoder() {
        }

        @Override
        protected void encodeValue(Context context, Type type, Object val, Object sourceContext, StringBuilder buffer) throws IOException {
            Long specifiedLength = (Long)sourceContext;
            byte[] value = Bytes.coerceInput(type, val, specifiedLength);
            if (specifiedLength != null && specifiedLength != (long)value.length) {
                throw new IOException("Mismatch in length of binary arguments");
            }
            buffer.append("\\x");
            Bytes.encodeHex(value, buffer);
        }
    }

    static class TxtDecoder
    extends BaseTextDecoder {
        TxtDecoder() {
            this.enableRespectMaxLength();
        }

        @Override
        public Class<?> getDefaultClass() {
            return InputStream.class;
        }

        @Override
        protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Class<?> targetClass, Object targetContext) throws IOException {
            ByteBuf bytes = buffer.length() > 2 && buffer.charAt(0) == '\\' && buffer.charAt(1) == 'x' ? Unpooled.wrappedBuffer((byte[])Bytes.decodeHex(buffer.subSequence(2, buffer.length()))) : this.decodeEscape(buffer);
            try {
                return Bytes.convertOutput(context, type, bytes, targetClass);
            }
            catch (Throwable t) {
                bytes.release();
                throw t;
            }
        }

        ByteBuf decodeEscape(CharSequence buffer) {
            int length = buffer.length();
            ByteBuf data = Unpooled.buffer((int)length);
            try {
                for (int i = 0; i < length; ++i) {
                    char ch = buffer.charAt(i);
                    if (ch == '\\') {
                        char ch1;
                        if ((ch1 = buffer.charAt(++i)) == '\\') {
                            data.writeByte(92);
                        }
                        if (i == length - 1) break;
                        char ch2 = buffer.charAt(++i);
                        char ch3 = buffer.charAt(++i);
                        data.writeByte((int)((byte)(ch1 * 64 + ch2 * 8 + ch3)));
                    }
                    data.writeByte((int)((byte)ch));
                }
                return data.capacity(data.writerIndex());
            }
            catch (Throwable t) {
                data.release();
                throw t;
            }
        }
    }

    static class BinEncoder
    extends BaseBinaryEncoder {
        BinEncoder() {
        }

        @Override
        protected void encodeValue(Context context, Type type, Object val, Object sourceContext, ByteBuf buffer) throws IOException {
            Long specifiedLength = (Long)sourceContext;
            byte[] value = Bytes.coerceInput(type, val, specifiedLength);
            if (specifiedLength != null && specifiedLength != (long)value.length) {
                throw new IOException("Invalid binary length");
            }
            buffer.writeBytes(value);
        }
    }

    static class BinDecoder
    extends BaseBinaryDecoder {
        BinDecoder() {
            this.enableRespectMaxLength();
        }

        @Override
        public Class<?> getDefaultClass() {
            return InputStream.class;
        }

        @Override
        protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Class<?> targetClass, Object targetContext) throws IOException {
            int length = buffer.readableBytes();
            Integer maxLength = context.getSetting(SystemSettings.FIELD_LENGTH_MAX);
            int readLength = maxLength != null ? Math.min(maxLength, length) : length;
            ByteBuf bytes = buffer.readRetainedSlice(readLength);
            try {
                buffer.skipBytes(length - readLength);
                return Bytes.convertOutput(context, type, bytes, targetClass);
            }
            catch (Throwable t) {
                bytes.release();
                throw t;
            }
        }
    }
}

